/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.http;

import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

public class CustomFileNameMap
implements FileNameMap {
    private FileNameMap filenamemap = null;
    private LinkedHashMap<String, String> custommap = new LinkedHashMap();
    private LinkedHashMap<String, Integer> iconmap = new LinkedHashMap();
    public static final int FILENONE = -1;
    public static final int FILEIMAGE = 1;
    public static final int FILEAUDIO = 2;
    public static final int FILEVIDEO = 3;
    public static final int FILEDOC = 4;
    public static final int FILEPDF = 5;
    public static final int FILEPPT = 6;
    public static final int FILEEXCEL = 7;
    public static final int FILEWORD = 8;
    public static final int FILEXML = 9;
    public static final int FILEWEB = 10;
    public static final int FILEARCHIVE = 11;

    public CustomFileNameMap() {
        this.filenamemap = URLConnection.getFileNameMap();
        this.iconmap.put("image/jpeg", 1);
        this.iconmap.put("image/gif", 1);
        this.iconmap.put("image/png", 1);
        this.iconmap.put("image/bmp", 1);
        this.iconmap.put("image/tiff", 1);
        this.iconmap.put("audio/mpeg", 2);
        this.iconmap.put("audio/x-wav", 2);
        this.iconmap.put("audio/x-ms-wma", 2);
        this.iconmap.put("application/ogg", 2);
        this.iconmap.put("audio/midi", 2);
        this.iconmap.put("video/quicktime", 3);
        this.iconmap.put("video/mpeg", 3);
        this.iconmap.put("video/3gpp", 3);
        this.iconmap.put("video/mp4", 3);
        this.iconmap.put("video/x-ms-wmv", 3);
        this.iconmap.put("application/pdf", 5);
        this.iconmap.put("application/vnd.ms-powerpoint", 6);
        this.iconmap.put("application/vnd.ms-excel", 7);
        this.iconmap.put("application/msword", 8);
        this.iconmap.put("application/rtf", 4);
        this.iconmap.put("text/plain", 4);
        this.iconmap.put("text/html", 10);
        this.iconmap.put("text/xml", 9);
        this.iconmap.put("application/zip", 11);
        this.iconmap.put("application/x-gzip", 11);
        this.iconmap.put("application/x-rar-compressed", 11);
        this.iconmap.put("application/java-archive", 11);
        this.iconmap.put("application/tar", 11);
        this.iconmap.put("application/x-unix-archive", 11);
        this.iconmap.put("application/x-cpio", 11);
        this.iconmap.put("application/bzip2", 11);
    }

    public static boolean isSupportedArchive(String string) {
        boolean bl = false;
        if (string != null && (string.equalsIgnoreCase("application/zip") || string.equalsIgnoreCase("application/java-archive") || string.equalsIgnoreCase("application/x-gzip") || string.equalsIgnoreCase("application/tar") || string.equalsIgnoreCase("application/x-cpio") || string.equalsIgnoreCase("application/x-unix-archive"))) {
            bl = true;
        }
        return bl;
    }

    public void updateMap(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
                String string3 = stringTokenizer2.nextToken();
                String string4 = null;
                if (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken();
                }
                if (string4 == null || string3 == null) continue;
                this.custommap.put(string4.toLowerCase(), string3);
            }
        }
    }

    public String getExtensionFor(String string) {
        String string2 = null;
        if (string != null) {
            for (String string3 : this.custommap.keySet()) {
                String string4 = this.custommap.get(string3);
                if (!string.equalsIgnoreCase(string4)) continue;
                string2 = string3;
                break;
            }
        }
        return string2;
    }

    public String getContentTypeFor(String string) {
        String string2 = null;
        if (string != null && (string2 = this.getCustomContentTypeFor(string)) == null) {
            string2 = this.filenamemap.getContentTypeFor(string);
        }
        return string2;
    }

    private String getCustomContentTypeFor(String string) {
        String string2 = null;
        int n = string.lastIndexOf(".");
        if (n > -1) {
            String string3 = string.substring(n, string.length());
            string2 = this.custommap.get(string3.toLowerCase());
        }
        return string2;
    }

    public int getIconFor(String string) {
        int n = -1;
        if (string != null && this.iconmap.containsKey(string.toLowerCase())) {
            n = this.iconmap.get(string.toLowerCase());
        }
        return n;
    }
}

