/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.http;

import com.sun.java.browser.net.ProxyInfo;
import com.sun.java.browser.net.ProxyService;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jfileupload.transfer.client.core.AbstractTransferController;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.http.CustomFileNameMap;
import jfileupload.transfer.client.http.HttpClientFactory;
import jfileupload.transfer.client.http.MkColMethod;
import jfileupload.transfer.client.mdesign.AuthenticationModel;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HTTPTransfer
extends AbstractTransferController {
    private static final Log log = LogFactory.getLog(HTTPTransfer.class);
    public static final String CONTENTRANGE = "Content-Range";
    public static String COOKIENAME = "cookiename";
    public static String COOKIEPATH = "cookiepath";
    public static String COOKIEVALUE = "cookievalue";
    public static String COOKIEOVERWRITE = "cookieoverwrite";
    public static String COOKIECLEAR = "cookieclear";
    public static String COOKIEHEADER = "cookieheader";
    public static String COOKIESOURCE = "cookiesource";
    public static String MIMETYPES = "mimetypes";
    public static String ERRORHEADER = "errorheader";
    public static String HTTPPROXYHOST = "httpproxyhost";
    public static String HTTPPROXYPORT = "httpproxyport";
    public static String HTTPPROXYUSERNAME = "httpproxyusername";
    public static String HTTPPROXYPASSWORD = "httpproxypassword";
    public static String HTTPPROXYNTLMHOST = "httpproxyntlmhost";
    public static String HTTPPROXYNTLMDOMAIN = "httpproxyntlmdomain";
    public static String HTTPNTLMHOST = "httpntlmhost";
    public static String HTTPNTLMDOMAIN = "httpntlmdomain";
    public static String HTTPAUTHMETHOD = "httpauthmethod";
    public static String WEAKSSL = "weakssl";
    public static String DEPRECATEDURL = "url";
    public static String STATUSCODEKEY = "statuscode";
    public static String SYNCACTION = "syncaction";
    public static String FORCESYNC = "forcesync";
    private CustomFileNameMap filenamemap = new CustomFileNameMap();
    private HashMap customparameters = new HashMap();
    private HttpClient client = null;
    private boolean cookieoverwrite = false;
    private boolean cookieclear = false;
    private String proxyhost = null;
    private int proxyport = -1;

    public void init() throws ClientException {
        int n;
        super.init();
        this.registerSSLSocketFactory();
        HttpClientFactory httpClientFactory = HttpClientFactory.getInstance();
        httpClientFactory.setConcurrency(this.getRawConf().getProperty("concurrency"));
        this.client = httpClientFactory.getClient();
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(this.getServerUrl().getHost(), this.getServerUrl().getPort(), this.getServerUrl().getProtocol());
        this.client.setHostConfiguration(hostConfiguration);
        long l = this.getTimeOut();
        if (l > 0L) {
            this.client.getParams().setSoTimeout((int)l);
        }
        if ((n = (int)this.getRawConf().getLong(this.getRawConf().getProperty("buffersize"))) > 0) {
            this.client.getHttpConnectionManager().getParams().setSendBufferSize(n);
            this.client.getHttpConnectionManager().getParams().setReceiveBufferSize(n);
            log.info((Object)("HTTP in/out buffer size = " + n));
        }
        this.client.getParams().setParameter("http.useragent", (Object)Conf.UA);
        if (this.getEncoding() != null) {
            this.client.getParams().setParameter("http.protocol.element-charset", (Object)this.getEncoding());
        }
        if (this.getRetry() != -1) {
            this.client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        }
        this.autoDetectProxy(this.getServerUrl());
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        TreeMap treeMap = new TreeMap();
        Iterator iterator = null;
        if (super.getParameters(null) != null) {
            for (String string5 : super.getParameters(null).keySet()) {
                String string6 = (String)super.getParameters(null).get(string5);
                log.debug((Object)(string5 + ":" + string6));
                if (string5.startsWith(COOKIENAME) || string5.startsWith(COOKIEVALUE) || string5.startsWith(COOKIEPATH) || string5.startsWith(COOKIEOVERWRITE) || string5.startsWith(COOKIECLEAR)) {
                    this.loadCookie(string5, string6, treeMap);
                    continue;
                }
                if (string5.equalsIgnoreCase(HTTPPROXYHOST) || string5.equalsIgnoreCase(HTTPPROXYPORT) || string5.equalsIgnoreCase(HTTPPROXYUSERNAME) || string5.equalsIgnoreCase(HTTPPROXYPASSWORD) || string5.equalsIgnoreCase(HTTPPROXYNTLMHOST) || string5.equalsIgnoreCase(HTTPPROXYNTLMDOMAIN)) {
                    if (string5.equalsIgnoreCase(HTTPPROXYUSERNAME)) {
                        string = string6;
                    }
                    if (string5.equalsIgnoreCase(HTTPPROXYPASSWORD)) {
                        string2 = string6;
                    }
                    if (string5.equalsIgnoreCase(HTTPPROXYNTLMHOST)) {
                        string3 = string6;
                    }
                    if (string5.equalsIgnoreCase(HTTPPROXYNTLMDOMAIN)) {
                        string4 = string6;
                    }
                    if (string5.equalsIgnoreCase(HTTPPROXYHOST)) {
                        this.proxyhost = string6;
                    }
                    if (!string5.equalsIgnoreCase(HTTPPROXYPORT)) continue;
                    try {
                        this.proxyport = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.info((Object)"Cannot load proxy port", (Throwable)numberFormatException);
                    }
                    continue;
                }
                if (string5.equalsIgnoreCase(MIMETYPES)) {
                    this.getCustomFilenameMap().updateMap(string6);
                    continue;
                }
                if (string5.equalsIgnoreCase(WEAKSSL) || string5.equalsIgnoreCase(HTTPAUTHMETHOD)) continue;
                if (string5.equalsIgnoreCase(COOKIEHEADER)) {
                    if (!string6.equalsIgnoreCase("singleline")) continue;
                    this.client.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
                    continue;
                }
                this.customparameters.put(string5, string6);
            }
        }
        if (this.proxyhost != null && this.proxyport != -1 && !this.proxyhost.equals("")) {
            log.info((Object)("HTTP proxy enabled : " + this.proxyhost + ":" + this.proxyport));
            this.client.getHostConfiguration().setProxy(this.proxyhost, this.proxyport);
        }
        this.setupCookies(this.client, treeMap);
    }

    protected void setupCookies(HttpClient httpClient, TreeMap object) {
        String string = (String)this.getCustomParameters().get(COOKIESOURCE);
        if (string != null && string.equalsIgnoreCase("jse")) {
            TreeMap treeMap = this.loadCookiesFromHandler(this.getServerUrl());
            treeMap.putAll(object);
            object = treeMap;
        }
        for (String string2 : ((TreeMap)object).keySet()) {
            Cookie cookie = (Cookie)((TreeMap)object).get(string2);
            HttpState httpState = httpClient.getState();
            if (httpState == null) {
                httpState = new HttpState();
            }
            if (this.cookieclear) {
                httpState.clearCookies();
            }
            boolean bl = false;
            Cookie[] cookieArray = httpState.getCookies();
            if (cookieArray != null && cookieArray.length > 0) {
                for (int i = 0; i < cookieArray.length; ++i) {
                    Cookie cookie2 = cookieArray[i];
                    if (!cookie2.getName().equalsIgnoreCase(cookie.getName())) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl || this.cookieoverwrite) {
                httpState.addCookie(cookie);
            }
            httpClient.getParams().setCookiePolicy("compatibility");
            httpClient.setState(httpState);
        }
    }

    protected Cookie loadCookie(String string, String string2, TreeMap treeMap) {
        Cookie cookie = null;
        String string3 = "cookie";
        if (string != null && string2 != null && treeMap != null && (string.startsWith(COOKIENAME) || string.startsWith(COOKIEVALUE) || string.startsWith(COOKIEPATH) || string.startsWith(COOKIEOVERWRITE) || string.startsWith(COOKIECLEAR))) {
            int n = -1;
            try {
                n = Integer.parseInt(string.substring(string.length() - 1, string.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                n = 0;
            }
            if ((cookie = (Cookie)treeMap.get(string3 = string3 + n)) == null) {
                cookie = new Cookie();
                cookie.setDomain(this.getServerUrl().getHost());
                cookie.setPath("/");
                treeMap.put(string3, cookie);
            }
            if (string.startsWith(COOKIENAME)) {
                cookie.setName(string2);
            }
            if (string.startsWith(COOKIEVALUE)) {
                cookie.setValue(string2);
            }
            if (string.startsWith(COOKIEPATH)) {
                cookie.setPath(string2);
            }
            if (string.startsWith(COOKIEOVERWRITE) && string2.equalsIgnoreCase("true")) {
                this.cookieoverwrite = true;
            }
            if (string.startsWith(COOKIECLEAR) && string2.equalsIgnoreCase("true")) {
                this.cookieclear = true;
            }
        }
        return cookie;
    }

    protected TreeMap loadCookiesFromHandler(URL uRL) {
        TreeMap<String, Cookie> treeMap;
        block10: {
            treeMap = new TreeMap<String, Cookie>();
            if (uRL != null) {
                String string = uRL.toExternalForm();
                try {
                    Class<?> clazz = Class.forName("java.net.CookieHandler");
                    Method method = clazz.getMethod("getDefault", null);
                    Object object = method.invoke(null, null);
                    if (object != null) {
                        method = clazz.getMethod("get", URI.class, Map.class);
                        Map map = (Map)method.invoke(object, URI.create(string), new HashMap());
                        if (map != null) {
                            List list = (List)map.get("Cookie");
                            log.debug((Object)("Cookies loaded from CookieHandler for (" + string + "): " + list));
                            if (list != null) {
                                Iterator iterator = list.iterator();
                                int n = 0;
                                while (iterator.hasNext()) {
                                    int n2;
                                    String string2 = (String)iterator.next();
                                    if (string2 == null || (n2 = string2.indexOf("=")) == -1) continue;
                                    String string3 = string2.substring(0, n2);
                                    String string4 = string2.substring(n2 + 1, string2.length());
                                    if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                                    TreeMap treeMap2 = new TreeMap();
                                    Cookie cookie = this.loadCookie(COOKIENAME, string3, treeMap2);
                                    cookie = this.loadCookie(COOKIEVALUE, string4, treeMap2);
                                    if (cookie == null) continue;
                                    treeMap.put("cookiehandler" + n, cookie);
                                    ++n;
                                }
                            } else {
                                log.error((Object)("Cannot get cookies for: " + string));
                            }
                        } else {
                            log.error((Object)("Cannot get headers for: " + string));
                        }
                        break block10;
                    }
                    log.error((Object)"CookieHandler not available");
                }
                catch (Exception exception) {
                    log.error((Object)exception);
                }
            } else {
                log.error((Object)"No URL for CookieHandler");
            }
        }
        return treeMap;
    }

    public void registerSSLSocketFactory() {
        String string;
        if (super.getParameters(null) != null && (string = (String)super.getParameters(null).get(WEAKSSL)) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("dummy"))) {
            try {
                Class<?> clazz = null;
                clazz = string.equalsIgnoreCase("dummy") ? Class.forName("jfileupload.transfer.client.http.DummySSLProtocolSocketFactory") : Class.forName("org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory");
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                SecureProtocolSocketFactory secureProtocolSocketFactory = (SecureProtocolSocketFactory)constructor.newInstance(null);
                Protocol protocol = new Protocol("https", (ProtocolSocketFactory)secureProtocolSocketFactory, 443);
                Protocol.registerProtocol((String)"https", (Protocol)protocol);
                log.info((Object)"WeakSSL registered for HTTPS");
            }
            catch (Exception exception) {
                log.error((Object)"Cannot register WeakSSL for HTTPS", (Throwable)exception);
            }
        }
    }

    protected void autoDetectProxy(URL uRL) {
        ProxyInfo[] proxyInfoArray;
        Serializable serializable;
        block12: {
            this.proxyhost = System.getProperty("http.proxyHost");
            this.proxyport = -1;
            if (System.getProperty("http.proxyPort") != null) {
                try {
                    this.proxyport = Integer.parseInt(System.getProperty("http.proxyPort"));
                }
                catch (NumberFormatException numberFormatException) {
                    log.info((Object)"Cannot load system proxy port", (Throwable)numberFormatException);
                }
            }
            log.debug((Object)("Auto-detect proxy settings : http.proxyHost = " + this.proxyhost));
            log.debug((Object)("Auto-detect proxy settings : http.proxyPort = " + this.proxyport));
            if (this.proxyhost == null || this.proxyhost.equals("")) {
                try {
                    serializable = new URI(uRL.toString());
                    proxyInfoArray = Class.forName("java.net.ProxySelector");
                    Method method = proxyInfoArray.getMethod("getDefault", null);
                    Object object = method.invoke(null, null);
                    method = object.getClass().getMethod("select", URI.class);
                    List list = (List)method.invoke(object, serializable);
                    if (list == null) break block12;
                    for (Object e : list) {
                        method = e.getClass().getMethod("type", null);
                        log.debug((Object)("Auto-detect proxy settings (ps): " + method.invoke(e, null)));
                        method = e.getClass().getMethod("address", null);
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)method.invoke(e, null);
                        if (inetSocketAddress == null) continue;
                        this.proxyhost = inetSocketAddress.getHostName();
                        this.proxyport = inetSocketAddress.getPort();
                        break;
                    }
                }
                catch (Exception exception) {
                    log.debug((Object)("Auto-detect proxy settings (ps): " + exception.getMessage()));
                }
            }
        }
        if (this.proxyhost == null || this.proxyhost.equals("")) {
            try {
                serializable = Class.forName("com.sun.java.browser.net.ProxyService");
                proxyInfoArray = ProxyService.getProxyInfo((URL)uRL);
                if (proxyInfoArray != null && proxyInfoArray.length > 0 && proxyInfoArray[0] != null) {
                    this.proxyhost = proxyInfoArray[0].getHost();
                    this.proxyport = proxyInfoArray[0].getPort();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.debug((Object)("Auto-detect proxy settings (wka): " + classNotFoundException.getMessage()));
            }
            catch (IOException iOException) {
                log.debug((Object)("Auto-detect proxy settings (wka): " + iOException.getMessage()));
            }
        }
        log.debug((Object)("Auto-detect proxy settings : host = " + this.proxyhost));
        log.debug((Object)("Auto-detect proxy settings : port = " + this.proxyport));
    }

    public String getHostname() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            log.info((Object)"Cannot get hostname", (Throwable)unknownHostException);
        }
        return string;
    }

    public Map headInfo(String string, Map map, boolean bl) throws ClientException {
        String string2;
        String string3;
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        MkColMethod mkColMethod = null;
        mkColMethod = bl ? new MkColMethod(string) : new HeadMethod(string);
        try {
            if (map != null) {
                object = map.keySet().iterator();
                while (object.hasNext()) {
                    string3 = (String)object.next();
                    string2 = (String)map.get(string3);
                    mkColMethod.setRequestHeader(string3, string2);
                }
            }
            n = this.getClient().executeMethod((HttpMethod)mkColMethod);
        }
        catch (HttpException httpException) {
            log.error((Object)httpException);
            throw new ClientException((Throwable)httpException);
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new ClientException((Throwable)iOException);
        }
        hashMap.put(STATUSCODEKEY, String.valueOf(n));
        if (bl) {
            log.info((Object)("MkCol Status code = " + n));
        } else {
            log.info((Object)("Head Status code = " + n));
        }
        if (n != 200 && n != 404 && n != 204 && n != 201) {
            object = mkColMethod.getStatusLine().toString();
            if (this.getCustomParameters() != null && (string3 = (String)this.getCustomParameters().get(ERRORHEADER)) != null && (string2 = mkColMethod.getResponseHeader(string3)) != null) {
                object = string2.getValue();
            }
            mkColMethod.releaseConnection();
            throw new ClientException("server error", (String)object);
        }
        if (n != 404 && (object = mkColMethod.getResponseHeaders()) != null && ((Header[])object).length > 0) {
            for (int i = 0; i < ((Header[])object).length; ++i) {
                string2 = object[i];
                String string4 = string2.getName();
                String string5 = string2.getValue();
                if (string4 == null || string5 == null) continue;
                hashMap.put(string4, string5);
            }
        }
        mkColMethod.releaseConnection();
        mkColMethod = null;
        return hashMap;
    }

    public void authenticate() {
        if (this.getAuthentication() != null && this.getAuthentication().equalsIgnoreCase("auto")) {
            boolean bl = false;
            int n = 0;
            while (!bl && n++ < 3) {
                Object object = null;
                String string = (String)super.getParameters(null).get(HTTPAUTHMETHOD);
                object = string != null && string.equalsIgnoreCase("get") ? new GetMethod(this.getServerUrl().toExternalForm()) : new HeadMethod(this.getServerUrl().toExternalForm());
                try {
                    Object object2;
                    String string2;
                    int n2 = this.getClient().executeMethod((HttpMethod)object);
                    AuthenticationModel authenticationModel = new AuthenticationModel();
                    if (n2 == 407) {
                        Object object3;
                        authenticationModel.setHttp(true);
                        authenticationModel.setProxy(true);
                        string2 = this.proxyhost;
                        if (this.proxyport > 0) {
                            string2 = string2 + ":" + this.proxyport;
                        }
                        authenticationModel.setServer(string2);
                        object2 = (String)super.getParameters(null).get(HTTPPROXYUSERNAME);
                        if (object2 == null) {
                            object2 = System.getProperty("user.name");
                        }
                        authenticationModel.setUsername((String)object2);
                        String string3 = (String)super.getParameters(null).get(HTTPPROXYPASSWORD);
                        if (string3 != null) {
                            authenticationModel.setPassword(string3.toCharArray());
                        }
                        this.parseAuthenticateHeader(object.getResponseHeader("Proxy-Authenticate"), authenticationModel);
                        if (authenticationModel.isNTLM()) {
                            authenticationModel.setDomain((String)super.getParameters(null).get(HTTPPROXYNTLMDOMAIN));
                            object3 = (String)super.getParameters(null).get(HTTPPROXYNTLMHOST);
                            if (object3 == null) {
                                object3 = this.getHostname();
                            }
                            authenticationModel.setHost((String)object3);
                        }
                        if ((object3 = this.authenticate(authenticationModel, n)) == null) break;
                        super.getParameters(null).put(HTTPPROXYUSERNAME, ((PasswordAuthentication)object3).getUserName());
                        super.getParameters(null).put(HTTPPROXYPASSWORD, new String(((PasswordAuthentication)object3).getPassword()));
                        if (authenticationModel.isNTLM()) {
                            super.getParameters(null).put(HTTPPROXYNTLMDOMAIN, authenticationModel.getDomain());
                            super.getParameters(null).put(HTTPPROXYNTLMHOST, authenticationModel.getHost());
                        }
                        this.setProxyAuthentication(null);
                        continue;
                    }
                    if (n2 != 401) break;
                    string2 = this.getServerUrl().getHost();
                    if (this.getServerUrl().getPort() > 0) {
                        string2 = string2 + ":" + this.getServerUrl().getPort();
                    }
                    authenticationModel.setServer(string2);
                    authenticationModel.setUsername(this.getUsername());
                    if (this.getPassword() != null) {
                        authenticationModel.setPassword(this.getPassword().toCharArray());
                    }
                    authenticationModel.setHttp(true);
                    authenticationModel.setProxy(false);
                    this.parseAuthenticateHeader(object.getResponseHeader("WWW-Authenticate"), authenticationModel);
                    if (authenticationModel.isNTLM()) {
                        authenticationModel.setDomain((String)super.getParameters(null).get(HTTPNTLMDOMAIN));
                        object2 = (String)super.getParameters(null).get(HTTPNTLMHOST);
                        if (object2 == null) {
                            object2 = this.getHostname();
                        }
                        authenticationModel.setHost((String)object2);
                    }
                    if ((object2 = this.authenticate(authenticationModel, n)) == null) break;
                    this.getRawConf().getProperties().setProperty("username", ((PasswordAuthentication)object2).getUserName());
                    this.getRawConf().getProperties().setProperty("password", new String(((PasswordAuthentication)object2).getPassword()));
                    if (authenticationModel.isNTLM()) {
                        super.getParameters(null).put(HTTPNTLMDOMAIN, authenticationModel.getDomain());
                        super.getParameters(null).put(HTTPNTLMHOST, authenticationModel.getHost());
                    }
                    this.setWWWAuthentication(null);
                }
                catch (Exception exception) {
                    log.error((Object)exception);
                }
            }
        }
    }

    protected void parseAuthenticateHeader(Header header, AuthenticationModel authenticationModel) {
        String string;
        if (header != null && (string = header.getValue()) != null) {
            int n = string.indexOf("realm=");
            if (n > 0) {
                String string2 = string.substring(n + 7, string.length() - 1);
                String string3 = string.substring(0, n).trim();
                authenticationModel.setRealm(string2);
                authenticationModel.setScheme(string3);
                if (string3.toLowerCase().startsWith("ntlm")) {
                    authenticationModel.setNTLM(true);
                }
            } else if (string.toLowerCase().indexOf("ntlm") >= 0) {
                authenticationModel.setNTLM(true);
                authenticationModel.setScheme("NTLM");
            }
        }
    }

    protected void setWWWAuthentication(HashMap hashMap) {
        HashMap hashMap2 = null;
        hashMap2 = hashMap == null ? super.getParameters(null) : hashMap;
        String string = this.getUsername();
        String string2 = this.getPassword();
        if (string != null && string2 != null) {
            UsernamePasswordCredentials usernamePasswordCredentials = null;
            if (super.getParameters(null) != null) {
                String string3 = (String)hashMap2.get(HTTPNTLMDOMAIN);
                String string4 = (String)hashMap2.get(HTTPNTLMHOST);
                if (string3 != null) {
                    if (string4 == null) {
                        string4 = this.getHostname();
                    }
                    log.info((Object)("Hostname for NTLM: " + string4));
                    usernamePasswordCredentials = new NTCredentials(string, string2, string4, string3);
                }
            }
            if (usernamePasswordCredentials == null) {
                usernamePasswordCredentials = new UsernamePasswordCredentials(string, string2);
                this.client.getParams().setAuthenticationPreemptive(this.getPreemptiveAuth());
            }
            this.client.getState().setCredentials(new AuthScope(this.getServerUrl().getHost(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)usernamePasswordCredentials);
            log.info((Object)"HTTP credentials set");
        }
    }

    protected void setProxyAuthentication(HashMap hashMap) {
        HashMap hashMap2 = null;
        hashMap2 = hashMap == null ? super.getParameters(null) : hashMap;
        if (hashMap2 != null) {
            String string = (String)hashMap2.get(HTTPPROXYHOST);
            String string2 = (String)hashMap2.get(HTTPPROXYPORT);
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                this.proxyhost = string;
                this.proxyport = -1;
                try {
                    this.proxyport = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    log.debug((Object)"Cannot load proxy port", (Throwable)numberFormatException);
                }
                log.info((Object)("HTTP proxy enabled: " + this.proxyhost + ":" + this.proxyport));
                this.client.getHostConfiguration().setProxy(this.proxyhost, this.proxyport);
            }
            String string3 = (String)hashMap2.get(HTTPPROXYUSERNAME);
            String string4 = (String)hashMap2.get(HTTPPROXYPASSWORD);
            String string5 = (String)hashMap2.get(HTTPPROXYNTLMDOMAIN);
            String string6 = (String)hashMap2.get(HTTPPROXYNTLMHOST);
            if (string3 != null && string4 != null) {
                this.client.getParams().setAuthenticationPreemptive(this.getPreemptiveAuth());
                UsernamePasswordCredentials usernamePasswordCredentials = null;
                if (string5 != null) {
                    if (string6 == null) {
                        string6 = this.getHostname();
                    }
                    log.info((Object)("Hostname for NTLM: " + string6));
                    usernamePasswordCredentials = new NTCredentials(string3, string4, string6, string5);
                } else {
                    usernamePasswordCredentials = new UsernamePasswordCredentials(string3, string4);
                }
                this.client.getState().setProxyCredentials(new AuthScope(this.proxyhost, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)usernamePasswordCredentials);
                log.info((Object)"HTTP proxy credentials set");
            }
        }
    }

    public HashMap getCustomParameters() {
        return this.customparameters;
    }

    public CustomFileNameMap getCustomFilenameMap() {
        return this.filenamemap;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public abstract void begin();

    public abstract void cancel();

    public abstract Object execute() throws ClientException;
}

