/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jfileupload.transfer.client.core.AbstractTransferController;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.SplitListener;
import jfileupload.transfer.client.core.TransferListener;
import jfileupload.transfer.client.http.CustomFilePart;
import jfileupload.transfer.client.http.CustomFilePartSource;
import jfileupload.transfer.client.http.HTTPTransfer;
import jfileupload.transfer.client.http.HttpUtil;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPUploadTransfer
extends HTTPTransfer
implements Runnable {
    private static final Log log = LogFactory.getLog(HTTPUploadTransfer.class);
    private static int THREADID = 1;
    public static String RELATIVEFILENAME = "relativefilename";
    public static String NOTIFYRELATIVEFILENAME = "notifyrelativefilename";
    public static String FULLFILENAME = "fullfilename";
    public static String SELECTEDFULLFILENAME = "selectedfullfilename";
    public static String FILETIMESTAMP = "filetimestamp";
    public static String EMPTYDIRECTORY = "emptydirectory";
    public static String CHUNKID = "chunkid";
    public static String CHUNKAMOUNT = "chunkamount";
    public static String CHUNKBASE = "chunkbase";
    public static String CHUNKBASESIZE = "chunkbasesize";
    public static String CHUNKONFLY = "chunkonfly";
    public static String ONFLYRANGE = "onflyrange";
    public static String CHUNKONFLYOFFSET = "chunkonflyoffset";
    public static String CHUNKONFLYSIZE = "chunkonflysize";
    public static String CHUNKEXTENSION = "chunkextension";
    public static String ALTCHUNKBASE = "altchunkbase";
    public static String CHUNKACTION = "chunkaction";
    public static String HTTPMETHOD = "httpmethod";
    public static String ACCOUNT = "account";
    public static String RETRYERRORHEADER = "retryonerrorheader";
    public static String RESUMEHEADER = "resumeheader";
    public static String HEADEXTRAPARAMETERS = "headextraparameters";
    public static String DELETEAFTERUPLOAD = "deleteafterupload";
    public static String DYNAMICAUTH = "dynamicauth";
    public static String MKCOL = "mkcol";
    public static String FILENAMEASHTMLENTITIES = "filenameashtmlentities";
    public static String OVERWRITEWARNFORWARDFILE = "overwritewarnforwardfile";
    public static String ROOTDIR = "rootdir";
    protected boolean cancelled = false;
    protected CustomFilePartSource source = null;
    protected CustomFilePart param = null;
    protected FileOutputStream fout = null;
    protected FileInputStream pfin = null;
    protected String uploadurl = null;
    protected String sfullfilename = null;
    protected String rfilename = null;
    protected ArrayList uploadedfiles = null;
    protected File zip = null;
    protected File processed = null;
    protected String chunkratioStr = null;
    protected boolean skipResume = false;

    public void init() throws ClientException {
        super.init();
        this.setStatus(0);
        this.chunkratioStr = this.getRawConf().getResource("progress.bar.upload.option");
        List list = this.getTarget();
        if (list == null || list.size() <= 0) {
            throw new ClientException("HTTP upload url is missing");
        }
        this.uploadurl = (String)list.get(0);
    }

    public void begin() {
        this.setStatus(0);
        HashMap hashMap = null;
        String string = (String)this.getCustomParameters().get(DYNAMICAUTH);
        if (string != null && string.equalsIgnoreCase("true")) {
            hashMap = this.getCustomParameters();
        }
        this.setProxyAuthentication(hashMap);
        this.setWWWAuthentication(hashMap);
        if (this.isThreaded()) {
            Thread thread = new Thread((Runnable)this, "HTTPUPLOAD-" + THREADID++);
            thread.start();
        } else {
            log.info((Object)"Not threaded");
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setStatus(1);
        this.cancelled = false;
        Iterator iterator = null;
        this.uploadedfiles = new ArrayList();
        ArrayList arrayList = null;
        try {
            arrayList = this.getAllowedSourceFiles();
            for (Object object2 : this.getTransferListeners()) {
                object2.transferTriggered((List)arrayList, 1);
            }
        }
        catch (ClientException clientException) {
            log.debug((Object)clientException);
            for (Object object : this.getTransferListeners()) {
                object.transferFailed(clientException);
            }
            log.info((Object)("Upload failed - Files requirements [" + Thread.currentThread().getName() + "]"));
        }
        if (!this.cancelled && arrayList != null && arrayList.size() > 0) {
            this.zip = null;
            this.processed = null;
            this.pfin = null;
            try {
                Object object;
                Object object2;
                object2 = (List)this.executeFilter(this.getSource(), "preprocessing");
                if (object2 != null) {
                    this.getSource().clear();
                    this.getSource().addAll(object2);
                }
                iterator = this.getSource().iterator();
                object = (String)this.getParameters("dynamic").get(ROOTDIR);
                while (iterator.hasNext() && !this.cancelled) {
                    File file = new File((String)iterator.next());
                    int n = file.getAbsolutePath().length();
                    int n2 = file.getName().length();
                    String string = file.getAbsolutePath();
                    if (n2 <= n) {
                        string = file.getAbsolutePath().substring(0, n - n2);
                    }
                    if (object != null) {
                        string = object;
                    }
                    this.setRootDir(string);
                    if (file.isDirectory()) {
                        if (this.getZipFolder() != null && this.getZipFolder().equalsIgnoreCase("true")) {
                            this.process(file);
                            continue;
                        }
                        this.recurseProcess(file, 0L, this.getMaxDepth());
                        continue;
                    }
                    this.process(file);
                }
                for (File file : this.getTransferListeners()) {
                    file.transferDone(this.uploadedfiles);
                }
            }
            catch (ClientException clientException) {
                if (!this.cancelled) {
                    for (Object object : this.getTransferListeners()) {
                        if (clientException instanceof ClientException) {
                            object.transferFailed(clientException);
                            continue;
                        }
                        object.transferFailed(new ClientException((Throwable)clientException));
                    }
                    log.info((Object)("Upload failed [" + Thread.currentThread().getName() + "]"));
                }
            }
            finally {
                this.deleteTmpZip();
                if (this.processed != null) {
                    this.cleanFilter();
                }
                this.cleanFilter("preprocessing");
            }
        }
        this.setStatus(2);
    }

    protected void process(File file) throws ClientException {
        String string;
        if (!this.isAllowed(file)) {
            return;
        }
        this.sfullfilename = file.getAbsolutePath();
        List list = this.getFilterIDs();
        if (list != null && list.size() > 0) {
            string = this.getFilterChain();
            boolean bl = false;
            for (String string2 : list) {
                this.processed = (File)this.executeFilter(file, string2);
                if (this.processed != null) {
                    this.processFile(this.processed);
                    if (string != null && string.equalsIgnoreCase("series")) {
                        file = this.processed;
                        continue;
                    }
                    this.cleanFilter(string2);
                    this.processed = null;
                    continue;
                }
                if (bl) continue;
                this.processFile(file);
                bl = true;
            }
        } else {
            this.processFile(file);
        }
        if (!Conf.SAFE && (string = (String)this.getCustomParameters().get(DELETEAFTERUPLOAD)) != null && string.equalsIgnoreCase("true")) {
            file.delete();
        }
        this.rfilename = null;
        this.sfullfilename = null;
    }

    protected void processFile(File file) throws ClientException {
        long l;
        AbstractTransferController.HeadInfo headInfo;
        if (this.getZipOnFly() != null && !this.getZipOnFly().equalsIgnoreCase("false")) {
            this.zip = this.compress(file, this.getZipOnFly());
            if (this.zip != null) {
                if (!this.checkZipMaxSize(this.zip)) {
                    this.deleteTmpZip();
                    return;
                }
                file = this.zip;
            }
        }
        this.skipResume = false;
        if (this.getOverwriteWarn() != null && !this.getOverwriteWarn().equalsIgnoreCase("false") && (headInfo = this.getHeadInfo(this.getOverwriteWarn(), file, file.getName(), "overwritewarn", this.getOverwriteWarn())).isRemoteFilenameFound()) {
            String string;
            long l2 = headInfo.getRemoteSize();
            long l3 = -1L;
            if (this.getResume() != null && !this.getResume().equalsIgnoreCase("false")) {
                l3 = l2;
            }
            if (headInfo.getChecksumOption() != null && (string = headInfo.getChecksum()) != null && !string.equals("")) {
                long l4 = System.currentTimeMillis();
                if (headInfo.getChecksumOption().equalsIgnoreCase("crc")) {
                    long l5 = this.getLong(string);
                    long l6 = this.getCRC32(headInfo.getFile(), l3);
                    log.debug((Object)("CRC32: Remote=" + l5 + " Local=" + l6 + " ResumeOffset=" + l2 + " in " + (System.currentTimeMillis() - l4) + "ms"));
                    if (l5 != l6) {
                        l2 = -1L;
                    }
                } else if (headInfo.getChecksumOption().equalsIgnoreCase("md5")) {
                    String string2 = string;
                    String string3 = this.hexDump(this.getMD5(headInfo.getFile(), l3)).toLowerCase();
                    log.debug((Object)("MD5: Remote=" + string2 + " Local=" + string3 + " ResumeOffset=" + l2 + " in " + (System.currentTimeMillis() - l4) + "ms"));
                    if (!string2.equals(string3)) {
                        l2 = -1L;
                    }
                }
            }
            headInfo.setResumeOffset(l2);
            int n = super.warnOverwrite(headInfo, false);
            String string4 = (String)this.getCustomParameters().get(OVERWRITEWARNFORWARDFILE);
            if (n == 13) {
                if (string4 != null && string4.equalsIgnoreCase("all")) {
                    this.uploadedfiles.add(headInfo.getFile());
                    if (this.getMetaProperties() != null) {
                        int n2 = this.uploadedfiles.size();
                        this.getMetaProperties().put("overwritewarnstatus" + n2, "cancel");
                    }
                }
                this.cancel();
                return;
            }
            if (n == 12) {
                if (string4 != null && string4.equalsIgnoreCase("all")) {
                    this.uploadedfiles.add(headInfo.getFile());
                    if (this.getMetaProperties() != null) {
                        int n3 = this.uploadedfiles.size();
                        this.getMetaProperties().put("overwritewarnstatus" + n3, "skip");
                    }
                }
                return;
            }
            if (n == 11) {
                log.debug((Object)("Overwritewarn has detected: " + headInfo.getContentMatch()));
                this.skipResume = !headInfo.getContentMatch().equalsIgnoreCase("CONTENT_PARTIAL_MATCH");
            }
        }
        if ((l = this.getChunks(file)) > 1L || this.chunkratioStr != null && this.chunkratioStr.equalsIgnoreCase("chunkratio")) {
            this.splitAndTransfer(file);
        } else {
            this.transferAndRetry(file, null);
        }
        this.deleteTmpZip();
    }

    private void deleteTmpZip() {
        if (this.zip != null) {
            log.debug((Object)("Deleting : " + this.zip.getAbsolutePath()));
            this.zip.delete();
            this.zip = null;
        }
    }

    protected void recurseProcess(File file, long l, long l2) throws ClientException {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (l2 > -1L) {
                        if (l + 1L > l2) continue;
                        this.recurseProcess(file2, l + 1L, l2);
                        continue;
                    }
                    this.recurseProcess(file2, l + 1L, l2);
                    continue;
                }
                this.process(file2);
            }
        } else if (this.isEmptyDirectoryAllowed()) {
            this.process(file);
        }
    }

    protected void splitAndTransfer(File file) throws ClientException {
        Iterator iterator = null;
        long l = file.length();
        FileInputStream fileInputStream = null;
        File file2 = null;
        long l2 = this.getChunkSize();
        boolean bl = false;
        long l3 = 0L;
        String string = this.getRawConf().getProperty("chunkmode");
        if (string != null) {
            bl = true;
        }
        try {
            if (this.getMaxSize() > 0L && l > this.getMaxSize()) {
                throw new ClientException("max size exceeded", file.getAbsolutePath());
            }
            if (l2 > 0L && (l > l2 || this.chunkratioStr != null && this.chunkratioStr.equalsIgnoreCase("chunkratio"))) {
                Object object2;
                long l4 = this.getChunks(file);
                long l5 = this.getLastChunkSize(file);
                int n = 0;
                String string2 = file.getName();
                String string3 = null;
                long l6 = file.length();
                for (Object object2 : this.getSplitListeners()) {
                    object2.splitTriggered((Object)file, l, l2, l4, string2);
                }
                log.info((Object)("Split triggered [" + Thread.currentThread().getName() + "]"));
                object2 = new byte[BUFFERSIZE];
                if (!bl) {
                    fileInputStream = new FileInputStream(file);
                }
                while ((long)n < l4) {
                    String string4;
                    Object object32;
                    ++n;
                    if (bl && l3 >= l6) break;
                    for (Object object32 : this.getSplitListeners()) {
                        if ((long)n < l4) {
                            object32.splitStarted(n, l2);
                            continue;
                        }
                        object32.splitStarted(n, l5);
                    }
                    log.info((Object)("Split started " + n + "/" + l4 + " [" + Thread.currentThread().getName() + "]"));
                    if (!bl) {
                        object32 = (String)this.getCustomParameters().get(CHUNKEXTENSION);
                        object32 = object32 != null ? this.getRawConf().getFormattedMessage((String)object32, new Object[]{String.valueOf(n)}) : String.valueOf(n);
                        string4 = this.getTmpFolder();
                        file2 = string4 != null ? new File(string4 + "/" + file.getName() + "." + (String)object32) : new File(file.getAbsolutePath() + "." + (String)object32);
                        this.fout = new FileOutputStream(file2);
                        int n2 = 0;
                        long l7 = 0L;
                        while (l7 < l2 && (n2 = (l7 += (long)n2) + (long)((SplitListener)object2).length > l2 ? fileInputStream.read((byte[])object2, 0, (int)(l2 - l7)) : fileInputStream.read((byte[])object2)) > 0) {
                            this.fout.write((byte[])object2, 0, n2);
                            for (SplitListener splitListener : this.getSplitListeners()) {
                                splitListener.dataSplit((long)n2);
                            }
                        }
                        this.fout.close();
                        this.fout = null;
                    } else {
                        if (l3 + l2 > l) {
                            l2 = l - l3;
                        }
                        for (Object object32 : this.getSplitListeners()) {
                            object32.dataSplit(l2);
                        }
                    }
                    for (Object object32 : this.getSplitListeners()) {
                        object32.splitCompleted(n);
                    }
                    log.info((Object)("Split completed " + n + "/" + l4 + " [" + Thread.currentThread().getName() + "]"));
                    object32 = new HashMap();
                    ((HashMap)object32).put(CHUNKID, String.valueOf(n));
                    ((HashMap)object32).put(CHUNKAMOUNT, String.valueOf(l4));
                    ((HashMap)object32).put(CHUNKBASE, string2);
                    ((HashMap)object32).put(CHUNKBASESIZE, String.valueOf(l6));
                    if (bl) {
                        if (string.equalsIgnoreCase(ONFLYRANGE)) {
                            ((HashMap)object32).remove(CHUNKID);
                            ((HashMap)object32).remove(CHUNKAMOUNT);
                            ((HashMap)object32).remove(CHUNKBASE);
                            if (string3 != null) {
                                ((HashMap)object32).put(ALTCHUNKBASE, string3);
                            }
                        }
                        ((HashMap)object32).put(CHUNKONFLY, string);
                        ((HashMap)object32).put(CHUNKONFLYOFFSET, String.valueOf(l3));
                        ((HashMap)object32).put(CHUNKONFLYSIZE, String.valueOf(l2));
                        this.transferAndRetry(file, (HashMap)object32);
                        string4 = (String)((HashMap)object32).get(CHUNKACTION);
                        if (string4 != null && string4.equalsIgnoreCase("stop")) break;
                        string3 = (String)((HashMap)object32).get(ALTCHUNKBASE);
                        long l8 = this.getLong((String)((HashMap)object32).get(CHUNKONFLYOFFSET));
                        if (l8 != l3) {
                            long l9 = (long)((int)l8) % l2;
                            n = (int)((l8 - l9) / l2);
                            l3 = l8;
                            continue;
                        }
                        l3 += l2;
                        continue;
                    }
                    this.transferAndRetry(file2, (HashMap)object32);
                    file2.delete();
                    file2 = null;
                }
                if (!bl) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
            } else {
                this.transferAndRetry(file, null);
            }
        }
        catch (Exception exception) {
            log.error((Object)exception);
            if (exception instanceof ClientException) {
                throw (ClientException)((Object)exception);
            }
            throw new ClientException((Throwable)exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
            try {
                if (this.fout != null) {
                    this.fout.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
            if (file2 != null) {
                file2.delete();
            }
        }
    }

    protected void transferAndRetry(File file, HashMap hashMap) throws ClientException {
        if (this.getRetry() > 0) {
            int n = 0;
            boolean bl = false;
            while (!bl && n <= this.getRetry()) {
                try {
                    this.transfer(file, hashMap);
                    bl = true;
                }
                catch (ClientException clientException) {
                    if (this.cancelled || ++n > this.getRetry()) {
                        throw clientException;
                    }
                    log.info((Object)("Attempt " + n + "/" + this.getRetry() + " [" + Thread.currentThread().getName() + "]"));
                    String string = (String)this.getCustomParameters().get(ERRORHEADER);
                    String string2 = (String)this.getCustomParameters().get(RETRYERRORHEADER);
                    if (string != null && string2 != null && string2.equalsIgnoreCase("false")) {
                        throw clientException;
                    }
                    try {
                        if (this.getRetryDelay() <= 0) continue;
                        Thread.sleep(this.getRetryDelay() * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        log.error((Object)interruptedException);
                    }
                }
            }
        } else {
            this.transfer(file, hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transfer(File file, HashMap hashMap) throws ClientException {
        String string;
        Object object;
        String string2;
        Object object2;
        Object object3;
        String string32;
        Object object4;
        String string4;
        Object object5;
        PostMethod postMethod;
        Object object6;
        Object object7;
        Object object82;
        Iterator<Object> iterator;
        URL uRL = null;
        try {
            iterator = (String)this.getCustomParameters().get(DEPRECATEDURL);
            if (iterator != null && ((String)((Object)iterator)).startsWith("http")) {
                this.uploadurl = iterator;
            }
            uRL = new URL(this.uploadurl);
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)malformedURLException);
            throw new ClientException((Throwable)malformedURLException);
        }
        iterator = null;
        for (Object object82 : this.getTransferListeners()) {
            if (!file.isFile() && (!this.isEmptyDirectoryAllowed() || !file.isDirectory())) continue;
            long l = file.length();
            if (hashMap != null && hashMap.get(CHUNKONFLY) != null) {
                l = this.getLong((String)hashMap.get(CHUNKONFLYSIZE));
            }
            object82.transferStarted((Object)file, l);
        }
        super.authenticate();
        object82 = file.getName();
        if (this.getTemplate() != null) {
            object82 = this.rename((String)object82, this.getTemplate(), 0);
        }
        Object object9 = object82;
        String string5 = (String)this.getCustomParameters().get(FILENAMEASHTMLENTITIES);
        if (string5 != null && string5.equalsIgnoreCase("true")) {
            try {
                object7 = Class.forName("org.apache.commons.lang.StringEscapeUtils");
                object6 = ((Class)object7).getMethod("escapeHtml", String.class);
                object9 = (String)((Method)object6).invoke(null, object9);
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
        }
        object7 = null;
        if (hashMap != null && (object7 = (String)hashMap.get(CHUNKONFLY)) != null) {
            if (!((String)object7).equalsIgnoreCase(ONFLYRANGE)) {
                String string6;
                object6 = (String)hashMap.get(CHUNKBASE);
                if (object6 != null && this.getTemplate() != null) {
                    hashMap.put(CHUNKBASE, object9);
                }
                string6 = (string6 = (String)this.getCustomParameters().get(CHUNKEXTENSION)) != null ? this.getRawConf().getFormattedMessage(string6, new Object[]{(String)hashMap.get(CHUNKID)}) : (String)hashMap.get(CHUNKID);
                object9 = (String)object9 + "." + string6;
            } else {
                object6 = (String)hashMap.get(ALTCHUNKBASE);
                if (object6 != null && this.getOverwrite() != null && this.getResume() != null) {
                    object9 = object6;
                }
            }
        }
        long l = -1L;
        long l2 = -1L;
        log.debug((Object)("Skip resume: " + this.skipResume));
        if (this.getResume() != null && !this.getResume().equalsIgnoreCase("false") && !this.skipResume) {
            String string7 = null;
            postMethod = new HashMap();
            postMethod.put("filename", object9);
            if (this.getResume().equalsIgnoreCase("md5")) {
                string7 = "md5";
            } else if (this.getResume().equalsIgnoreCase("crc")) {
                string7 = "crc";
            } else if (this.getResume().equalsIgnoreCase("true")) {
                string7 = null;
            }
            if (string7 != null) {
                postMethod.put("checksum", string7);
            }
            if ((object5 = (String)this.getCustomParameters().get(RELATIVEFILENAME)) != null && ((String)object5).equalsIgnoreCase("true")) {
                postMethod.put(RELATIVEFILENAME, this.getRelativeFilename(file, (String)object9));
            }
            if ((string4 = (String)this.getCustomParameters().get(FILETIMESTAMP)) != null && string4.equalsIgnoreCase("true")) {
                postMethod.put(FILETIMESTAMP, String.valueOf(file.lastModified()));
            }
            if ((object4 = (String)this.getCustomParameters().get(ACCOUNT)) != null) {
                postMethod.put(ACCOUNT, object4);
            }
            if (file.isDirectory()) {
                postMethod.put("directory", "true");
            }
            if ((string32 = (String)this.getCustomParameters().get(HEADEXTRAPARAMETERS)) != null && string32.equalsIgnoreCase("true")) {
                postMethod.putAll(this.getCustomParameters());
            }
            object3 = this.headInfo(this.uploadurl, (Map)postMethod, false);
            object2 = "size";
            string2 = (String)this.getCustomParameters().get(RESUMEHEADER);
            if (string2 != null && string2.length() > 0) {
                object2 = string2;
            }
            if ((object = (String)object3.get(object2)) != null && (l2 = this.getLong((String)object)) >= 0L) {
                if (l2 < file.length()) {
                    String string8;
                    l = l2;
                    if (string7 != null && (string8 = (String)object3.get("checksum")) != null && !string8.equals("")) {
                        if (string7.equalsIgnoreCase("crc")) {
                            long l3 = this.getLong(string8);
                            long l4 = this.getCRC32(file, l);
                            log.debug((Object)("CRC32 : Remote=" + l3 + " Local=" + l4 + " ResumeOffset=" + l));
                            if (l3 != l4) {
                                l = -1L;
                            }
                        } else if (string7.equalsIgnoreCase("md5")) {
                            String string9 = string8;
                            String string10 = this.hexDump(this.getMD5(file, l)).toLowerCase();
                            log.debug((Object)("MD5 : Remote=" + string9 + " Local=" + string10 + " ResumeOffset=" + l));
                            if (!string9.equals(string10)) {
                                l = -1L;
                            }
                        }
                    }
                }
                if (object7 != null && ((String)object7).equalsIgnoreCase(ONFLYRANGE) && l > 0L && l2 > this.getLong((String)hashMap.get(CHUNKONFLYOFFSET)) + 1L) {
                    hashMap.put(CHUNKONFLYOFFSET, String.valueOf(l2));
                    return;
                }
            } else {
                l2 = -404L;
            }
        }
        if (this.getOverwrite() != null && !this.getOverwrite().equalsIgnoreCase("true") && l == -1L && l2 != -404L) {
            int n = 1;
            postMethod = new HashMap();
            while (true) {
                object5 = null;
                string4 = null;
                if (l2 < 0L) {
                    postMethod.put("filename", object9);
                    object4 = (String)this.getCustomParameters().get(RELATIVEFILENAME);
                    if (object4 != null && ((String)object4).equalsIgnoreCase("true")) {
                        postMethod.put(RELATIVEFILENAME, this.getRelativeFilename(file, (String)object9));
                    }
                    if ((string32 = (String)this.getCustomParameters().get(FILETIMESTAMP)) != null && string32.equalsIgnoreCase("true")) {
                        postMethod.put(FILETIMESTAMP, String.valueOf(file.lastModified()));
                    }
                    if ((object3 = (String)this.getCustomParameters().get(ACCOUNT)) != null) {
                        postMethod.put(ACCOUNT, object3);
                    }
                    if (file.isDirectory()) {
                        postMethod.put("directory", "true");
                    }
                    if ((object2 = (String)this.getCustomParameters().get(HEADEXTRAPARAMETERS)) != null && ((String)object2).equalsIgnoreCase("true")) {
                        postMethod.putAll(this.getCustomParameters());
                    }
                    object5 = this.headInfo(this.uploadurl, (Map)postMethod, false);
                    string4 = (String)object5.get("size");
                }
                if ((string4 == null || this.getLong(string4) < 0L) && l2 < 0L) break;
                object9 = this.rename((String)object82, this.getTemplate(), n);
                if (object9 == null) {
                    if (object7 != null && hashMap != null) {
                        hashMap.put(CHUNKACTION, "stop");
                    }
                    return;
                }
                ++n;
                l2 = -1L;
                if (object7 == null || hashMap == null || !((String)object7).equalsIgnoreCase(ONFLYRANGE)) continue;
                hashMap.put(ALTCHUNKBASE, object9);
            }
        }
        int n = -1;
        postMethod = null;
        object5 = new ArrayList();
        string4 = null;
        if (this.getCustomParameters() != null) {
            string4 = (String)this.getCustomParameters().get(HTTPMETHOD);
        }
        if (string4 != null && string4.equalsIgnoreCase("put")) {
            object4 = this.uploadurl;
            string32 = "";
            object3 = (String)this.getCustomParameters().get(MKCOL);
            if (object3 != null && ((String)object3).equalsIgnoreCase("true") && ((String)(object2 = this.getRelativeFilename(file, (String)object9))).length() > ((String)object9).length()) {
                string32 = ((String)object2).substring(0, ((String)object2).length() - ((String)object9).length());
                string32 = string32.replace(File.separatorChar, '/');
                string2 = object4;
                if (((String)object4).endsWith("/")) {
                    string2 = string2 + string32;
                }
                try {
                    object = new URL(string2);
                    string2 = ((URL)object).getProtocol() + "://" + ((URL)object).getHost();
                    if (((URL)object).getPort() != -1) {
                        string2 = string2 + ":" + ((URL)object).getPort();
                    }
                    string2 = string2 + HttpUtil.formURLEncode(((URL)object).getPath(), this.getEncoding()).replaceAll("(%2F)", "/");
                    if (((URL)object).getQuery() != null) {
                        string2 = string2 + "?" + ((URL)object).getQuery();
                    }
                }
                catch (Exception exception) {
                    log.error((Object)exception);
                }
                object = this.headInfo(string2, null, false);
                int n2 = (int)this.getLong((String)object.get(STATUSCODEKEY));
                if (n2 == 404) {
                    this.headInfo(string2, null, true);
                }
            }
            if (((String)object4).endsWith("/")) {
                object4 = (String)object4 + string32 + (String)object9;
            }
            try {
                object2 = new URL((String)object4);
                object4 = ((URL)object2).getProtocol() + "://" + ((URL)object2).getHost();
                if (((URL)object2).getPort() != -1) {
                    object4 = (String)object4 + ":" + ((URL)object2).getPort();
                }
                object4 = (String)object4 + HttpUtil.formURLEncode(((URL)object2).getPath(), this.getEncoding()).replaceAll("(%2F)", "/");
                if (((URL)object2).getQuery() != null) {
                    object4 = (String)object4 + "?" + ((URL)object2).getQuery();
                }
            }
            catch (Exception exception) {
                log.error((Object)exception);
            }
            postMethod = new PutMethod((String)object4);
            log.info((Object)("Upload (PUT) started : " + file.getAbsolutePath() + " (" + (String)object4 + ")" + " [" + Thread.currentThread().getName() + "]"));
        } else if (string4 != null && string4.equalsIgnoreCase("none")) {
            postMethod = null;
            log.info((Object)("Upload (NONE) started : " + file.getAbsolutePath() + " [" + Thread.currentThread().getName() + "]"));
        } else {
            postMethod = new PostMethod(this.uploadurl);
            log.info((Object)("Upload (POST) started : " + file.getAbsolutePath() + " [" + Thread.currentThread().getName() + "]"));
        }
        object4 = null;
        if (this.getCustomParameters() != null) {
            for (String string32 : this.getCustomParameters().keySet()) {
                object3 = (String)this.getCustomParameters().get(string32);
                log.debug((Object)(string32 + ":" + (String)object3));
                if (string32.equalsIgnoreCase(ERRORHEADER)) {
                    object4 = object3;
                    continue;
                }
                if (string32.equalsIgnoreCase(RELATIVEFILENAME) && ((String)object3).equalsIgnoreCase("true")) {
                    this.rfilename = object3 = this.getRelativeFilename(file, (String)object9);
                }
                if (string32.equalsIgnoreCase(FULLFILENAME) && ((String)object3).equalsIgnoreCase("true")) {
                    object3 = file.getAbsolutePath();
                    int n3 = ((String)object3).lastIndexOf(File.separator);
                    object3 = n3 > -1 ? ((String)object3).substring(0, n3 + 1) + (String)object9 : object9;
                }
                if (string32.equalsIgnoreCase(SELECTEDFULLFILENAME) && (((String)object3).equalsIgnoreCase("true") || ((String)object3).equalsIgnoreCase("initial"))) {
                    object3 = this.sfullfilename;
                }
                if (string32.equalsIgnoreCase(EMPTYDIRECTORY) && ((String)object3).equalsIgnoreCase("true") && file.isDirectory()) {
                    object3 = this.getRelativeFilename(file, (String)object9);
                }
                if (string32.equalsIgnoreCase(FILETIMESTAMP) && ((String)object3).equalsIgnoreCase("true")) {
                    object3 = String.valueOf(file.lastModified());
                }
                if (postMethod != null && postMethod instanceof PostMethod) {
                    StringPart stringPart = new StringPart(string32, (String)object3, this.getEncoding());
                    ((ArrayList)object5).add(stringPart);
                    continue;
                }
                if (postMethod == null || !(postMethod instanceof PutMethod)) continue;
                ((PutMethod)postMethod).setRequestHeader(string32, (String)object3);
            }
        }
        if (hashMap != null) {
            for (String string32 : hashMap.keySet()) {
                object3 = (String)hashMap.get(string32);
                if (postMethod != null && postMethod instanceof PostMethod) {
                    object2 = new StringPart(string32, (String)object3, this.getEncoding());
                    ((ArrayList)object5).add(object2);
                    continue;
                }
                if (postMethod == null || !(postMethod instanceof PutMethod)) continue;
                ((PutMethod)postMethod).setRequestHeader(string32, (String)object3);
            }
        }
        if ((string32 = this.getRawConf().getProperty("checksum")) != null) {
            object3 = null;
            if (string32.equalsIgnoreCase("crc")) {
                object3 = String.valueOf(this.getCRC32(file, l));
            } else if (string32.equalsIgnoreCase("md5")) {
                object3 = this.hexDump(this.getMD5(file, l)).toLowerCase();
            }
            if (object3 != null && ((String)object3).length() > 0) {
                postMethod.setRequestHeader("checksum", (String)object3);
            }
        }
        try {
            object3 = this.getCustomFilenameMap().getContentTypeFor(file.getName());
            super.setResumeOffset(l);
            if (string4 != null && string4.equalsIgnoreCase("put")) {
                if (object3 != null) {
                    ((PutMethod)postMethod).setRequestHeader("Content-Type", (String)object3);
                }
                ((PutMethod)postMethod).setRequestHeader("filename", (String)object9);
                long l5 = file.length();
                if (file.isFile()) {
                    this.pfin = new FileInputStream(file);
                    object = this.getRawConf().getTriggeredInputStream((InputStream)this.pfin, this.getTransferListeners());
                    long l6 = -1L;
                    if (hashMap != null && (object7 = (String)hashMap.get(CHUNKONFLY)) != null && ((String)object7).equalsIgnoreCase(ONFLYRANGE)) {
                        l6 = this.getLong((String)hashMap.get(CHUNKONFLYSIZE));
                        if (l > 0L && l < file.length()) {
                            l6 = this.getLong((String)hashMap.get(CHUNKONFLYOFFSET)) + l6 - l;
                        } else {
                            l = this.getLong((String)hashMap.get(CHUNKONFLYOFFSET));
                        }
                        l5 = l6;
                        if (l + l6 > file.length()) {
                            l5 = file.length() - l;
                        }
                        ((PutMethod)postMethod).setRequestHeader("Content-Range", "bytes " + l + "-" + (l + l5 - 1L) + "/" + file.length());
                        object.setMaxlength(l5);
                        if (this.chunkratioStr != null && this.chunkratioStr.equalsIgnoreCase("chunkratio")) {
                            object.setForceSkipNotification(true);
                        }
                        object.skip(l);
                    } else if (l > 0L && l < file.length()) {
                        ((PutMethod)postMethod).setRequestHeader("Content-Range", "bytes " + l + "-" + (file.length() - 1L) + "/" + file.length());
                        object.skip(l);
                        l5 -= l;
                    }
                    ((PutMethod)postMethod).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)object, l5));
                }
            } else if ((string4 == null || !string4.equalsIgnoreCase("none")) && file.isFile()) {
                if (l > 0L && l < file.length()) {
                    postMethod.setRequestHeader("Content-Range", "bytes " + l + "-" + (file.length() - 1L) + "/" + file.length());
                }
                long l7 = -1L;
                boolean bl = false;
                if (hashMap != null && (object7 = (String)hashMap.get(CHUNKONFLY)) != null) {
                    if (((String)object7).equalsIgnoreCase(ONFLYRANGE)) {
                        if (l < 0L) {
                            l = this.getLong((String)hashMap.get(CHUNKONFLYOFFSET));
                        }
                        l7 = this.getLong((String)hashMap.get(CHUNKONFLYSIZE));
                        postMethod.setRequestHeader("Content-Range", "bytes " + l + "-" + (l + l7 - 1L) + "/" + file.length());
                        if (this.chunkratioStr != null && this.chunkratioStr.equalsIgnoreCase("chunkratio")) {
                            bl = true;
                        }
                    } else {
                        l = this.getLong((String)hashMap.get(CHUNKONFLYOFFSET));
                        l7 = this.getLong((String)hashMap.get(CHUNKONFLYSIZE));
                        postMethod.removeRequestHeader("Content-Range");
                    }
                }
                this.source = new CustomFilePartSource(file, this.getTransferListeners(), (String)object9, l, l7, this.getRawConf(), bl);
                this.param = new CustomFilePart(this.getParamFile(), this.source, (String)object3, this.getEncoding());
                ((ArrayList)object5).add(this.param);
            }
            if (postMethod != null) {
                if (object5 != null && ((ArrayList)object5).size() > 0 && postMethod instanceof PostMethod) {
                    Part[] partArray = new Part[((ArrayList)object5).size()];
                    ((ArrayList)object5).toArray(partArray);
                    postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, postMethod.getParams()));
                }
                n = this.getClient().executeMethod((HttpMethod)postMethod);
            }
            if (this.pfin != null) {
                this.pfin.close();
                this.pfin = null;
            }
        }
        catch (HttpException httpException) {
            log.error((Object)httpException);
            throw new ClientException((Throwable)httpException);
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new ClientException((Throwable)iOException);
        }
        log.info((Object)("Upload Status code = " + n + " [" + Thread.currentThread().getName() + "]"));
        if (postMethod != null && n != 200 && n != 201 && n != 204) {
            if (object4 != null) {
                object3 = postMethod.getResponseHeader((String)object4);
                if (object3 != null) {
                    String string11 = object3.getValue();
                    postMethod.releaseConnection();
                    throw new ClientException("server error", string11);
                }
                String string12 = postMethod.getStatusLine().toString();
                postMethod.releaseConnection();
                throw new ClientException("server error", string12);
            }
            object3 = postMethod.getStatusLine().toString();
            postMethod.releaseConnection();
            throw new ClientException("server error", (String)object3);
        }
        object3 = null;
        if (postMethod != null) {
            try {
                if (n != 204) {
                    object3 = postMethod.getResponseBody();
                }
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        if ((string = (String)this.getCustomParameters().get(SELECTEDFULLFILENAME)) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("initial"))) {
            log.debug((Object)("selectedfullfilename : " + string));
            if (string.equalsIgnoreCase("initial") && this.sfullfilename != null) {
                file = new File(this.sfullfilename);
            }
        } else if (file.isFile()) {
            file = file.getParent().endsWith(File.separator) ? new File(file.getParent() + (String)object9) : new File(file.getParent() + File.separator + (String)object9);
        } else if (!this.isEmptyDirectoryAllowed()) {
            file = null;
        }
        if ((string2 = (String)this.getCustomParameters().get(NOTIFYRELATIVEFILENAME)) != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("full"))) {
            log.debug((Object)("notifyrelativefilename : " + this.rfilename));
            if (this.rfilename != null) {
                this.uploadedfiles.add(new File(this.rfilename));
            }
        } else if (file != null) {
            if (this.getChunkSize() > 0L) {
                if (!this.uploadedfiles.contains(file)) {
                    this.uploadedfiles.add(file);
                }
            } else {
                this.uploadedfiles.add(file);
            }
        }
        if (string != null && string.equalsIgnoreCase("oncompleted") && this.sfullfilename != null) {
            file = new File(this.sfullfilename);
        }
        for (TransferListener transferListener : this.getTransferListeners()) {
            if (file == null) continue;
            transferListener.transferCompleted((Object)file, (byte[])object3);
        }
        log.info((Object)("Upload completed [" + Thread.currentThread().getName() + "]"));
    }

    public void cancel() {
        try {
            this.cancelled = true;
            if (this.param != null) {
                this.param.close();
            }
            if (this.pfin != null) {
                this.pfin.close();
            }
            if (this.fout != null) {
                this.fout.close();
            }
        }
        catch (IOException iOException) {
            log.debug((Object)iOException);
        }
        for (TransferListener transferListener : this.getTransferListeners()) {
            transferListener.transferCancelled();
        }
        log.info((Object)("Upload Cancelled [" + Thread.currentThread().getName() + "]"));
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected String getRelativeFilename(File file, String string) {
        String string2 = file.getAbsolutePath().substring(this.getRootDir().length(), file.getAbsolutePath().length());
        int n = string2.lastIndexOf(File.separator);
        if (n > -1) {
            File file2;
            string2 = string2.substring(0, n + 1);
            if (this.getTemplate() != null && this.getTemplateScope() != null && this.getTemplateScope().equalsIgnoreCase("path") && (file2 = file.getParentFile()) != null) {
                File file3 = new File(this.getRootDir());
                String string3 = "";
                while (file2 != null && !file2.getAbsolutePath().equals(file3.getAbsolutePath())) {
                    string3 = this.rename(file2.getName(), this.getTemplate(), 0) + File.separator + string3;
                    file2 = file2.getParentFile();
                }
                string2 = string3;
            }
            string2 = string2 + string;
        } else {
            string2 = string;
        }
        return string2;
    }

    public boolean isEmptyDirectoryAllowed() {
        boolean bl = false;
        String string = (String)this.getCustomParameters().get(EMPTYDIRECTORY);
        if (string != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    protected AbstractTransferController.HeadInfo getHeadInfo(String string, File file, String string2, String string3, String string4) throws ClientException {
        String string5;
        String string6;
        String string7;
        String string8;
        AbstractTransferController.HeadInfo headInfo = new AbstractTransferController.HeadInfo((AbstractTransferController)this);
        headInfo.setFile(file);
        headInfo.setName(string2);
        String string9 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("filename", string2);
        if (string3 != null && string3.length() > 0 && string4 != null) {
            hashMap.put(string3, string4);
        }
        if (string.equalsIgnoreCase("md5")) {
            string9 = "md5";
        } else if (string.equalsIgnoreCase("crc")) {
            string9 = "crc";
        } else if (string.equalsIgnoreCase("true")) {
            string9 = null;
        }
        if (string9 != null) {
            hashMap.put("checksum", string9);
            headInfo.setChecksumOption(string9);
        }
        if ((string8 = (String)this.getCustomParameters().get(RELATIVEFILENAME)) != null && string8.equalsIgnoreCase("true")) {
            hashMap.put(RELATIVEFILENAME, this.getRelativeFilename(file, string2));
        }
        if ((string7 = (String)this.getCustomParameters().get(FILETIMESTAMP)) != null && string7.equalsIgnoreCase("true")) {
            hashMap.put(FILETIMESTAMP, String.valueOf(file.lastModified()));
        }
        if ((string6 = (String)this.getCustomParameters().get(ACCOUNT)) != null) {
            hashMap.put(ACCOUNT, string6);
        }
        if (file.isDirectory()) {
            hashMap.put("directory", "true");
        }
        if ((string5 = (String)this.getCustomParameters().get(HEADEXTRAPARAMETERS)) != null && string5.equalsIgnoreCase("true")) {
            hashMap.putAll(this.getCustomParameters());
        }
        Map map = this.headInfo(this.uploadurl, hashMap, false);
        String string10 = "size";
        String string11 = (String)this.getCustomParameters().get(RESUMEHEADER);
        if (string11 != null && string11.length() > 0) {
            string10 = string11;
        }
        String string12 = (String)map.get(string10);
        long l = -1L;
        if (string12 != null && (l = this.getLong(string12)) >= 0L) {
            headInfo.setRemoteFilenameFound(true);
            headInfo.setRemoteSize(l);
            String string13 = (String)map.get("checksum");
            headInfo.setChecksum(string13);
        }
        return headInfo;
    }

    public Object execute() throws ClientException {
        throw new ClientException("Not implemented");
    }

    public String getUploadurl() {
        return this.uploadurl;
    }

    public void setUploadurl(String string) {
        this.uploadurl = string;
    }

    public HashMap getParameters(String string) {
        if (string != null && string.equalsIgnoreCase("dynamic")) {
            return this.getCustomParameters();
        }
        return super.getParameters(null);
    }
}

