/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.http;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientFactory {
    private static final Log log = LogFactory.getLog(HttpClientFactory.class);
    private static HttpClientFactory instance = null;
    private int concurrency = -1;
    private HttpClient client = null;
    private MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();

    private HttpClientFactory() {
        this.client = new HttpClient((HttpConnectionManager)this.manager);
    }

    public static synchronized HttpClientFactory getInstance() {
        if (instance == null) {
            instance = new HttpClientFactory();
        }
        return instance;
    }

    public HttpClient getClient() {
        if (this.concurrency > 0) {
            return this.client;
        }
        return new HttpClient();
    }

    public void setConcurrency(String string) {
        int n = this.concurrency;
        if (string != null && !string.equals("")) {
            try {
                this.concurrency = Integer.parseInt(string);
                log.debug((Object)("Http simultaneous connections = " + this.concurrency));
                if (this.concurrency > 0 && this.concurrency != n) {
                    this.manager.setMaxConnectionsPerHost(this.concurrency);
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.info((Object)("Cannot parse concurrency" + numberFormatException.getMessage()));
            }
        }
    }
}

