/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.http;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtil {
    private static final Log log = LogFactory.getLog(HttpUtil.class);
    public static final String HTTP_ELEMENT_CHARSET = "US-ASCII";
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    public static Proxy proxy = null;

    public static byte[] getAsciiBytes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return string.getBytes(HTTP_ELEMENT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII support required");
        }
    }

    public static byte[] getContentBytes(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (string2 == null || string2.equals("")) {
            string2 = DEFAULT_CONTENT_CHARSET;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return string.getBytes(DEFAULT_CONTENT_CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return string.getBytes();
            }
        }
    }

    public static String formURLEncode(String string, String string2) {
        String string3 = null;
        try {
            String string4 = URLEncoder.encode(string, string2);
            string3 = string4.replaceAll("[+]", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)unsupportedEncodingException);
        }
        return string3;
    }
}

