/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core;

import java.io.File;
import java.util.ArrayList;
import jfileupload.transfer.client.core.Monitor;
import jfileupload.transfer.client.core.TransferController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderMonitor
extends Monitor {
    private static final Log log = LogFactory.getLog(FolderMonitor.class);
    private File dir = null;

    public FolderMonitor(TransferController transferController, int n) {
        super(transferController, n);
        String string = transferController.getRawConf().getProperty("startdir");
        if (string != null) {
            File file = new File(string);
            if (!file.exists()) {
                boolean bl = file.mkdirs();
                log.info((Object)("FolderMonitor directory creation: " + file + " is " + bl));
            }
            if (file.exists() && file.isDirectory()) {
                this.dir = file;
            } else {
                log.error((Object)("FolderMonitor cannot start on: " + file));
            }
        }
    }

    public void run() {
        if (this.dir != null) {
            log.info((Object)("FolderMonitor running (" + this.time / 1000L + "s)"));
            while (!this.abort) {
                try {
                    Thread.currentThread();
                    Thread.sleep(this.time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.controller.getStatus() == 1) continue;
                log.debug((Object)"Scanning directory");
                File[] fileArray = this.dir.listFiles();
                if (fileArray == null || fileArray.length <= 0) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file = fileArray[i];
                    if (!file.canRead()) continue;
                    if (this.controller.getMaxDepth() != 0L) {
                        arrayList.add(file.getAbsolutePath());
                        continue;
                    }
                    if (!file.isFile()) continue;
                    arrayList.add(file.getAbsolutePath());
                }
                if (arrayList.size() <= 0) continue;
                log.debug((Object)("" + arrayList.size() + " items detected, uploading ..."));
                this.controller.setSource(arrayList);
                this.controller.begin();
            }
            log.info((Object)"FolderMonitor completed");
        }
    }
}

