/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.queue.TransferStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueManager
implements Runnable {
    private static final Log log = LogFactory.getLog(QueueManager.class);
    public static final String NOTIMPLEMENTED = "NOTIMPLEMENTED";
    public static final String CANNOTMAKEDIRECTORY = "CANNOTMAKEDIRECTORY";
    public static final String CANNOTRENAME = "CANNOTRENAME";
    public static final String CANNOTDELETE = "CANNOTDELETE";
    public static final String CANNOTCOPYFILE = "CANNOTCOPYFILE";
    public static final String CANNOTGETINFO = "CANNOTGETINFO";
    public static final String CANNOTLIST = "CANNOTLIST";
    public static final String CANNOTLOGOUT = "CANNOTLOGOUT";
    public static final String ITEMNOTFOUND = "ITEMNOTFOUND";
    public static final String CANNOTCANCELITEM = "CANNOTCANCELITEM";
    public static final String HTTPERROR = "HTTPERROR";
    public static final String IOERROR = "IOERROR";
    public static int SLEEPTIME = 200;
    public static int HIGH = 1;
    public static int NORMAL = 0;
    public static int QUEUEIN = 0;
    public static int QUEUE = 1;
    public static int QUEUEOUT = 2;
    public static int DEFAULTSIZE = 10;
    public static int MAXSEQ = 1000;
    private static QueueManager instance = null;
    private int seq = MAXSEQ;
    private Map<Long, TransferStatus> queue = null;
    private int queuesize = DEFAULTSIZE;
    private Map<Long, TransferStatus> queuein = null;
    private Map<Long, TransferStatus> queueout = null;
    private boolean destroy = true;
    private boolean suspend = false;

    private QueueManager() {
        this.queue = Collections.synchronizedMap(new TreeMap());
        this.queuein = Collections.synchronizedMap(new TreeMap());
        this.queueout = Collections.synchronizedMap(new TreeMap());
    }

    public static synchronized QueueManager getInstance() {
        if (instance == null) {
            instance = new QueueManager();
        }
        if (instance.getDestroy()) {
            instance.setDestroy(false);
            instance.setSuspend(false);
            instance.startThread();
        }
        return instance;
    }

    public synchronized void setConcurrency(int n) {
        this.queuesize = n > 0 ? n : DEFAULTSIZE;
    }

    private void startThread() {
        log.info((Object)("QueueManager started - Sleep time: " + SLEEPTIME));
        Thread thread = new Thread(this);
        thread.start();
    }

    public int getConcurrency() {
        return this.queuesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long add(TransferController transferController, int n) {
        Map<Long, TransferStatus> map = this.queuein;
        synchronized (map) {
            TransferStatus transferStatus = new TransferStatus(transferController);
            long l = System.currentTimeMillis() * (long)MAXSEQ;
            ++this.seq;
            if (this.seq >= MAXSEQ) {
                this.seq = 0;
            }
            l += (long)this.seq;
            if (n == HIGH) {
                l -= 10000000L;
            }
            Long l2 = new Long(l);
            this.queuein.put(l2, transferStatus);
            log.debug((Object)(String.valueOf(l2) + " added to queuein"));
            return l;
        }
    }

    public synchronized long add(TransferController transferController) {
        return this.add(transferController, NORMAL);
    }

    public synchronized void cancelItem(long l, boolean bl) throws ClientException {
        TransferStatus transferStatus = this.getStatus(l);
        TransferController transferController = transferStatus.getController();
        if (!bl) {
            if (transferStatus.getStatus() == 4) {
                throw new ClientException(CANNOTCANCELITEM, String.valueOf(4));
            }
            if (transferStatus.getStatus() == 5) {
                throw new ClientException(CANNOTCANCELITEM, String.valueOf(5));
            }
            if (transferStatus.getStatus() == 9) {
                throw new ClientException(CANNOTCANCELITEM, String.valueOf(9));
            }
            transferController.cancel();
        } else {
            transferController.cancel();
        }
        log.debug((Object)(String.valueOf(l) + " cancelled"));
    }

    public synchronized int getQueueSize(int n) {
        if (n == QUEUEIN) {
            return this.queuein.size();
        }
        if (n == QUEUE) {
            return this.queue.size();
        }
        if (n == QUEUEOUT) {
            return this.queueout.size();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Long> getQueueItems(int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (n == QUEUEIN) {
            Map<Long, TransferStatus> map = this.queuein;
            synchronized (map) {
                Iterator<Long> iterator = this.queuein.keySet().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        if (n == QUEUE) {
            Map<Long, TransferStatus> map = this.queue;
            synchronized (map) {
                Iterator<Long> iterator = this.queue.keySet().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        if (n == QUEUEOUT) {
            Map<Long, TransferStatus> map = this.queueout;
            synchronized (map) {
                Iterator<Long> iterator = this.queueout.keySet().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList;
    }

    public synchronized void reset() {
        this.queuein.clear();
        this.queue.clear();
        this.queueout.clear();
    }

    public synchronized TransferStatus getStatus(long l) throws ClientException {
        TransferStatus transferStatus = this.lookup(l);
        if (transferStatus != null) {
            return transferStatus;
        }
        throw new ClientException(ITEMNOTFOUND);
    }

    private TransferStatus lookup(long l) {
        TransferStatus transferStatus = null;
        transferStatus = this.queuein.get(new Long(l));
        if (transferStatus == null) {
            transferStatus = this.queue.get(new Long(l));
        }
        if (transferStatus == null) {
            transferStatus = this.queueout.get(new Long(l));
        }
        return transferStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.destroy) {
            if (!this.suspend) {
                ArrayList<Long> arrayList;
                Map<Long, TransferStatus> map;
                int n = this.queue.size();
                if (n < this.queuesize) {
                    map = this.queuein;
                    synchronized (map) {
                        if (this.queuein.size() > 0) {
                            arrayList = new ArrayList<Long>(this.queuesize);
                            for (Long l : this.queuein.keySet()) {
                                int n2 = this.queuesize - this.queue.size();
                                if (n2 <= 0) break;
                                TransferStatus transferStatus = this.queuein.get(l);
                                arrayList.add(l);
                                this.queue.put(l, transferStatus);
                            }
                            if (arrayList.size() > 0) {
                                for (Long l : arrayList) {
                                    this.queuein.remove(l);
                                }
                                arrayList.clear();
                                arrayList = null;
                            }
                        }
                    }
                }
                map = this.queue;
                synchronized (map) {
                    if (this.queue.size() > 0) {
                        arrayList = new ArrayList(this.queuesize);
                        for (Long l : this.queue.keySet()) {
                            TransferStatus transferStatus = this.queue.get(l);
                            if (transferStatus.getStatus() == 0) {
                                transferStatus.begin();
                                continue;
                            }
                            if (transferStatus.getStatus() != 1 && transferStatus.getStatus() != 2 && transferStatus.getStatus() != 3 && transferStatus.getStatus() != 6 && transferStatus.getStatus() != 7 && transferStatus.getStatus() != -1) continue;
                            arrayList.add(l);
                            this.queueout.put(l, transferStatus);
                            log.debug((Object)(String.valueOf(l) + " added to queueout with status " + transferStatus.getStatus()));
                        }
                        if (arrayList.size() > 0) {
                            for (Long l : arrayList) {
                                this.queue.remove(l);
                            }
                            arrayList.clear();
                            arrayList = null;
                        }
                    }
                }
            }
            log.debug((Object)"Suspended");
            try {
                Thread.sleep(SLEEPTIME);
            }
            catch (InterruptedException interruptedException) {
                log.error((Object)interruptedException);
            }
        }
    }

    public void setDestroy(boolean bl) {
        this.destroy = bl;
    }

    public boolean getDestroy() {
        return this.destroy;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public void setSuspend(boolean bl) {
        this.suspend = bl;
    }
}

