/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core.queue;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jfileupload.transfer.client.core.AbstractTransferController;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.SplitListener;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferListener;
import jfileupload.transfer.client.core.queue.QueueManager;
import jfileupload.transfer.client.core.queue.TransferStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferControllerProxy
extends AbstractTransferController {
    private static final Log log = LogFactory.getLog(TransferControllerProxy.class);
    protected boolean cancelled = false;
    private List<Long> transferControllerItems = null;
    private QueueManager queueManager = QueueManager.getInstance();
    private boolean cancelOverallOnFailure = false;
    private boolean transferDoneNotified = false;

    public TransferControllerProxy() {
        this.transferControllerItems = new ArrayList<Long>();
    }

    @Override
    public Object execute() throws ClientException {
        return null;
    }

    @Override
    public void begin() {
        this.transferDoneNotified = false;
        String string = this.getRawConf().getProperty("cancelparalleltransfersonfailure");
        this.cancelOverallOnFailure = string != null && string.equalsIgnoreCase("true");
        this.setStatus(0);
        this.queueManager.setSuspend(true);
        this.queueManager.reset();
        this.transferControllerItems.clear();
        this.cancelled = false;
        ArrayList arrayList = null;
        try {
            arrayList = this.getAllowedSourceFiles();
            this.notifyTransferTriggered(arrayList);
        }
        catch (ClientException clientException) {
            log.debug((Object)clientException);
            for (TransferListener transferListener : this.getTransferListeners()) {
                transferListener.transferFailed(clientException);
            }
            log.info((Object)"Upload failed - Files requirements");
        }
        if (!this.cancelled && arrayList != null && arrayList.size() > 0) {
            try {
                Iterator iterator = this.getSource().iterator();
                while (iterator.hasNext() && !this.cancelled) {
                    File file = new File((String)iterator.next());
                    if (file.isDirectory()) {
                        int n = file.getAbsolutePath().length();
                        int n2 = file.getName().length();
                        String string2 = file.getAbsolutePath();
                        if (n2 <= n) {
                            string2 = file.getAbsolutePath().substring(0, n - n2);
                        }
                        this.recurseProcess(file, 0L, this.getMaxDepth(), string2);
                        continue;
                    }
                    this.process(file, null);
                }
            }
            catch (ClientException clientException) {
                log.debug((Object)clientException);
            }
        }
        if (arrayList != null) {
            log.info((Object)("Items added: " + arrayList.size()));
        }
        this.queueManager.setSuspend(false);
        this.setStatus(1);
    }

    protected void recurseProcess(File file, long l, long l2, String string) throws ClientException {
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    if (l2 > -1L) {
                        if (l + 1L > l2) continue;
                        this.recurseProcess(file2, l + 1L, l2, string);
                        continue;
                    }
                    this.recurseProcess(file2, l + 1L, l2, string);
                    continue;
                }
                this.process(file2, string);
            }
        } else if (this.isEmptyDirectoryAllowed()) {
            this.process(file, string);
        }
    }

    protected void process(File file, String string) throws ClientException {
        if (!this.isAllowed(file)) {
            return;
        }
        if (this.cancelled) {
            return;
        }
        TransferController transferController = this.getRawConf().getTransferController(null);
        ProgressProxy progressProxy = new ProgressProxy();
        transferController.addTransferListener(progressProxy);
        transferController.addSplitListener(progressProxy);
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(file.getAbsolutePath());
        transferController.setSource(arrayList);
        if (string != null && string.length() > 0) {
            transferController.getParameters("dynamic").put("rootdir", string);
        }
        long l = this.queueManager.add(transferController);
        this.transferControllerItems.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.cancelled = true;
        List<Long> list = this.transferControllerItems;
        synchronized (list) {
            for (Long l : this.transferControllerItems) {
                try {
                    this.queueManager.cancelItem(l, true);
                }
                catch (ClientException clientException) {
                    log.debug((Object)clientException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransferTriggered(List list) {
        QueueManager queueManager = this.queueManager;
        synchronized (queueManager) {
            Iterator iterator = null;
            for (TransferListener transferListener : this.getTransferListeners()) {
                transferListener.transferTriggered(list, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransferDone(List list) {
        if (!this.transferDoneNotified) {
            QueueManager queueManager = this.queueManager;
            synchronized (queueManager) {
                Iterator iterator = null;
                for (TransferListener transferListener : this.getTransferListeners()) {
                    transferListener.transferDone(list);
                }
                this.transferDoneNotified = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransferStarted(Object object) {
        File file = null;
        file = object instanceof File ? (File)object : new File((String)object);
        QueueManager queueManager = this.queueManager;
        synchronized (queueManager) {
            Iterator iterator = null;
            for (TransferListener transferListener : this.getTransferListeners()) {
                if (!file.isFile()) continue;
                long l = file.length();
                transferListener.transferStarted(file, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransferCompleted(Object object, byte[] byArray) {
        File file = null;
        file = object instanceof File ? (File)object : new File((String)object);
        QueueManager queueManager = this.queueManager;
        synchronized (queueManager) {
            Iterator iterator = null;
            for (TransferListener transferListener : this.getTransferListeners()) {
                if (file == null) continue;
                transferListener.transferCompleted(object, byArray);
            }
        }
        this.dumpQueueDetails();
    }

    private void notifyDataRead(long l) {
        Iterator iterator = null;
        for (TransferListener transferListener : this.getTransferListeners()) {
            transferListener.dataRead(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransferCancelled() {
        QueueManager queueManager = this.queueManager;
        synchronized (queueManager) {
            Iterator iterator = null;
            for (TransferListener transferListener : this.getTransferListeners()) {
                transferListener.transferCancelled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTransferFailed(ClientException clientException) {
        QueueManager queueManager = this.queueManager;
        synchronized (queueManager) {
            Iterator iterator = null;
            for (TransferListener transferListener : this.getTransferListeners()) {
                transferListener.transferFailed(clientException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> dumpQueueDetails() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.getStatus() != 0) {
            List<Long> list = this.transferControllerItems;
            synchronized (list) {
                for (Long l : this.transferControllerItems) {
                    try {
                        TransferStatus transferStatus = this.queueManager.getStatus(l);
                        TransferController transferController = transferStatus.getController();
                        String string = (String)transferController.getSource().get(0);
                        log.debug((Object)(string + " = " + transferStatus.getRate() + "%"));
                        arrayList.add(new File(string));
                    }
                    catch (ClientException clientException) {
                        log.debug((Object)clientException);
                    }
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOverallTransferDone() {
        boolean bl = false;
        if (this.getStatus() != 0) {
            List<Long> list = this.transferControllerItems;
            synchronized (list) {
                int n = this.transferControllerItems.size();
                for (Long l : this.transferControllerItems) {
                    try {
                        TransferStatus transferStatus = this.queueManager.getStatus(l);
                        if (transferStatus.getStatus() != 1 && transferStatus.getStatus() != 2 && transferStatus.getStatus() != 3 && transferStatus.getStatus() != 6 && transferStatus.getStatus() != 7 && transferStatus.getStatus() != -1) continue;
                        --n;
                    }
                    catch (ClientException clientException) {
                        log.debug((Object)clientException);
                    }
                }
                if (n <= 0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTransfersWithStatus(int n) {
        int n2 = 0;
        if (this.getStatus() != 0) {
            List<Long> list = this.transferControllerItems;
            synchronized (list) {
                for (Long l : this.transferControllerItems) {
                    try {
                        TransferStatus transferStatus = this.queueManager.getStatus(l);
                        if (transferStatus.getStatus() != n) continue;
                        ++n2;
                    }
                    catch (ClientException clientException) {
                        log.debug((Object)clientException);
                    }
                }
            }
        }
        return n2;
    }

    public boolean isEmptyDirectoryAllowed() {
        boolean bl = false;
        String string = (String)this.getParameters("dynamic").get("emptydirectory");
        if (string != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    class ProgressProxy
    implements TransferListener,
    SplitListener {
        File file = null;
        long chunkamount = -1L;
        long currentchunk = 0L;
        boolean failed = false;
        long bytesSent = 0L;
        long filesize = -1L;

        ProgressProxy() {
        }

        public void transferTriggered(List list, int n) {
            this.chunkamount = -1L;
            this.currentchunk = 0L;
            this.bytesSent = 0L;
            this.filesize = -1L;
            if (list != null && list.size() > 0) {
                this.file = (File)list.get(0);
                if (this.file != null) {
                    this.filesize = this.file.length();
                }
            }
        }

        public void transferStarted(Object object, long l) {
            if (!TransferControllerProxy.this.cancelled) {
                TransferControllerProxy.this.notifyTransferStarted(object);
            }
        }

        public void dataRead(long l) {
            if (!TransferControllerProxy.this.cancelled) {
                this.bytesSent += l;
                if (this.filesize != -1L && this.bytesSent <= this.filesize) {
                    TransferControllerProxy.this.notifyDataRead(l);
                }
            }
        }

        public void transferCompleted(Object object, byte[] byArray) {
            if (!TransferControllerProxy.this.cancelled && !this.failed) {
                if (this.chunkamount > 1L) {
                    if (this.currentchunk == this.chunkamount) {
                        TransferControllerProxy.this.notifyTransferCompleted(object, byArray);
                    }
                } else {
                    TransferControllerProxy.this.notifyTransferCompleted(object, byArray);
                }
            }
        }

        public void transferCancelled() {
            TransferControllerProxy.this.notifyTransferCancelled();
        }

        public void transferFailed(ClientException clientException) {
            this.failed = true;
            if (TransferControllerProxy.this.cancelOverallOnFailure) {
                TransferControllerProxy.this.cancel();
            }
            TransferControllerProxy.this.notifyTransferFailed(clientException);
        }

        public void transferDone(List list) {
            if (!TransferControllerProxy.this.cancelled && !this.failed && TransferControllerProxy.this.isOverallTransferDone()) {
                List list2 = TransferControllerProxy.this.dumpQueueDetails();
                log.info((Object)("Overall transfer done (" + TransferControllerProxy.this.getTransfersWithStatus(1) + "/" + list2.size() + " files completed" + ")"));
                TransferControllerProxy.this.notifyTransferDone(list2);
            }
        }

        public void splitTriggered(Object object, long l, long l2, long l3, String string) {
            this.chunkamount = l3;
        }

        public void splitStarted(int n, long l) {
        }

        public void dataSplit(long l) {
        }

        public void splitCompleted(int n) {
            this.currentchunk = n;
        }

        public void splitFailed(int n, ClientException clientException) {
        }
    }
}

