/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.core.queue;

import java.io.File;
import java.util.List;
import jfileupload.transfer.client.core.ClientException;
import jfileupload.transfer.client.core.CompressListener;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferStatus
implements TransferListener,
CompressListener {
    public static final int UNKNOWN = -1;
    public static final int WAITING = 0;
    public static final int COMPLETED = 1;
    public static final int CANCELLED = 2;
    public static final int FAILED = 3;
    public static final int UPLOADING = 4;
    public static final int DOWNLOADING = 5;
    public static final int CRCFAILED = 6;
    public static final int RESUMEFAILED = 7;
    public static final int PENDING = 8;
    public static final int COMPRESSING = 9;
    private long load = 0L;
    private long size = 0L;
    private long time = -1L;
    private long elapsed = -1L;
    private int status = 0;
    private String extendedStatus = null;
    private boolean isUpload = true;
    private TransferController controller = null;
    private static final Log log = LogFactory.getLog(TransferStatus.class);

    public TransferStatus(TransferController transferController) {
        this.controller = transferController;
        this.controller.addTransferListener(this);
        this.controller.addCompressListener(this);
        this.load = 0L;
        this.size = 0L;
        this.time = -1L;
        this.elapsed = -1L;
        this.status = 0;
        this.extendedStatus = null;
    }

    public TransferController getController() {
        return this.controller;
    }

    public void begin() {
        this.controller.begin();
        this.status = 8;
    }

    public long getBytesTransferred() {
        return this.load;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public long getSize() {
        return this.size;
    }

    public long getElapsedTimeInMilliseconds() {
        if (this.time > 0L) {
            this.elapsed = System.currentTimeMillis() - this.time;
        }
        return this.elapsed;
    }

    public int getRate() {
        return Math.round((float)this.load * 100.0f / (float)this.size * 1.0f);
    }

    public int getStatus() {
        return this.status;
    }

    public String getExtendedStatus() {
        return this.extendedStatus;
    }

    public void transferTriggered(List list, int n) {
        this.isUpload = n == 1;
    }

    public void transferStarted(Object object, long l) {
        this.size = l;
        this.load = 0L;
        this.status = this.isUpload ? 4 : 5;
        this.time = System.currentTimeMillis();
        this.elapsed = 0L;
    }

    public void dataRead(long l) {
        if (l > -1L) {
            this.load += l;
        }
    }

    public void transferCancelled() {
        this.status = 2;
        this.time = -1L;
    }

    public void transferCompleted(Object object, byte[] byArray) {
        this.status = 1;
        this.time = -1L;
        this.extendedStatus = object instanceof File ? ((File)object).getAbsolutePath() : (String)object;
    }

    public void transferDone(List list) {
    }

    public void transferFailed(ClientException clientException) {
        this.time = -1L;
        this.extendedStatus = null;
        if (clientException != null) {
            this.extendedStatus = clientException.getExtMessage();
        }
        this.status = 3;
    }

    public void compressStarted(Object object, long l) {
        this.size = l;
        this.load = 0L;
        this.status = 9;
        this.time = System.currentTimeMillis();
        this.elapsed = 0L;
    }

    public void dataCompressed(long l) {
    }

    public void compressCompleted(Object object, long l) {
        this.status = 1;
        this.time = -1L;
    }

    public void compressCancelled() {
        this.status = 2;
        this.time = -1L;
    }

    public void compressFailed(ClientException clientException) {
        this.status = 3;
        this.time = -1L;
        this.extendedStatus = clientException.getExtMessage();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStatus()).append("|");
        stringBuffer.append(this.getBytesTransferred()).append("|");
        stringBuffer.append(this.getElapsedTimeInMilliseconds()).append("|");
        stringBuffer.append(this.getSize()).append("|");
        if (this.getExtendedStatus() != null) {
            stringBuffer.append(this.getExtendedStatus());
        }
        return stringBuffer.toString();
    }
}

