/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.mdesign;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileSystemView;
import jfileupload.transfer.client.core.TransferController;
import jfileupload.transfer.client.core.TransferFileFilter;
import jfileupload.transfer.client.mdesign.FileAccessory;
import jfileupload.transfer.client.mdesign.FilePreview;
import jfileupload.transfer.client.mdesign.ImagePreview;
import jfileupload.transfer.client.util.Conf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileBrowser {
    private static final Log log = LogFactory.getLog(FileBrowser.class);
    private static final String STARTDIRPREFS = "filebrowser.startdir";
    private TransferController controller = null;
    private Conf conf = null;
    private JFileChooser browse = null;
    private TransferFileFilter tff = null;
    private Component parent = null;
    private JComponent accessory = null;
    private boolean saveDialog = false;
    private String overwriteWhitelist = null;
    private String overwritePattern = null;
    private String overwriteDescription = null;

    public FileBrowser(Conf conf) {
        this.conf = conf;
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void setAccessory(JComponent jComponent) {
        this.accessory = jComponent;
    }

    public void setSaveDialog(boolean bl) {
        this.saveDialog = bl;
    }

    public void setOverwriteWhitelist(String string) {
        this.overwriteWhitelist = string;
    }

    public void setOverwritePattern(String string) {
        this.overwritePattern = string;
    }

    public void setOverwriteDescription(String string) {
        this.overwriteDescription = string;
    }

    public void reset() {
        if (this.tff != null) {
            this.browse.removeChoosableFileFilter(this.tff);
            this.browse.setFileFilter(null);
            this.tff = null;
        }
        this.overwritePattern = null;
        this.overwriteWhitelist = null;
        this.overwriteDescription = null;
    }

    public List browse(boolean bl) {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        Object object4;
        Object object5;
        String string;
        String string2;
        Object object6;
        String string3;
        ArrayList<Object[]> arrayList = null;
        if (this.browse == null) {
            this.browse = new JFileChooser();
            string3 = this.conf.getResource("filechooser.dialog.lnk");
            if (string3 != null && string3.equalsIgnoreCase("disabled")) {
                object6 = new NoLnkFileSystemView();
                this.browse.setFileSystemView((FileSystemView)object6);
            }
        }
        string3 = this.conf.getProperty("filechooserpattern");
        if (this.overwritePattern != null && this.overwritePattern.length() > 0) {
            string3 = this.overwritePattern;
        }
        object6 = null;
        if (string3 != null && string3.startsWith("regex=")) {
            object6 = string3.substring(6);
        }
        if ((string2 = this.conf.getProperty("filechooserwhitelist")) == null) {
            string2 = this.conf.getProperty("whitelist");
        }
        if (this.overwriteWhitelist != null && this.overwriteWhitelist.length() > 0) {
            string2 = this.overwriteWhitelist;
        }
        String string4 = this.conf.getProperty("blacklist");
        String string5 = this.conf.getProperty("maxsize");
        String string6 = this.conf.getProperty("minsize");
        String string7 = this.conf.getProperty("hiddenfile");
        String string8 = this.conf.getProperty("startdir");
        String string9 = this.conf.getProperty("startfilename");
        if (this.conf.getProperty("preferences") != null && (string = this.conf.getPreferences().getProperty(STARTDIRPREFS)) != null && string.length() > 0) {
            string8 = string;
        }
        string = this.conf.getResource("filechooser.preview.image");
        long l = this.conf.getLong(string5);
        long l2 = this.conf.getLong(string6);
        if (string8 != null && ((File)(object5 = new File(string8))).isDirectory() && ((File)object5).canRead()) {
            this.browse.setCurrentDirectory((File)object5);
        }
        if (this.accessory != null) {
            this.browse.setAccessory(this.accessory);
        } else if (string != null && string.equalsIgnoreCase("enabled")) {
            object5 = new ImagePreview(this.browse, this.conf);
            this.accessory = new FileAccessory(this.conf);
            ((FileAccessory)this.accessory).setFilePreview((FilePreview)object5);
            this.browse.setAccessory(this.accessory);
        }
        object5 = this.conf.getResource("filechooser.dialog.enterkey");
        if (object5 != null && ((String)object5).equalsIgnoreCase("disabled")) {
            object4 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            this.browse.registerKeyboardAction((ActionListener)object4, KeyStroke.getKeyStroke(10, 0, false), 1);
        }
        if (this.conf.getResource("filechooser.dialog.title") != null) {
            this.browse.setDialogTitle(this.conf.getResource("filechooser.dialog.title"));
        }
        if (this.conf.getResource("filechooser.dialog.width") != null && this.conf.getResource("filechooser.dialog.height") != null) {
            int n = (int)this.conf.getLong(this.conf.getResource("filechooser.dialog.width"));
            int bl22 = (int)this.conf.getLong(this.conf.getResource("filechooser.dialog.height"));
            if (n > 0 && bl22 > 0) {
                this.browse.setPreferredSize(new Dimension(n, bl22));
            }
        }
        if (string7 == null || string7.equalsIgnoreCase("accept")) {
            this.browse.setFileHidingEnabled(false);
        } else {
            this.browse.setFileHidingEnabled(true);
        }
        object4 = this.conf.getResource("filechooser.dialog.multipleselection");
        if (object4 != null && ((String)object4).equalsIgnoreCase("disabled")) {
            this.browse.setMultiSelectionEnabled(false);
        } else {
            this.browse.setMultiSelectionEnabled(true);
        }
        if (this.saveDialog) {
            this.browse.setDialogType(1);
        } else {
            this.browse.setDialogType(0);
        }
        boolean bl3 = false;
        String string10 = this.conf.getResource("filechooser.dialog.selectionmode");
        if (string10 != null) {
            if (string10.equalsIgnoreCase("filesonly")) {
                this.browse.setFileSelectionMode(0);
            } else if (string10.equalsIgnoreCase("directoriesonly")) {
                this.browse.setFileSelectionMode(1);
            } else if (string10.equalsIgnoreCase("writabledirectoriesonly")) {
                this.browse.setFileSelectionMode(1);
                bl2 = true;
            } else {
                this.browse.setFileSelectionMode(2);
            }
        } else {
            this.browse.setFileSelectionMode(2);
        }
        if (string9 != null) {
            object3 = new File(string9);
            this.browse.setSelectedFile((File)object3);
        }
        this.browse.setEnabled(true);
        if (string2 != null || string4 != null || bl2 || object6 != null) {
            if (this.tff == null) {
                object3 = this.conf.getResource("filechooser.dialog.allfilefilter");
                if (object3 != null && ((String)object3).equalsIgnoreCase("true")) {
                    this.browse.setAcceptAllFileFilterUsed(true);
                } else {
                    this.browse.setAcceptAllFileFilterUsed(false);
                }
                this.tff = new TransferFileFilter(string4, string2, l, l2, string7, bl2);
                this.tff.setRegExp((String)object6);
                object2 = this.conf.getResource("filechooser.dialog.filefilter.label");
                if (this.overwriteDescription != null && this.overwriteDescription.length() > 0) {
                    object2 = this.overwriteDescription;
                }
                if (object2 != null) {
                    this.tff.setDescription((String)object2);
                } else if (string4 != null) {
                    object = this.conf.getResource("filechooser.dialog.filefilter.blacklist");
                    if (object != null) {
                        objectArray = new Object[]{this.tff.getDescription()};
                        this.tff.setDescription(this.conf.getFormattedMessage((String)object, objectArray));
                    }
                } else if (object6 != null) {
                    this.tff.setDescription((String)object6);
                }
                this.browse.setFileFilter(this.tff);
                this.browse.addChoosableFileFilter(this.tff);
            }
        } else {
            this.browse.setAcceptAllFileFilterUsed(true);
        }
        if (this.parent == null) {
            this.parent = new JFrame();
        }
        int n = -1;
        n = this.saveDialog ? this.browse.showSaveDialog(this.parent) : this.browse.showOpenDialog(this.parent);
        if (n == 0) {
            if (this.conf.getProperty("preferences") != null) {
                object2 = this.browse.getCurrentDirectory().getAbsolutePath();
                if (this.browse.getFileSelectionMode() == 1 && (object = this.browse.getSelectedFile()) != null && ((File)object).isDirectory() && ((File)object).exists()) {
                    object2 = ((File)object).getAbsolutePath();
                }
                if (object2 != null && ((String)object2).length() > 0) {
                    this.conf.getPreferences().setProperty(STARTDIRPREFS, (String)object2);
                }
            }
            object2 = null;
            if (object4 != null && ((String)object4).equalsIgnoreCase("disabled")) {
                object = this.browse.getSelectedFile();
                if (object != null) {
                    object2 = new File[]{object};
                }
            } else {
                object2 = this.browse.getSelectedFiles();
            }
            if (object2 != null && ((File[])object2).length > 0) {
                arrayList = new ArrayList<Object[]>();
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    objectArray = ((File)object2[i]).getAbsolutePath();
                    if (objectArray == null || !new File((String)objectArray).exists()) continue;
                    arrayList.add(objectArray);
                }
                if (bl) {
                    this.controller.setSource(arrayList);
                    this.controller.begin();
                }
            }
        }
        return arrayList;
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component component) {
        this.parent = component;
    }

    public TransferController getController() {
        return this.controller;
    }

    public void setController(TransferController transferController) {
        this.controller = transferController;
    }

    class NoLnkFileSystemView
    extends FileSystemView {
        public Boolean isTraversable(File file) {
            Boolean bl = super.isTraversable(file);
            if (file.isDirectory() && file.getAbsolutePath().toLowerCase().endsWith(".lnk")) {
                bl = Boolean.FALSE;
            }
            return bl;
        }

        public File createNewFolder(File file) throws IOException {
            return NoLnkFileSystemView.getFileSystemView().createNewFolder(file);
        }
    }
}

