/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.mdesign;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import jfileupload.transfer.client.core.AbstractTransferController;
import jfileupload.transfer.client.util.Conf;

public class OverwritePane
extends JOptionPane {
    public static final int OVERWRITE_DEFAULT = -1;
    public static final int OVERWRITE_RESUME = 10;
    public static final int OVERWRITE_OVERWRITE = 11;
    public static final int OVERWRITE_SKIP = 12;
    public static final int OVERWRITE_CANCEL = 13;
    public static final int AUTH_OK_OPTION = 1000;
    private Conf conf = null;
    private OverwritePanel message = null;
    private JDialog dialog = null;
    private Container parent = null;
    private AbstractTransferController.HeadInfo headInfo = null;
    private boolean resume = true;

    public OverwritePane(Conf conf) {
        this.conf = conf;
        this.message = new OverwritePanel();
    }

    public void setParent(Container container) {
        this.parent = container;
    }

    public void setResume(boolean bl) {
        this.resume = bl;
    }

    public void setHeadInfo(AbstractTransferController.HeadInfo headInfo) {
        this.headInfo = headInfo;
    }

    protected void loadUI() {
        Object object;
        if (this.headInfo.getRemoteSize() < this.headInfo.getFile().length()) {
            if (this.headInfo.getRemoteSize() == this.headInfo.getResumeOffset()) {
                this.headInfo.setContentMatch("CONTENT_PARTIAL_MATCH");
                object = this.conf.getResource("overwritewarn.resume.label");
                if (this.resume && object != null) {
                    this.message.getTitleLabel().setText(MessageFormat.format((String)object, this.headInfo.getName()));
                    this.message.removeOverwrite();
                    this.message.getResumeButton().setSelected(true);
                } else {
                    this.message.getTitleLabel().setText(MessageFormat.format(this.conf.getResource("overwritewarn.differ.label"), this.headInfo.getName()));
                    this.message.removeResume();
                    this.message.getOverwriteButton().setSelected(true);
                }
            } else {
                this.headInfo.setContentMatch("CONTENT_NOT_MATCH");
                this.message.getTitleLabel().setText(MessageFormat.format(this.conf.getResource("overwritewarn.differ.label"), this.headInfo.getName()));
                this.message.removeResume();
                this.message.getOverwriteButton().setSelected(true);
            }
        } else if (this.headInfo.getRemoteSize() == this.headInfo.getFile().length()) {
            if (this.headInfo.getRemoteSize() == this.headInfo.getResumeOffset()) {
                this.headInfo.setContentMatch("CONTENT_FULL_MATCH");
                this.message.getTitleLabel().setText(MessageFormat.format(this.conf.getResource("overwritewarn.identical.label"), this.headInfo.getName()));
            } else {
                this.headInfo.setContentMatch("CONTENT_NOT_MATCH");
                this.message.getTitleLabel().setText(MessageFormat.format(this.conf.getResource("overwritewarn.differ.label"), this.headInfo.getName()));
            }
            this.message.removeResume();
            this.message.getOverwriteButton().setSelected(true);
        } else {
            this.headInfo.setContentMatch("CONTENT_NOT_MATCH");
            this.message.getTitleLabel().setText(MessageFormat.format(this.conf.getResource("overwritewarn.differ.label"), this.headInfo.getName()));
            this.message.removeResume();
            this.message.getOverwriteButton().setSelected(true);
        }
        object = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OverwritePane.this.setValue(new Integer(1000));
                OverwritePane.this.dialog.dispose();
            }
        };
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0, false), "AUTH_YES_OPTION");
        this.getActionMap().put("AUTH_YES_OPTION", (Action)object);
        JButton jButton = new JButton(this.conf.getResource("overwritewarn.confirm.yes"));
        jButton.addActionListener((ActionListener)object);
        Object[] objectArray = new Object[]{jButton};
        this.setMessage(this.message);
        this.setOptions(objectArray);
        this.setMessageType(3);
        this.setOptionType(-1);
    }

    public int popup() {
        this.loadUI();
        int n = 13;
        String string = this.conf.getResource("overwritewarn.title");
        if (this.parent == null) {
            this.parent = this.getParent();
        }
        this.dialog = this.createDialog(this.parent, string);
        this.dialog.setDefaultCloseOperation(0);
        String string2 = this.conf.getResource("overwritewarn.location.x");
        String string3 = this.conf.getResource("overwritewarn.location.y");
        if (string2 != null && string3 != null) {
            int n2 = (int)this.conf.getLong(string2);
            int n3 = (int)this.conf.getLong(string3);
            String string4 = this.conf.getResource("overwritewarn.location.position");
            if (string4 != null && string4.equalsIgnoreCase("relative")) {
                Point point = this.dialog.getLocation();
                this.dialog.setLocation(point.x + n2, point.y + n3);
            } else {
                this.dialog.setLocation(n2, n3);
            }
        }
        this.dialog.setVisible(true);
        n = this.message.getSelectedValue();
        return n;
    }

    public class OverwritePanel
    extends JPanel {
        private JLabel titleLabel;
        private JRadioButton resumeButton;
        private JRadioButton overwriteButton;
        private JRadioButton skipButton;
        private JRadioButton cancelButton;

        public OverwritePanel() {
            this.initComponents();
        }

        public void removeResume() {
            this.remove(this.resumeButton);
        }

        public void removeOverwrite() {
            this.remove(this.overwriteButton);
        }

        public JLabel getTitleLabel() {
            return this.titleLabel;
        }

        public JRadioButton getResumeButton() {
            return this.resumeButton;
        }

        public JRadioButton getOverwriteButton() {
            return this.overwriteButton;
        }

        private void initComponents() {
            String string;
            String string2;
            String string3;
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gridBagConstraints = null;
            this.titleLabel = new JLabel();
            this.resumeButton = new JRadioButton();
            this.overwriteButton = new JRadioButton();
            this.skipButton = new JRadioButton();
            this.cancelButton = new JRadioButton();
            this.setLayout(new GridBagLayout());
            int n = 0;
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 2, 9, 2);
            this.add((Component)this.titleLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            String string4 = OverwritePane.this.conf.getResource("overwritewarn.resume");
            if (string4 != null) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.insets = new Insets(1, 4, 1, 4);
                this.resumeButton.setText(string4);
                buttonGroup.add(this.resumeButton);
                this.add((Component)this.resumeButton, gridBagConstraints);
            }
            if ((string3 = OverwritePane.this.conf.getResource("overwritewarn.overwrite")) != null) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.insets = new Insets(1, 4, 1, 4);
                this.overwriteButton.setText(string3);
                buttonGroup.add(this.overwriteButton);
                this.add((Component)this.overwriteButton, gridBagConstraints);
            }
            if ((string2 = OverwritePane.this.conf.getResource("overwritewarn.skip")) != null) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.insets = new Insets(1, 4, 1, 4);
                this.skipButton.setText(string2);
                buttonGroup.add(this.skipButton);
                this.add((Component)this.skipButton, gridBagConstraints);
            }
            if ((string = OverwritePane.this.conf.getResource("overwritewarn.cancel")) != null) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.insets = new Insets(1, 4, 1, 4);
                this.cancelButton.setText(string);
                buttonGroup.add(this.cancelButton);
                this.add((Component)this.cancelButton, gridBagConstraints);
            }
        }

        public int getSelectedValue() {
            int n = 13;
            n = this.overwriteButton.isSelected() ? 11 : (this.skipButton.isSelected() ? 12 : (this.resumeButton.isSelected() ? 10 : 13));
            return n;
        }
    }
}

