/*
 * Decompiled with CFR 0.152.
 */
package jfileupload.transfer.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomResourceBundle {
    private static final Log log = LogFactory.getLog(CustomResourceBundle.class);
    public static final String EXT = ".properties";
    public static String PREFIX = "jfileupload/";
    private String extension = ".properties";
    private ResourceBundle bundle = null;
    private Properties bundleProps = null;
    private URL baseURL = null;
    private boolean i18n = true;
    private String internalPrefix = null;

    public CustomResourceBundle(boolean bl) {
        this.i18n = bl;
        this.internalPrefix = PREFIX;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL uRL) {
        this.baseURL = uRL;
    }

    public String getInternalPrefix() {
        return this.internalPrefix;
    }

    public void setInternalPrefix(String string) {
        this.internalPrefix = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBundle(String string) {
        if (this.i18n) {
            this.bundle = ResourceBundle.getBundle(string);
        } else {
            this.bundleProps = new Properties();
            if (!string.endsWith(this.extension)) {
                string = string.startsWith(this.internalPrefix) ? string + EXT : string + this.extension;
            }
            InputStream inputStream = null;
            try {
                inputStream = string.startsWith("http://") || string.startsWith("https://") ? new URL(string).openStream() : (this.baseURL != null && !string.startsWith(this.internalPrefix) ? new URL(this.baseURL, string).openStream() : this.getClass().getClassLoader().getResourceAsStream(string));
                if (inputStream == null) {
                    log.error((Object)("Cannot load " + string));
                    inputStream = this.getClass().getClassLoader().getResourceAsStream("jfileupload/transfer/client/util/resources.properties");
                }
                if (inputStream != null) {
                    this.bundleProps.load(inputStream);
                }
            }
            catch (IOException iOException) {
                log.error((Object)("Cannot load " + string), (Throwable)iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.error((Object)iOException);
                }
            }
        }
    }

    public String getString(String string) throws MissingResourceException {
        String string2 = null;
        if (string != null) {
            if (this.i18n) {
                string2 = this.bundle.getString(string);
            } else {
                if (this.bundleProps != null) {
                    string2 = this.bundleProps.getProperty(string);
                }
                if (string2 == null) {
                    throw new MissingResourceException("", "MissingResourceException", string);
                }
            }
        }
        return string2;
    }
}

