<?php
/*
	Edit image files with Aviary.com
*/
class custom_aviary {
	function init() {
		global $locale;
		$this->localeSection = "Custom Actions: Aviary";
		$this->JSconfig = array(
			"title" => $locale->get("Aviary", $this->localeSection),
			"iconCls" => 'fa fa-fw fa-cloud',
			"extensions" => array("jpg", "jpeg", "png"),
			"popup" => true,
			"requiredUserPerms" => array("download")
		);
		$this->outputName = "imageOutput";
	}
	function run() {
		$weblinkInfo = $this->weblinks->createForService($this->data['filePath'], false, $this->data['relativePath']);
		if (!$weblinkInfo) {
			echo "Failed to setup weblink";
			exit();
		}
		$this->data['fileURL'] = $this->weblinks->getURL(array("id_rnd" => $weblinkInfo['id_rnd']));
		$this->data['saveURL'] = $this->weblinks->getSaveURL($weblinkInfo['id_rnd'], false, "aviary");
		require($this->path."/display.php");
		global $log;
		$log->add(false, "preview", array(
			"relative_path" => $this->data['relativePath'],
			"full_path" => $this->data['filePath'],
			"method" => "Aviary"
		));
	}
	
	function getNewFileContents() {
		global $str;
		$snoopy = new Snoopy;
		$url = $str->fromHTML($_REQUEST['url']);
		$snoopy->fetch($url);
		return $snoopy->results;
	}
}