<?php
class custom_code_editor {
	function init() {
		global $locale;
		$this->localeSection = "Custom Actions: Text Editor";
		$this->JSconfig = array(
			"title" => $locale->get("Text Editor", $this->localeSection),
			'iconCls' => 'fa fa-fw fa-file-text-o',
			'useWith' => array('txt', 'noext'),
			"popup" => true,
			"createNew" => array(
				"title" => $locale->get("Text File", $this->localeSection),
				"options" => array(
					array(
						'fileName' => $locale->get('New Text File.txt', $this->localeSection),
						'title' => $locale->get('Plain Text', $this->localeSection),
						'iconCls' => 'fa fa-fw fa-file-text-o',
					),
					array(
						'fileName' => 'index.html',
						'title' => $locale->get('HTML', $this->localeSection),
						'iconCls' => 'fa fa-fw fa-file-code-o',
					),
					array(
						'fileName' => 'script.js',
						'title' => $locale->get('JavaScript', $this->localeSection),
						'iconCls' => 'fa fa-fw fa-file-code-o',
					),
					array(
						'fileName' => 'style.css',
						'title' => $locale->get('CSS', $this->localeSection),
						'iconCls' => 'fa fa-fw fa-file-code-o',
					),
					array(
						'fileName' => 'index.php',
						'title' => $locale->get('PHP', $this->localeSection),
						'iconCls' => 'fa fa-fw fa-file-code-o',
					),
					array(
						'fileName' => 'index.xml',
						'title' => $locale->get('XML', $this->localeSection),
						'iconCls' => 'fa fa-fw fa-file-code-o',
					),
					array(
						'fileName' => '',
						'title' => $locale->get('Other..', $this->localeSection),
						'iconCls' => 'fa fa-fw fa-file-text-o',
					)
				)
			),
			"requiredUserPerms" => array("download", "upload")
		);
	}
	function run() {
		global $log, $fileman;
		$fileman->checkPerms("download");
		$this->data['fileContents'] = file_get_contents($this->data['filePath']);
		require($this->path."/display.php");
		$log->add(false, "preview", array(
			"relative_path" => $this->data['relativePath'],
			"full_path" => $this->data['filePath'],
			"method" => "Code Editor"
		));
	}
	function saveChanges() {
		global $str, $myfiles, $locale, $fileman, $fm;
		$fileman->checkPerms("upload");
		$textContents = $str->fromHTML($_POST['textContents']);
		$rs = $myfiles->newFile($fm->dirname($this->data['relativePath']), $this->data['fileName'], false, $textContents);
		if ($rs) {
			jsonOutput(array("rs" => true, "filename" => $this->data['fileName'], "msg" => $locale->get("File successfully saved", $this->localeSection)));
		} else {
			jsonOutput(array("rs" => false, "msg" => $myfiles->error['msg']));
		}
	}
	function createBlankFile() {
		global $myfiles, $locale, $fileman, $fm;
		$fileman->checkPerms("upload");
		if (strlen($this->data['fileName']) == 0) {
			jsonOutput(array("rs" => false, "msg" => $locale->get('Please type a file name', $this->localeSection)));
		} else {
			if (is_file($this->data['filePath'])) {
				jsonOutput(array("rs" => false, "msg" => $locale->get('A file with that name already exists', $this->localeSection)));
			}
			$rs = $myfiles->newFile($fm->dirname($this->data['relativePath']), $this->data['fileName'], false, "");
			if ($rs) {
				jsonOutput(array("rs" => true, 'path' => $this->data['relativePath'], "filename" => $this->data['fileName'], "msg" => $locale->get("File successfully created", $this->localeSection)));
			} else {
				jsonOutput(array("rs" => false, "msg" => $myfiles->error['msg']));
			}
		}
	}
}