<?php
/*
	View in Google Earth...
*/
class custom_kml_viewer {
	function init() {
		global $locale;
		$this->URL = 'http://earth.google.com/kmlpreview/';
		$this->JSconfig = array(
			"title" => $locale->get('Google Earth', 'Custom Actions: Google Earth'),
			"iconCls" => 'fa fa-fw fa-cloud',
			"extensions" => array("kml", "kmz"),
			"popup" => true,
			"requiredUserPerms" => array("download")
		);
	}
	function run() {
	$data = $this->weblinks->createForService($this->data['filePath'], 2, $this->data['relativePath']);
	$url = $this->weblinks->getURL(array(
			"id_rnd" => $data['id_rnd'],
			"filename" => $this->data['fileName']
		)
	);
	if (!$url) {
		echo "Failed to setup weblink";
		exit();
	}
	
	global $log;
	$log->add(false, "preview", array(
		"relative_path" => $this->data['relativePath'],
		"full_path" => $this->data['filePath'],
		"method" => "google-earth"
	));
?>
<html>
<head>
	<title></title>
	<style>
		body {
			border: 0px;
			margin: 0px;
			padding: 0px;
			overflow:hidden;
		}
	</style>
</head>

<body>
<iframe scrolling="no" width="100%" height="100%" border="0" src="<?php echo $this->URL?>#url=<?php echo urlencode($url)?>">
</iframe> 
</body>
</html>
<?php
	}
}