<?php
class custom_mediainfo {
	function init() {
		$this->config = array(
			'localeSection' => 'Custom Actions: MediaInfo'
		);
		$this->JSconfig = array(
			'title' => $this->getString('Media Info'),
			'iconCls' => 'fa fa-fw fa-info-circle',
			'requiredUserPerms' => array('download'),
			"popup" => true
		);
	}
	function getString($s) {
		global $locale, $str;
		return $str->safeJS($locale->get($s, $this->config['localeSection']));
	}
	function run() {
		global $fm, $locale;
		$getID3 = new getID3;
		$fInfo = $getID3->analyze($this->data['filePath']);
		require($this->path."/display.php");
	}
	function displayRow($title, $value) {
		global $str;
		if (is_array($value)) {
			$value = '<div>'.implode('</div><div>', $value).'</div>';
		} else {
			$value = $str->safeHTML($str->forHTML(trim($value)));
		}
		if (strlen($value) > 0 && $value != "0") {
			echo '<tr>';
				echo '<td>'.$title.'</td>';
				echo '<td>'.$value.'</td>';
			echo '</tr>';
		}
	}
}
