FR.addMetadataField = {};
FR.addMetadataField.formPanel = new FR.components.editForm({
	title: FR.T('Edit Field'),
	layout: 'form', bodyStyle: 'padding:10px;', autoScroll: true,
	items: [
		{
			xtype: 'fieldset',
			width: 500,
			defaults: {width: 200},
			items: [
				{
					xtype: 'hidden',
					name: 'id',
					value: FR.fieldInfo.id
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('Field name'),
					name: 'name',
					value: FR.fieldInfo.name
				},{
					xtype: 'textarea',
					fieldLabel: FR.T('Description'),
					name: 'description',
					value: FR.fieldInfo.description
				},{
					xtype: 'checkbox',
					boxLabel: FR.T('Show by default as column in file grid'),
					width: 400, value: 1,
					name: 'show_column_by_default', checked: parseInt(FR.fieldInfo.show_column_by_default)
				},{
					xtype: 'checkbox',
					boxLabel: FR.T('Hide fieldset name in column header'),
					width: 400, value: 1,
					name: 'hide_fieldset_name_in_column', checked: parseInt(FR.fieldInfo.hide_fieldset_name_in_column)
				},{
					xtype: 'textfield',
					fieldLabel: FR.T('Predefined values'),
					name: 'options', value: FR.fieldInfo.options,
					helpText: FR.T('Separate values by commas. Example: one, two, three')
				},{
					xtype: 'textfield',
					fieldLabel: FR.T('Automatic source'),
					name: 'source', value: FR.fieldInfo.source,
					helpText: FR.T('This is the path to the "Media Info" field.')
				}
			]
		}
	],
	tbar: [
		{
			text: FR.T('Save Changes'),
			iconCls: 'fa fa-fw fa-save',
			ref: 'saveBtn',
			handler: function() {
				var editForm = this.ownerCt.ownerCt;
				var opts = {
					url: FR.URLRoot+'/?module=metadata&section=cpanel&page=edit_field&action=save',
					maskText: 'Saving changes...'
				};
				editForm.submitForm(opts);
			}
		}
	]
});
Ext.getCmp('gridTabPanel').add(FR.addMetadataField.formPanel);
FR.addMetadataField.formPanel.show();