FR.editSettings = {};
FR.editSettings.formPanel = new FR.components.editForm({
	title: FR.T('BitTorrent Sync Integration'),
	layout: 'form', bodyStyle: 'padding:10px;',
	labelWidth: 250, autoScroll: true, defaults: {width: 500},
	items: [
		{
			xtype: 'fieldset',
			checkboxToggle: {tag: 'input', type: 'checkbox', name: this.checkboxName || this.id + '-checkbox', id: 'settings[btsync_enable]'},
			checkboxName: 'settings[btsync_enable]',
			title: FR.T('Enable BitTorrent Sync API Integration'), animCollapse: true,
			collapsed: !parseInt(FR.settings.btsync_enable),
			labelWidth: 100, defaults: {width: 200},
			listeners: {'expand': function() {if (!this.layoutPatched) {this.doLayout(false, true);this.layoutPatched = true;}}},
			items: [
				{
					xtype: 'textfield',
					fieldLabel: FR.T('API host'),
					name: 'settings[btsync_api_host]', value: FR.settings.btsync_api_host, readOnly: true,
					helpText: FR.T('BitTorrent Sync needs to run on this server.')
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('API port'), width: 50,
					name: 'settings[btsync_api_port]', value: FR.settings.btsync_api_port,
					helpText: FR.T('The default port number is 8888')
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('API username'),
					name: 'settings[btsync_api_username]', value: FR.settings.btsync_api_username
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('API password'),
					name: 'settings[btsync_api_password]', value: FR.settings.btsync_api_password,
					inputType: 'password', listeners: {
						'focus': function() {
							this.getEl().dom.setAttribute('type', 'text');
						},
						'blur': function() {
							this.getEl().dom.setAttribute('type', 'password');
						}
					}
				},
				{
					xtype: 'panel', border: false, layout: 'hbox', width: 500,
					layoutConfig: {padding: 5}, bodyStyle: 'padding-left:100px',
					defaults:{margins:'0 5 0 0'},
					items: [
						{xtype: 'button', text: FR.T('Test settings'), cls: 'fr-btn-smaller fr-btn-nomargin',
							handler: function() {
							var params = this.ownerCt.ownerCt.ownerCt.form.getValues();
							var output = this.ownerCt.ownerCt.serverReply; output.show();
							FR.utils.getAjaxOutput(FR.URLRoot+'/?module=cpanel&section=settings&page=btsync&action=test', params, output);
						}}
					]
				},
				{xtype: 'displayfield', ref: 'serverReply', width:300, value: 'test', style:'border:1px solid silver;padding:3px;', hidden: true}
			]
		}
	],
	tbar: [
		{
			text: FR.T('Save Changes'),
			iconCls: 'fa fa-fw fa-save',
			ref: 'saveBtn',
			handler: function() {
				var editForm = this.ownerCt.ownerCt;
				var params = editForm.form.getFieldValues();
				var extra = {};
				extra['settings[btsync_enable]'] = Ext.get('settings[btsync_enable]').dom.checked ? 1:0;
				Ext.apply(params, extra);
				var opts = {
					url: FR.URLRoot+'/?module=cpanel&section=settings&action=save',
					maskText: 'Saving changes...',
					params: params
				};
				editForm.submitForm(opts);
			}
		}
	]
});
Ext.getCmp('appTab').add(FR.editSettings.formPanel);
Ext.getCmp('appTab').doLayout();