FR.editSettings = {};
FR.editSettings.formPanel = new FR.components.editForm({
	title: FR.T('Google'),
	layout: 'form', bodyStyle: 'padding:10px;',
	autoScroll: true, defaults: {width: 500},
	items: [
		{
			xtype: 'fieldset',
			checkboxToggle: {tag: 'input', type: 'checkbox', name: this.checkboxName || this.id + '-checkbox', id: 'settings[captcha]'},
			checkboxName: 'settings[captcha]',
			title: FR.T('Enable <a href="%1" target="_blank">reCAPTCHA</a>').replace('%1', 'https://www.google.com/recaptcha'), animCollapse: true,
			collapsed: !parseInt(FR.settings.captcha),
			labelWidth: 150,
			items: [
				{
					xtype: 'textfield',
					fieldLabel: FR.T('reCAPTCHA site key'), width: 280,
					name: 'settings[recaptcha_site_key]', value: FR.settings.recaptcha_site_key
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('reCAPTCHA secret key'), width: 280,
					name: 'settings[recaptcha_secret_key]', value: FR.settings.recaptcha_secret_key
				},
				{
					xtype: 'displayfield', hideLabel: true, style: 'color:gray', value: 'Get these two keys from %1'.replace('%1', '<a href="https://www.google.com/recaptcha/admin" target="_blank"">https://www.google.com/recaptcha/admin</a>')
				}
			]
		},
		{
			xtype: 'fieldset', labelWidth: 150,
			title: FR.T('OAuth'),
			items: [
				{
					xtype: 'textfield',
					fieldLabel: FR.T('Client ID'), width: 280,
					name: 'settings[google_client_id]', value: FR.settings.google_client_id
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('Client secret'), width: 280,
					name: 'settings[google_client_secret]', value: FR.settings.google_client_secret
				}
			]
		},
		{
			xtype: 'fieldset', labelWidth: 150,
			title: FR.T('Public API access'),
			items: [
				{
					xtype: 'textfield',
					fieldLabel: FR.T('API key'), width: 280,
					name: 'settings[google_shortener_key]', value: FR.settings.google_shortener_key
				}
			]
		},
		{
			xtype: 'displayfield', hideLabel: true, style: 'color:gray', value: FR.T('Google API keys, ids and secrets can be generated from the "<a href="%1" target="_blank">Google Developer Console</a>"').replace('%1', 'https://console.developers.google.com/project')
		}
	],
	tbar: [
		{
			text: FR.T('Save Changes'),
			iconCls: 'fa fa-fw fa-save',
			ref: 'saveBtn',
			handler: function() {
				var editForm = this.ownerCt.ownerCt;
				var params = editForm.form.getFieldValues();
				var extra = {};
				extra['settings[captcha]'] = Ext.get('settings[captcha]').dom.checked ? 1:0;
				Ext.apply(params, extra);
				var opts = {
					url: FR.URLRoot+'/?module=cpanel&section=settings&action=save',
					maskText: 'Saving changes...',
					params: params
				};
				editForm.submitForm(opts);
			}
		}
	]
});
Ext.getCmp('appTab').add(FR.editSettings.formPanel);
Ext.getCmp('appTab').doLayout();