FR.editSettings = {custom_actions:[]};
Ext.each(FR.customActionsInfo, function(item) {
	var label = '';
	if (item.iconCls) {
		label += '<i class="'+item.iconCls+'" style="color:gray"></i> ';
	}
	label += item.title;
	FR.editSettings.custom_actions.push({xtype: 'checkbox', name:'settings[disable_custom_action_'+item.id+']', inputValue: item.id, boxLabel: label, checked: (FR.settings['disable_custom_action_'+item.id] == '1')});
});
FR.editSettings.formPanel = new FR.components.editForm({
	title: FR.T('Misc options'),
	layout: 'form', bodyStyle: 'padding:10px;',
	labelWidth: 250, autoScroll: true, defaults: {width: 500},
	items: [
		{
			xtype: 'fieldset', labelWidth: 200, defaults: {width: 250},
			items:[
				{xtype: 'displayfield', hidden: !Ext.isIE},
				{
					xtype: 'checkbox',
					boxLabel: FR.T('Enable maintenance mode'), value: 1,
					name: 'settings[maintenance]', checked: parseInt(FR.settings.maintenance),
					helpText: FR.T('Disables users access and WebLinks.<br>The superuser still has normal access.')
				},
				{
					xtype: 'textarea',
					fieldLabel: FR.T('Maintenance message to users'), height: 70,
					name: 'settings[maintenance_message_users]', value: FR.settings.maintenance_message_users
				},
				{
					xtype: 'textarea',
					fieldLabel: FR.T('Maintenance message to public'), height: 70,
					name: 'settings[maintenance_message_public]', value: FR.settings.maintenance_message_public
				}
			]
		},{
			xtype: 'fieldset',
			labelWidth: 1,
			items:[
				{xtype: 'displayfield', hidden: !Ext.isIE},
				{
					xtype: 'checkbox',
					boxLabel: FR.T('Disable file versioning.'),
					width: 400, value: 1,
					name: 'settings[disable_versioning]', checked: parseInt(FR.settings.disable_versioning)
				},
				{
					xtype: 'checkbox',
					boxLabel: FR.T('Disable the file activity logs.'),
					width: 400, value: 1,
					name: 'settings[disable_file_history]', checked: parseInt(FR.settings.disable_file_history)
				}
			]
		},
		{
			xtype: 'fieldset', labelWidth: 300,
			items:[
				{
					xtype: 'textfield',
					fieldLabel: FR.T('Number of days to keep the user activity log entries'), width: 50,
					name: 'settings[user_activity_logs_entry_lifetime]', value: FR.settings.user_activity_logs_entry_lifetime
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('Number of days to keep the file activity log entries'), width: 50,
					name: 'settings[file_history_entry_lifetime]', value: FR.settings.file_history_entry_lifetime
				}
			]
		},
		{
			xtype: 'fieldset', labelWidth: 300,
			items: [
				{
					xtype: 'textfield',
					fieldLabel: FR.T('Users quota warning level'),
					name: 'settings[quota_warning_level]', width: 60,
					value: FR.settings.quota_warning_level,
					helpText: FR.T('Set a number between 70 and 100, representing the quota usage percentage.')
				}
			]
		},
		{
			xtype: 'fieldset', title: FR.T('Disable file action plugins'), defaults: {hideLabel: true},
			items: FR.editSettings.custom_actions
		}
	],
	tbar: [
		{
			text: FR.T('Save Changes'),
			iconCls: 'fa fa-fw fa-save',
			ref: 'saveBtn',
			handler: function() {
				var editForm = this.ownerCt.ownerCt;
				var params = editForm.form.getFieldValues();
				var opts = {
					url: FR.URLRoot+'/?module=cpanel&section=settings&action=save',
					maskText: 'Saving changes...',
					params: params
				};
				editForm.submitForm(opts);
			}
		}
	]
});
Ext.getCmp('appTab').add(FR.editSettings.formPanel);
Ext.getCmp('appTab').doLayout();