FR.editSettings = {};
FR.editSettings.formPanel = new FR.components.editForm({
	title: FR.T('Pusher.com'),
	layout: 'form', bodyStyle: 'padding:10px;',
	labelWidth: 250, autoScroll: true, defaults: {width: 500},
	items: [
		{
			xtype: 'fieldset',
			checkboxToggle: {tag: 'input', type: 'checkbox', name: this.checkboxName || this.id + '-checkbox', id: 'settings[pushercom_enable]'},
			checkboxName: 'settings[pushercom_enable]',
			title: FR.T('Enable Pusher.com Integration'), animCollapse: true,
			collapsed: !parseInt(FR.settings.pushercom_enable),
			labelWidth: 100, defaults: {width: 200},
			items: [
				{
					xtype: 'textfield',
					fieldLabel: FR.T('App ID'), width: 100,
					name: 'settings[pushercom_app_id]', value: FR.settings.pushercom_app_id
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('App Key'),
					name: 'settings[pushercom_app_key]', value: FR.settings.pushercom_app_key
				},
				{
					xtype: 'textfield',
					fieldLabel: FR.T('App Secret'),
					name: 'settings[pushercom_app_secret]', value: FR.settings.pushercom_app_secret,
					inputType: 'password', listeners: {
						'focus': function() {
							this.getEl().dom.setAttribute('type', 'text');
						},
						'blur': function() {
							this.getEl().dom.setAttribute('type', 'password');
						}
					}
				}
			]
		}
	],
	tbar: [
		{
			text: FR.T('Save Changes'),
			iconCls: 'fa fa-fw fa-save',
			ref: 'saveBtn',
			handler: function() {
				var editForm = this.ownerCt.ownerCt;
				var params = editForm.form.getFieldValues();
				var extra = {};
				extra['settings[pushercom_enable]'] = Ext.get('settings[pushercom_enable]').dom.checked ? 1:0;
				Ext.apply(params, extra);
				var opts = {
					url: FR.URLRoot+'/?module=cpanel&section=settings&action=save',
					maskText: 'Saving changes...',
					params: params
				};
				editForm.submitForm(opts);
			}
		}
	]
});
Ext.getCmp('appTab').add(FR.editSettings.formPanel);
Ext.getCmp('appTab').doLayout();