FR.components.Grid = Ext.extend(Ext.grid.GridPanel, {
    initComponent: function() {
		this.store = new Ext.data.Store({
			url: '/', remoteSort: true,
			baseParams: {limit: FR.system.gridItemsPerPage},
			reader: new Ext.data.JsonReader()
		});
        this.store.on('metachange', function (store, meta) {
			var columns = [];
			for (var i = 0; i < meta.fields.length; i++ ) {
				if (meta.fields[i].header) {
					meta.fields[i].dataIndex = meta.fields[i].name;
					meta.fields[i].renderer = eval(meta.fields[i].renderer);
					columns.push(meta.fields[i]);
				}
			}
			this.reconfigure(store, new Ext.grid.ColumnModel(columns));
        }, this);
		var cm = new Ext.grid.ColumnModel([]);
		this.bbar = new Ext.PagingToolbar({
            pageSize: FR.system.gridItemsPerPage,
            store: this.store,
            displayInfo: true,
			beforePageText: FR.T('Page'),
			afterPageText: FR.T('of {0}'),
			firstText: FR.T('First Page'),
			lastText: FR.T('Last Page'),
			nextText: FR.T('Next Page'),
			prevText: FR.T('Previous Page'),
			refreshText: FR.T('Refresh'),
            displayMsg: FR.T('Displaying records {0} - {1} of {2}'),
            emptyMsg: FR.T('No records to display')
        });
        Ext.apply(this, {
			ds: this.store,
			cm: cm,
			loadMask: true,
			enableHdMenu: false, enableColumnMove: false,
			selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
			bbar: this.bbar,
			listeners: {
				'containercontextmenu': function(grid, e) {
					e.stopEvent();
					return false;
				}
			}
		});
		FR.components.Grid.superclass.initComponent.apply(this, arguments);
		this.selModel.on('selectionchange', function(selModel) {
			this.currentCount = selModel.getCount();
			this.currentSelection = selModel.getSelected();
		}, this);
		this.on('rowdblclick', function (grid, rowIndex, e){
			if (FR.grid.currentModule.view) {
				FR.grid.actions.view.execute();
			} else {
				if (FR.grid.currentModule.dblClickEdit) {
					FR.grid.actions.edit.execute();
				}
			}
		}, this);
		this.on('rowcontextmenu', function (grid, rowIndex, e){
			if (FR.grid.currentModule.onContextMenu) {FR.grid.currentModule.onContextMenu(FR.grid.currentModule, grid, rowIndex, e);}
			e.stopEvent();
			return false;
		});
		this.store.on('exception', function(misc) {
			FR.feedback(FR.T('An error was encountered while trying to load the data from the server.'));
		});
		this.delayedLoad = new Ext.util.DelayedTask(function(){
			this.getStore().load();
		}, this);
    },
	countSel: function() {return this.getSelectionModel().getCount();},
    onRender: function() {FR.components.Grid.superclass.onRender.apply(this, arguments);}
});

FR.initGrid = function() {
	this.grid = {
		init: function() {
			this.actions = {
				add: new Ext.Action({
					text: FR.T('Add'),
					iconCls: 'fa fa-fw fa-plus-circle',
					handler: function() {
						if (this.currentModule.url.add) {
							if (this.currentModule.addCondition) {
								var rs = this.currentModule.addCondition();
								if (!rs) {
									return false;
								}
							}
							var params = {};
							if (FR.grid.pid) {
								params.pid = FR.grid.pid;
							}
							Ext.getCmp('gridTabPanel').el.mask('Loading...');
							FR.tempPanel.load({
								url: FR.URLRoot+this.currentModule.url.add,
								params: params,
								scripts: true,
								callback: function() {
									Ext.getCmp('gridTabPanel').el.unmask();
								}
							});
						}
					}, scope: this
				}),
				view: new Ext.Action({
					text: FR.T('View'),
					iconCls: 'fa fa-fw fa-eye', hidden: true, disabled: true,
					handler: function() {
						if (this.currentModule.url.view) {
							var params = {id: FR.grid.panel.currentSelection.data.id};
							Ext.getCmp('gridTabPanel').el.mask('Loading...');
							FR.tempPanel.load({
								url: FR.URLRoot+this.currentModule.url.view,
								params: params,
								scripts: true,
								callback: function() {
									Ext.getCmp('gridTabPanel').el.unmask();
								}
							});
						} else {
							if (this.currentModule.viewAction) {
								this.currentModule.viewAction();
							}
						}
					}, scope: this
				}),
				edit: new Ext.Action({
					text: FR.T('Edit'),
					iconCls: 'fa fa-fw fa-edit',
					disabled: true,
					handler: function() {
						if (this.currentModule.url.edit) {
							var params = {id: FR.grid.panel.currentSelection.data.id};
							if (FR.grid.panel.currentSelection.data.type) {
								params.type = FR.grid.panel.currentSelection.data.type;
							}
							Ext.getCmp('gridTabPanel').el.mask('Loading...');
							FR.tempPanel.load({
								url: FR.URLRoot+this.currentModule.url.edit,
								params: params,
								scripts: true,
								callback: function() {
									Ext.getCmp('gridTabPanel').el.unmask();
								}
							});
						}
					}, scope: this
				}),
				del: new Ext.Action({
					text: FR.T('Delete'),
					iconCls: 'fa fa-fw fa-remove colorRed',
					disabled: true,
					handler: function() {
						if (this.currentModule.deleteAction) {
							this.currentModule.deleteAction(FR.grid.panel.getSelectionModel().getSelections());
						}
					}, scope: this
				}),
				search: new Ext.Action({
					text: FR.T('Search'),
					iconCls: 'fa fa-fw fa-search',
					hidden: true,
					handler: function() {
						if (this.currentModule.url.search) {
							Ext.getCmp('gridTabPanel').el.mask('Loading...');
							FR.tempPanel.load({
								url: FR.URLRoot+this.currentModule.url.search,
								params: '',
								scripts: true,
								callback: function() {
									Ext.getCmp('gridTabPanel').el.unmask();
								}
							});
						}
					}, scope: this
				}),
				archiveLogs: new Ext.Action({
					text: FR.T('Archive logs'),
					iconCls: 'fa fa-fw fa-file-archive-o',
					hidden: true,
					handler: function() {
						if (this.currentModule.archiveLogsAction) {
							this.currentModule.archiveLogsAction();
						}
					}, scope: this
				}),
				loginAs: new Ext.Action({
					text: FR.T('Login as'), disabled: true,
					iconCls: 'fa fa-fw fa-sign-in', hidden: true,
					handler: function() {
						window.parent.location.href = FR.URLRoot+'/?module=cpanel&section=tools&page=relogin&uid='+FR.grid.panel.currentSelection.data.id;
					}
				}),
				viewLog: new Ext.Action({
					text: FR.T('View activity log'), disabled: true,
					iconCls: 'fa fa-fw fa-archive', hidden: true,
					handler: function() {
						FR.tree.panel.getSelectionModel().suspendEvents();
						FR.tree.panel.selectPath('/root/users/tools/alogs');
						FR.tree.panel.getSelectionModel().resumeEvents();
						FR.grid.loadModule(FR.modules.logs, {users: 'user:'+FR.grid.panel.currentSelection.data.id});
					}
				})
			};
			
			this.gridQuickSearchField = new Ext.form.TriggerField({
				width: 150, emptyText: FR.T('Quick search'), enableKeyEvents: true,
				triggerClass: 'x-form-clear-trigger', hideTrigger: true,
				listeners: {
					'keyup': function(field) {
						var val = field.getValue();
						field.setHideTrigger((val.length == 0));
						var store = FR.grid.panel.getStore();
						store.baseParams.search = val;
						FR.grid.panel.delayedLoad.delay(1000);
					}
				},
				onTriggerClick: function() {
					this.reset();
					this.fireEvent('keyup', this);
				}
			});
			
			var tbar = [this.actions.add, this.actions.edit, this.actions.view, this.actions.search, this.actions.loginAs, this.actions.viewLog, '->', this.actions.del, this.actions.archiveLogs, this.gridQuickSearchField];
			this.panel = new FR.components.Grid({
				border: false, 
				tbar: tbar
			});
			this.panel.selModel.on('selectionchange', function(selModel) {
				FR.grid.actions.loginAs.disable();
				FR.grid.actions.viewLog.disable();
				FR.grid.actions.edit.disable();
				FR.grid.actions.view.disable();
				if (this.currentCount == 0) {
					FR.grid.actions.del.disable();
				} else if (this.currentCount == 1) {
					FR.grid.actions.edit.enable();
					FR.grid.actions.view.enable();
					FR.grid.actions.del.enable();
					FR.grid.actions.loginAs.enable();
					FR.grid.actions.viewLog.enable();
				} else if (this.currentCount > 1) {
					FR.grid.actions.del.enable();
				}
			}, this.panel);
		},
		loadModule: function(mod, params) {
			this.currentModule = mod;
			if (mod.title) {
				Ext.getCmp('gridTab').setTitle(FR.T(mod.title));
			}
			if (mod.iconCls) {
				Ext.getCmp('gridTab').setIconClass(mod.iconCls);
			} else {
				Ext.getCmp('gridTab').setIconClass('');
			}
			Ext.getCmp('gridTab').show();
			FR.grid.panel.store.proxy.setUrl(FR.URLRoot+mod.url.list, true);
			if (params) {
				FR.grid.panel.store.baseParams = Ext.apply({limit: FR.system.gridItemsPerPage}, params);
			} else {
				FR.grid.panel.store.baseParams = {limit: FR.system.gridItemsPerPage};
			}
			FR.grid.panel.store.sortInfo = false;
			FR.grid.gridQuickSearchField.reset('');
			FR.grid.panel.store.load();
			
			FR.grid.actions.add.setHidden(!mod.url.add);
			FR.grid.actions.edit.setHidden(!mod.url.edit);
			FR.grid.actions.view.setHidden((!mod.url.view && !mod.viewAction));
			FR.grid.actions.del.setHidden(!mod.deleteAction);
			FR.grid.actions.search.setHidden(!mod.url.search);
			FR.grid.actions.archiveLogs.setHidden(!mod.archiveLogsAction);
			FR.grid.actions.loginAs.setHidden(!mod.loginAs);
			FR.grid.actions.viewLog.setHidden(!mod.viewLog);

		}
	};
	this.grid.init();
};