var html = '<p>'+FR.T('License key in use: <b>%1</b>').replace('%1', licenseInfo.key)+'</p><br>';
html += '<p>'+FR.T('You are using <b>%1 user accounts</b> out of <b>%2</b>.').replace('%1', licenseInfo.users.current).replace('%2', licenseInfo.users.maximum)+'</p><br>';
if (licenseInfo.expiry) {
	html += '<p>'+FR.T('The license will expire on <b>%1</b>.').replace('%1', licenseInfo.expiry).replace('%2', licenseInfo.users.maximum)+'</p>';
}
var panel = new Ext.Panel({
	title: FR.T('Software licensing'), layout:'fit', border: false,
	bodyStyle: 'padding:15px;',
	html: html,
	tbar: [
		{
			text: FR.T('Update'),
			iconCls: 'fa fa-fw fa-refresh',
			handler: function() {
				this.ownerCt.ownerCt.bwrap.mask(FR.T('Please wait...'));
				Ext.Ajax.request({
					url: FR.URLRoot+'/?module=cpanel&section=settings&page=license&action=update',
					callback: function() {if (this.ownerCt){this.ownerCt.ownerCt.bwrap.unmask();}},
					success: function(req) {
						try {
							var rs = Ext.util.JSON.decode(req.responseText);
						} catch (er){return false;}
						if (rs.msg) {
							FR.feedback(rs.msg);
							Ext.getCmp('appTab').removeAll(true);
							FR.tempPanel.load({
								url: FR.URLRoot+'/?module=cpanel&section=settings&page=license',
								scripts: true
							});
						}
					},
					failure: function(f, a) {FR.feedback(f.responseText);},
					scope: this
				});
			}
		}
	]
});
Ext.getCmp('appTab').add(panel);
Ext.getCmp('appTab').doLayout();