FR.initTree = function () {
	var displayed = [];
	var opts = {
		emailLogs: {
			text: FR.T('Logs'),
			icon: FR.iconURL+'report.png', leaf: true,
			module: FR.modules.notif_logs
		},
		emailNotif: {
			text: FR.T('E-mail notifications'),
			iconCls: 'emailNotif', id: 'eNotif',
			module: FR.modules.notifications
		},
		emailSet: {
			text: FR.T('E-mail settings'),
			icon: FR.iconURL+'email.gif',
			appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=email'
		},
		actLogs: {
			text: FR.T('Activity logs'),
			id: 'alogs',
			leaf: true, iconCls: 'iconLogs', leaf: true,
			module: FR.modules.logs
		},
		uTools: {
			text: FR.T('Tools'), id: 'tools', expanded: false,
			icon: FR.iconURL+'wrench.gif',
			children: [
				{
					text: FR.T('Web Links'),
					icon: FR.iconURL+'link.png', leaf: true,
					module: FR.modules.weblinks
				},
				{
					text: FR.T('File space quota usage'),
					icon: FR.iconURL+'chart_bar.png', leaf: true,
					appURL: FR.URLRoot+'/?module=cpanel&section=tools&page=space_quota'
				},
				{
					text: FR.T('Traffic quota usage'),
					icon: FR.iconURL+'chart_bar.png', leaf: true,
					appURL: FR.URLRoot+'/?module=cpanel&section=tools&page=traffic_quota'
				},
				{
					text: FR.T('Import users'),
					icon: FR.iconURL+'table_row_insert.png', leaf: true,
					appURL: FR.URLRoot+'/?module=cpanel&section=tools&page=import_users'
				},
				{
					text: FR.T('Export users'), hidden: !FR.user.isSuperuser,
					icon: FR.iconURL+'export.png', leaf: true,
					appURL: FR.URLRoot+'/?module=cpanel&section=tools&page=export_users'
				}
			]
		},
		users: {
			text: FR.T('Users'), id: 'users',
			iconCls: 'iconUser',
			hidden: ((!FR.user.isAdmin && !FR.user.isIndep) || !FR.user.perms.adminUsers),
			module: FR.modules.users, expanded: true,
			children: [
				{
					text: FR.T('Groups'),
					iconCls: 'iconGroup', leaf: true,
					module: FR.modules.groups, hidden: !FR.user.perms.adminUsers
				},
				{
					text: FR.T('Roles'),
					iconCls: 'iconRole', leaf: true,
					module: FR.modules.roles, hidden: !FR.user.perms.adminRoles
				}
			]
		},
		metadata: {
			text: FR.T('Metadata'), id: 'metadata', expanded: false,
			icon: FR.iconURL+'tag_blue.gif',
			children: [
				{
					text: FR.T('Field sets'),
					leaf: true, icon: FR.iconURL+'application_form.png',
					module: FR.modules.metadata_fieldsets
				},
				{
					text: FR.T('File types'),
					leaf: true, icon: FR.iconURL+'page_white_office.png',
					module: FR.modules.metadata_filetypes
				}
			]
		},
		sUpdate: {
			text: FR.T('Software update'),
			icon: FR.iconURL+'application_put.png', leaf: true,
			appURL: FR.URLRoot+'/?module=software_update&section=cpanel'
		},
		lic: {
			text: FR.T('Software licensing'),
			icon: FR.iconURL+'script.png', leaf: true,
			appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=license'
		},
		sysConf: {
			text: FR.T('System configuration'),
			icon: FR.iconURL+'cog.png', id: 'sysconf',
			children: [
				{
					text: FR.T('Interface options'), expanded: true,
					icon: FR.iconURL+'application.gif',
					appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=interface',
					children: [{
						text: FR.T('Image preview'),
						icon: FR.iconURL+'application_view_gallery.gif', leaf: true,
						appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=file_preview'
					}]
				},
				{
					text: FR.T('User login and registration'),
					icon: FR.iconURL+'lock.png', expanded: true,
					appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=login_registration',
					children: [
						{
							text: FR.T('Password policy'),
							icon: FR.iconURL+'key.gif', leaf: true,
							appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=passwords'
						}
					]
				},
				{
					text: FR.T('File indexing and searching'),
					icon: FR.iconURL+'folder_search.png', leaf: true,
					appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=file_search'
				},
				{
					text: FR.T('OAuth2'), id: 'oauth',
					iconCls: 'iconOauth',
					appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=oauth',
					children: [
						{
							text: FR.T('Clients'), leaf: true,
							iconCls: 'iconPlugin',
							module: FR.modules.oauth2_clients
						}
					]
				},
				{
					text: FR.T('Misc options'),
					icon: FR.iconURL+'cog.png', leaf: true,
					appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=misc'
				},
				{
					text: FR.T('Third party services'), id: 'thirdparty',
					icon: FR.iconURL+'world.png',
					children: [
						{
							text: FR.T('Google'),
							leaf: true, icon: FR.iconURL+'google.png',
							appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=google'
						},
						{
							text: FR.T('Pusher.com'),
							leaf: true, icon: FR.iconURL+'application_form.png',
							appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=pusher'
						},
						{
							text: FR.T('BitTorrent Sync'),
							leaf: true, icon: FR.iconURL+'btorrent.png',
							appURL: FR.URLRoot+'/?module=cpanel&section=settings&page=btsync'
						}
					]
				}
			]
		}
	};
	if (FR.user.isIndep || FR.user.perms.adminUsers) {
		displayed.push(opts.users);
		if (FR.user.perms.adminLogs) {
			opts.uTools.children.unshift(opts.actLogs);
		}
		opts.users.children.push(opts.uTools);
	} else {
		if (FR.user.perms.adminLogs) {
			displayed.push(opts.actLogs);
		}
	}

	if (FR.user.isSuperuser) {
		opts.emailNotif.children = [opts.emailLogs];
		opts.emailSet.children = [opts.emailNotif];
		opts.emailSet.expanded = true;
		opts.sysConf.children.splice(1, 0, opts.emailSet);

		opts.sysConf.children.push(opts.metadata);
		opts.sysConf.children.push(opts.sUpdate);
		opts.sysConf.children.push(opts.lic);
		displayed.push(opts.sysConf);
	} else {
		if (FR.user.perms.adminNotif) {
			opts.emailNotif.leaf = true;
			displayed.push(opts.emailNotif);
		}
		if (FR.user.perms.adminMetadata) {
			displayed.push(opts.metadata);
		}
	}


	this.tree = {
		init: function() {
			this.panel = new Ext.tree.TreePanel({
				animate: true, autoScroll: true, containerScroll: true, border: false, rootVisible: false,
				useArrows: true,
				listeners: {
					'contextmenu': function (tree, e) {e.stopEvent();return false;}
				},
				root: {
					expanded: true,
					id: 'root',
					children: displayed
				}
			});
			this.panel.getSelectionModel().on('selectionchange', function(selectionModel, treeNode) {
				FR.tsel = treeNode.attributes;
				if (FR.tsel.module) {
					if (FR.tsel.module.type == 'grid') {
						Ext.getCmp('cardDisplayArea').getLayout().setActiveItem(0);
						FR.grid.loadModule(FR.tsel.module);
					} else {
						if (FR.tsel.module.activeItem) {
							Ext.getCmp('cardDisplayArea').getLayout().setActiveItem(FR.tsel.module.activeItem);
						}
					}
				} else {
					if (FR.tsel.appURL) {
						Ext.getCmp('cardDisplayArea').getLayout().setActiveItem(1);
						Ext.getCmp('appTab').removeAll(true);
						FR.tempPanel.load({
							url: FR.tsel.appURL,
							nocache: true,
							scripts: true
						});
					}
				}
			});
			this.panel.getSelectionModel().on('beforeselect', function(selectionModel, treeNode) {
				if (['sysconf', 'tools', 'metadata', 'thirdparty', 'oauth', 'eNotif'].indexOf(treeNode.attributes.id) != -1 ) {
					treeNode.expand();
					if (treeNode.attributes.id == 'oauth' || treeNode.attributes.id == 'eNotif') {return true;}
					return false;
				}
			});
			this.panel.getRootNode().on('load', function (node) {
				window.setTimeout(function () {
					if (FR.user.perms.adminUsers) {
						FR.tree.panel.getNodeById('users').select();
					}
				}, 200);
			});
		}
	};
	this.tree.init();
}