FR.components.activityPanel = Ext.extend(Ext.Panel, {
	initComponent: function() {
		this.store = new Ext.data.JsonStore({
			url: '?module=filelog&section=ajax&page=all',
			root: 'records',
			totalProperty: 'totalCount',
			fields: [
				'id',{name:'date_added', type:'date'},'time_ago','uid','username','fullName','path','fileName', 'fullFileName','icon','hasThumb','action','details','n'
			],
			listeners: {
				'load': function() {FR.UI.actions.alerts.updateStatus(0);}
			}
		});
		this.listView = new Ext.list.ListView({
			store: this.store, loadingText: '<i class="fa fa-refresh fa-spin"></i> '+FR.T('Loading...'),
			hideHeaders: true, singleSelect: true, style:'padding:0px;background-color:white',
			emptyText: '<div style="padding:10px;font-size:13px;color:gray;">'+FR.T('No activity records found for this folder')+'</div>',
			columns: [{
				tpl: new Ext.XTemplate('<div class="eventItem">' +
					'<div class="ico">' +
					'<img src="{[this.getIconURL(values)]}" width="50" height="50" border="0" />' +
					'</div>' +
					'<div class="txt">' +
					'<tpl if="n &gt; 0"><img class="new" src="images/fileman/interface/icons/new.png" width="16" height="16" alt="" /></tpl>' +
					'<div class="fn" title="{fileName}">{fileName}</div>' +
					'<div class="d">{details}</div>' +
					'<div><span class="t" title="{date_added}">{time_ago}</span></div>' +
					'</div>' +
					'</div>', {
					getIconURL: function(values) {
						if (values.hasThumb) {
							return FR.UI.getThumbURL({path: values.path+'/'+values.fullFileName, extra: 'width=50&height=50&exactSize=1'});
						} else {
							return 'images/fico/'+values.icon;
						}
					}})
			}],
			listeners: {
				'selectionchange': function(list, sel) {
					if (!sel[0]) {return false;}
					var r = list.getRecord(sel[0]);
					FR.UI.infoPanel.tabPanel.setActiveTab(0);
					if (FR.currentPath == r.data.path) {
						FR.UI.gridPanel.highlight(r.data.fullFileName);
					} else {
						FR.UI.tree.panel.selectPath(r.data.path, 'pathname', function() {
							FR.UI.gridPanel.highlightOnDisplay = r.data.fullFileName;
						});
					}
				}, scope: this
			}
		});
		this.pagingbar = new Ext.PagingToolbar({
			store: this.store,
			pageSize: 20,
			beforePageText: FR.T('Page'),
			afterPageText: FR.T('of {0}'),
			firstText: FR.T('First Page'),
			lastText: FR.T('Last Page'),
			nextText: FR.T('Next Page'),
			prevText: FR.T('Previous Page'),
			refreshText: FR.T('Refresh')
		});
		Ext.apply(this, {
			title: FR.T('Folder Activity'),
			bodyStyle: 'background-color:whitesmoke',
			layout: 'fit',
			items: this.listView,
			bbar: this.pagingbar
		});
		FR.components.activityPanel.superclass.initComponent.apply(this, arguments);
	},
	load: function() {
		this.path = FR.currentPath;
		this.store.setBaseParam('path', this.path);
		this.store.load();
	},
	onRender: function() {
		this.on('activate', function() {this.load();}, this);
		FR.components.activityPanel.superclass.onRender.apply(this, arguments);
	}
});


FR.components.infoBtn = Ext.extend(Ext.Button, {
	initComponent: function() {
		this.count = false;
		Ext.apply(this, {
			handler: function() {
				this.hide();
				FR.UI.gridPanel.selModel.clearSelections();
				FR.UI.infoPanel.expand();
				FR.UI.activityPanel.show();
			}
		});
		FR.components.infoBtn.superclass.initComponent.apply(this, arguments);
	},
	updateStatus: function(newEventsCount, add) {
		if (add) {newEventsCount = this.count + newEventsCount;}
		if (newEventsCount > 0) {
			this.show();
			this.setText(newEventsCount < 100 ? newEventsCount : '99+');
			FR.UI.activityPanel.setTitle('<span style="color:crimson;">'+FR.T('Folder Activity')+'</span>');
			if (FR.localSettings.get('sound-notif', Settings.sound_notification ? 'enabled' : 'disabled') == 'enabled') {
				if (add || newEventsCount > this.count && this.count !== false) {
					FR.sounds.notification.play();
				}
			}
		} else {
			FR.UI.activityPanel.setTitle(FR.T('Folder Activity'));
			this.hide();
		}
		this.count = newEventsCount;
	},
	onRender: function() {
		FR.components.infoBtn.superclass.onRender.apply(this, arguments);
	}
});