FR.components.commentsPanel = Ext.extend(Ext.Panel, {
	path: false,
	initComponent: function() {
		this.store = new Ext.data.Store({
			proxy: new Ext.data.HttpProxy({
				url: URLRoot+'/?module=comments&section=ajax&page=index&action=load'
			}),
			reader: new Ext.data.JsonReader({
				root: 'comments', totalProperty: 'totalCount', id: 'id',
				fields: ['id', 'date_added', 'timer', 'uid', 'val', 'username', 'fullName']
			})
		});
		this.store.on('beforeload', function(store, records, opts) {
			this.grid.getEl().update('<div class="commentsEmpty">'+FR.T('Loading...')+'</div>');
		}, this);
		this.store.on('exception', function(misc) {
			this.grid.getEl().update('<div class="commentsEmpty">'+FR.T('Failed to load comments data')+'</div>');
		}, this);
		this.store.on('load', function(store, records, opts) {
			if (store.reader.jsonData.msg) {
				if (store.reader.jsonData.totalCount > 0) {
					FR.UI.feedback(rs.msg);
					FR.UI.feedback(store.reader.jsonData.msg);
				} else {
					this.grid.getEl().update('<div class="commentsEmpty">'+store.reader.jsonData.msg+'</div>');
				}
			}
		}, this);
		this.btns = {
			addComment: new Ext.Button({
				style: 'border-color:#C1C1C1;border-bottom-left-radius: 0px;border-top-left-radius: 0px;margin:0px;border-left:none;color: silver;font-size: 20px;',
				iconCls: 'fa fa-comment-o',
				handler: this.addComment, scope: this
			})
		};
		var tpl = new Ext.XTemplate(
			'<div class="comments">',
				'<tpl for=".">',
					'<div class="comment">',
						'<div class="author">{fullName}</div>',
					User.perms.write_comments ?
						'<div class="removeBtn"><a onclick="FR.UI.deleteComment(\''+this.id+'\', \'{id}\')"><i class="fa fa-close"></i></a></div>':'',
						'<div class="text">' +
							'{val}' +
							'<div class="date"><abbr title="{date_added:date("l, F jS, Y \\\\a\\\\t h:i A")}">{timer}</abbr></div>',
						'</div>',
					'</div>',
				'</tpl>',
			'</div>',
			'<div class="x-clear"></div>'
		);
		this.grid = new Ext.DataView({
			region: 'center',  autoScroll: true,
			flex:1, border: false, tpl: tpl,
			store: this.store,
			emptyText: ''
		});
		this.inputBox = new Ext.form.TextArea({
			flex: 1, style: "border-right:none;",
			emptyText: FR.T('Write a comment...'), enableKeyEvents: true,
			listeners: {
				keydown: function(field) {
					if (field.el.dom.scrollHeight > 40) {
						this.writePanel.setHeight(80);
						this.doLayout();
					}
				}, scope: this
			}
		});
		this.writePanel = new Ext.Panel({
			region: 'south',
			layout: 'hbox', border: false,
			height: 40, layoutConfig: { align: "stretch" },  margins: "5 5 5 5",
			items: [
				this.inputBox,
				this.btns.addComment
			]
		});
		Ext.apply(this, {
			layout: 'border', bodyStyle: 'background-color:#FAFAFA',
			items: [
				this.grid,
				this.writePanel
			],
			listeners: {
				'activate': function(p) {
					p.active = true;
					if (this.isSet()) {this.load();}
					this.writePanel.setHeight(40);
					this.doLayout();
				},
				'deactivate': function(p) {p.active = false;}
			}
		});
		FR.components.commentsPanel.superclass.initComponent.apply(this, arguments);
	},
	onRender: function() {
		FR.components.commentsPanel.superclass.onRender.apply(this, arguments);
	},
	isSet: function() {
		return this.path;
	},
	setItem: function(path) {
		if (path == this.path) {return this;} else {
			this.store.removeAll(true);
			if (this.active) {
				this.grid.refresh();
			}
			if (FR.utils.canAddComments()) {
				this.writePanel.show();
			} else {
				this.writePanel.hide();
			}
			this.doLayout(true);
		}
		this.path = path;
		this.store.setBaseParam('path', path);
		if (!this.collapsed) {
			this.load();
		}
		return this;
	},
	load: function() {
		if (!this.active) {return false;}
		this.store.load();
	},
	addComment: function() {
		var c = encodeURIComponent(this.inputBox.getValue());
		if (c.length > 0) {
			this.action('add', {comment: c});
		}
	},
	deleteComment: function(cid) {
		new Ext.ux.prompt({
			text: FR.T('Are you sure you want to remove the comment?'),
			confirmHandler: function() {
				this.action('remove', {commentId: encodeURIComponent(cid)});
			}, scope: this
		});
	},
	showLoading: function () {this.getEl().mask(FR.T('Loading...'));},
	hideLoading: function () {this.getEl().unmask();},
	action: function(action, params, callback) {
		this.showLoading();
		Ext.Ajax.request({
			url: URLRoot+'/?module=comments&section=ajax&page=index&action='+action,
			params: Ext.apply(this.store.baseParams, params),
			success: function(req) {
				this.hideLoading();
				try {
					var rs = Ext.util.JSON.decode(req.responseText);
				} catch (er){return false;}
				if (rs) {
					if (rs.rs) {
						if (callback) {callback.call();}
						this.inputBox.reset();
						this.load();
					}
					if (rs.msg) {
						FR.UI.feedback(rs.msg);
					}
				}
			},
			scope: this
		});
	}
});
FR.UI.deleteComment = function(panelId, cId) {Ext.getCmp(panelId).deleteComment(cId);}