FR = {
	currentSelectedFile: '', components: {},
	actions: {}, tmp: {}, ext: [], customActions: {},
	UI: {
		xy: [], popups: [], tabs: [], tree: {contextMenuSelectedNode: false},
		popImporterWindow: '', changePassWindow: '',
		uploadTabs: {java: false, html: false,flash: false}, uploadPanels: {},
		delConfirmWin: false, folderDelConfirmWin: false, grid: {arrayActions:[]}
	},
	localSettings: {
		get: function(s, def) {
			var v = Ext.state.Manager.getProvider().get('fr-settings-'+s);
			return def ? (v ? v : def) : v;
		},
		set: function(s, v) {
			Ext.state.Manager.getProvider().set('fr-settings-'+s, v);
		}
	},
	labels: new Ext.util.MixedCollection()
};
Ext.onReady(function() {
	FR.baseURL = URLRoot;
	FR.iconsURL = URLRoot+'/images/fileman/interface/icons';
	FR.myfilesBaseURL = URLRoot+'/?module=fileman_myfiles&section=ajax';
	if (Settings.logoutURL) {
		FR.logoutURL = Settings.logoutURL;
	} else {
		FR.logoutURL = URLRoot + '/?module=fileman&page=logout';
		if (Settings.logout_redirect) {
			FR.logoutURL += '&redirect=' + encodeURIComponent(Settings.logout_redirect);
		}
	}
	Ext.QuickTips.init();

	FR.sounds = {
		notification: {
			obj: Ext.DomHelper.append(Ext.getBody(), {tag: 'audio', src: Ext.isGecko?'sounds/new.ogg':'sounds/new.mp3', preload: 'auto'}),
			play: function() {if (this.obj.canPlayType) {this.obj.play();}}
		}
	};

	FR.initToolbar();
	FR.initTree();
	FR.UI.tree.initContextMenu();
	FR.initTreeDD();
	FR.initLayout();

	if (User.perms.file_history && Settings.enablePusher) {
		Pusher.log = function(message) {console.log(message);}
		var pusher = new Pusher(Settings.pusherAppKey, {authEndpoint: '?module=fileman&section=utils&page=pusher_auth', encrypted: true});
		var channel = pusher.subscribe('private-'+User.id);
		channel.bind('notifications', function(data) {
			if (data.action == 'comment_added') {if (!User.perms.read_comments) {return false;}}
			if (data.msg) {FR.UI.feedback(data.msg);}
			FR.UI.actions.alerts.updateStatus(1, true);
		});
	}

	if (FR.startFolder) {
		FR.UI.tree.panel.selectPath('/ROOT/HOME/'+FR.startFolder, 'pathname');
	} else {
		FR.UI.tree.homeFolderNode.select();
		FR.UI.tree.homeFolderNode.expand();
	}

	if (User.requiredToChangePass) {
		FR.UI.feedback(FR.T('You are required to change your password.'));
		FR.actions.openAccountSettings();
	}
	Ext.getDoc().on('paste', FR.actions.pasteImage);
});