FR.initLayout = function() {
	Ext.getBody().on('mousemove', function(e){FR.UI.xy = e.getXY();});
	Ext.getBody().on('contextmenu', function(e) {e.stopEvent();});

	var bodyWidth = Ext.getBody().getSize().width;
	var p = 22/100*bodyWidth;
	var treePanelWidth = 170;
	if (p > 170) {treePanelWidth = p;}
	if (p > 250) {treePanelWidth = 250;}
	treePanelWidth = Math.round(treePanelWidth);

	FR.UI.gridPanel = new FR.components.gridPanel({
		id: 'FR-Grid-Panel',
		listeners: {
			'render': function(grid) {
				if (User.perms.upload) {
					FlowUtils.attachDrop({
						domNode: this.el.dom,
						onDragOver: function(e) {
							this.view.mainBody.addClass('dragover');
						},
						onDragLeave: function() {
							this.view.mainBody.removeClass('dragover');
						},
						onDrop: function (e) {
							this.view.mainBody.removeClass('dragover');
							if (e.dataTransfer.files.length == 0) {
								FR.UI.feedback(FR.T('To upload files, drag them from your computer'));
								return false;
							}
							if (
								(FR.currentFolderPerms && !FR.currentFolderPerms.upload) ||
								(FR.currentSection != 'myfiles' && FR.currentSection != 'sharedFolder')
							) {return false;}

							var up = new FR.components.uploadPanel({
								 targetPath: FR.currentPath, dropEvent: e
							});
							FR.UI.uploadWindow(FR.T('Upload to "%1"').replace('%1', FR.UI.tree.currentSelectedNode.text), up);
						},
						scope: this
					});
				}
			},
			'folderChange': function() {
				FR.UI.infoPanel.folderChange();
			}
		}
	});
	Ext.DomHelper.append(Ext.getBody(), {tag: 'div', id: 'explorer-shadow'});

	FR.UI.quotaIndicator = new Ext.Panel({
		region: 'south', height: 40, hidden: !(User.perms.space_quota_max > 0), bodyStyle: 'border-top: 1px solid #DFDFDF;text-align:center;padding:13px;font-size:11px;color:gray;',
		listeners: {'render': function(pb) {pb.mon(pb.getEl(), 'click', FR.UI.reloadStatusBar, this);}}
	});
	FR.UI.explorerPanel = new Ext.Panel({
		region: 'center', iconCls: 'icons-16-folder', layout: 'border',
		bodyStyle: 'border-top:1px solid #E1E1E1;background-color:#EEEEEE',
		items: [
			{
				region: 'west', id: 'FR-Tree-Region', hideBorders: true,
				width: treePanelWidth, border: false, layout: 'border',
				items: [
					{region: 'north', height: 70, bodyStyle: 'padding:5px;padding-top:20px;padding-left:30px;', items: FR.UI.actions.newItem},
					FR.UI.tree.panel,
					FR.UI.quotaIndicator
				], split: true
			},
			FR.UI.gridPanel,
			{region: 'north', height:0, unstyled: true, html:'',
				listeners: {
					'resize': function(p, x, y) {
						if (x > 0) {Ext.get('explorer-shadow').setWidth(x+20);}
					}
				}
			}
		]
	});
	FR.UI.detailsPanel = new FR.components.detailsPanel({title: FR.T('Details')});
	FR.UI.activityPanel = new FR.components.activityPanel({
		path: '/ROOT/HOME',
		style:'padding:0px;',
		hidden: !User.perms.file_history
	});
	FR.UI.commentsPanel = new FR.components.commentsPanel({
		title: FR.T('Comments'),
		hidden: !User.perms.read_comments,
		listeners: {
			'render': function() {
				this.store.on('load', function(store, records, opts) {
					if (store.reader.jsonData.totalCount !== undefined) {
						if (store.reader.jsonData.totalCount != FR.UI.infoPanel.item.data.comments) {
							FR.UI.infoPanel.item.data.comments = store.reader.jsonData.totalCount;
							//FR.UI.gridPanel.getView().refreshRow(FR.UI.infoPanel.item);
						}
					}
				});
			},
			'show': function() {
				FR.UI.infoPanel.expand();
				FR.UI.infoPanel.tabPanel.setActiveTab(2);
			}
		}
	});

	var infoPanelState = FR.localSettings.get('infoPanelState', bodyWidth < 1024 ? 'collapsed' : 'expanded');
	FR.UI.infoPanel = new FR.components.infoPanel({
		region: 'east', width: 350, layout: 'fit', border: false, collapsed: (infoPanelState == 'collapsed'),
		floatable: false, animCollapse: false, collapseMode: 'mini',
		style: 'border-top: 1px solid #E1E1E1;',
		items: new Ext.TabPanel({
			ref: 'tabPanel', tabPosition: 'bottom',
			enableTabScroll: true, activeTab: 0, hideBorders: true, border: false,
			items: [
				FR.UI.detailsPanel,
				FR.UI.activityPanel,
				FR.UI.commentsPanel
			]
		})
	});
	FR.UI.mainPanel = new Ext.Panel({
		region: 'center', layout: 'border', hideBorders: true,
		items: [
			FR.UI.explorerPanel,
			FR.UI.infoPanel
		]
	});
	FR.UI.cardPanel = new Ext.Panel({
		layout: 'card', border: false, hideBorders: true,
		tbar: FR.UI.headerTBar, activeItem: 0,
		items: [FR.UI.mainPanel]
	});
	FR.UI.window = new Ext.Viewport({
		layout: 'fit',
		items: FR.UI.cardPanel
	});

	if (User.perms.space_quota_max) {FR.UI.updateQuotaStatus();}
};
