if (!FR.UI.uploadDialog) {
	if (Settings.ui_default_upload_mode == 'dnd'){var activeTabStrip = 1;
	} else if (Settings.ui_default_upload_mode == 'flash') {var activeTabStrip = 0;
	} else {var activeTabStrip = 2;}

	FR.UI.uploadDialog = new Ext.Window({
		title: FR.T('Upload'),
		width: 400, height: 356, constrainHeader: true,
		resizable: false, collapsible: false, closeAction: 'hide',
		tools: [{
			id: 'minimize', qtip: FR.T('Minimize'),
			handler: function(event, toolEl, win){
				win.minimized = true;
				win.getTool('restore').show();
				win.getTool('minimize').hide();
				win.setSize(180, 5).collapse(false).anchorTo(FR.UI.window.el, 'bl-bl', [10,-40]);
			}
		},
			{
				id: 'restore', qtip: FR.T('Restore'), hidden: true,
				handler: function(event, toolEl, win){
					win.minimized = false;
					win.getTool('minimize').show();
					win.getTool('restore').hide();
					win.setSize(400, 356).clearAnchor().expand(false).center();
				}
			}
		],
		listeners: {
			'show': function() {
				if (Ext.getCmp('uploadDialogTP').getActiveTab().id == 'fr-java-upload-tab') {
					FR.UI.loadDNDApplet();
				}
				try {
					FR.UI.uploadDialogSWFiframe.contentWindow.Ext.getCmp('PluploadPanel').onDeleteAll();
				} catch(er) {}
			}
		},
		items: new Ext.TabPanel({
			id: 'uploadDialogTP',
			height: 324, border: false,
			activeTab: activeTabStrip,
			deferredRender: false,
			tabPosition: 'top',
			listeners: {
				tabchange: function(tp, tab) {
					if (Ext.isSafari && Ext.isWindows) {
						//safari for windows doesn't hide the applet on tab change
						if (tab.id != 'fr-java-upload-tab') {
							if (FR.UI.uploadTabs.java) {
								try {
									FR.UI.uploadDialogDNDiframe.contentWindow.destroyApplet();
								} catch (er) {}
							}
						}
					}
				}
			},
			items: [
				{
					title: FR.T('Regular'), html: '', id: 'fr-regular-upload-tab',
					listeners: {
						activate: function() {
							if (!FR.UI.uploadTabs.flash) {
								this.el.mask(FR.T('Loading...'));
								FR.UI.uploadDialogSWFiframe = Ext.DomHelper.insertFirst(this.body, {tag: 'iframe', frameBorder: 0,  src: URLRoot+'/?module=fileman_myfiles&section=ajax&page=upload_regular', style: 'width:100%;height:298px;position:relative'});
								FR.UI.uploadTabs.flash = true;
							}
						}
					}
				},
				{
					title: FR.T('Java'), html: '', id: 'fr-java-upload-tab',
					listeners: {activate: FR.UI.loadDNDApplet}
				},
				{
					title: FR.T('Import e-mail attachments'), html: '', id: 'fr-pop-import-tab',
					listeners: {
						activate: function() {
							if (!FR.UI.uploadTabs.popImporter) {
								this.el.mask(FR.T('Loading...'));
								FR.UI.uploadDialogPopIframe = Ext.DomHelper.insertFirst(this.body, {tag: 'iframe', frameBorder: 0, src: FR.baseURL+'/?module=pop_importer&page=index&path='+encodeURIComponent(FR.currentPath), style: 'width:100%;height:298px;position:relative'});
								FR.UI.uploadTabs.popImporter = true;
							}
						}
					}
				}
			]
		})
	});
}


FR.UI.uploadDialog.show();
if (FR.UI.uploadDialog.minimized) {
	FR.UI.uploadDialog.getTool('minimize').show();
	FR.UI.uploadDialog.getTool('restore').hide();
	FR.UI.uploadDialog.setSize(400, 356).clearAnchor().expand(false);
}
FR.UI.uploadDialog.center();
if (!Settings.ui_enable_flash_upload) {Ext.getCmp('uploadDialogTP').hideTabStripItem(0);}
if (!Settings.ui_enable_dnd_upload) {Ext.getCmp('uploadDialogTP').hideTabStripItem(1);}
if (!Settings.ui_enable_pop_importer) {Ext.getCmp('uploadDialogTP').hideTabStripItem(2);}

FR.UI.loadDNDApplet = function() {
	if (!FR.UI.uploadTabs.java) {
		var tab = Ext.getCmp('fr-java-upload-tab');
		tab.el.mask(FR.T('Loading...'));
		tab.update('');
		FR.UI.uploadDialogDNDiframe = Ext.DomHelper.insertFirst(tab.body, {tag: 'iframe', frameBorder: 0, src: URLRoot+'/?module=fileman_myfiles&section=ajax&page=upload_java', style: 'width:100%;height:298px;position:relative'});
		FR.UI.uploadTabs.java = true;
	} else {
		try {
			FR.UI.uploadDialogDNDiframe.contentWindow.insertApplet();
		} catch (er) {}
	}
}