Ext.onReady(function() {
	new Ext.Viewport({
		layout: 'fit',
			items: {
				id: 'PluploadPanel',
				xtype: 'pluploadpanel',
				border: false,
				addButtonCls: 'silk-add',
				uploadButtonCls: 'silk-arrow-up',
				cancelButtonCls: 'silk-stop',
				deleteButtonCls: 'silk-cross',

				addButtonText: FR.T('Select Files'),
				uploadButtonText: FR.T('Upload'),
				cancelButtonText: FR.T('Cancel Upload'),
				deleteButtonText: FR.T('Remove'),
				deleteSelectedText: '<b>'+FR.T('Remove selected')+'</b>',
				deleteUploadedText: FR.T('Remove uploaded'),
				deleteAllText: FR.T('Remove all'),

				statusQueuedText: FR.T('Queued'),
				statusUploadingText: FR.T('Uploading ({0}%)'),
				statusFailedText: '<span style="color: red">'+FR.T('Failed')+'</span>',
				statusDoneText: '<span style="color: green">'+FR.T('Done')+'</span>',

				statusInvalidSizeText: FR.T('Too big'),
				statusInvalidExtensionText: FR.T('Invalid file type'),

				emptyText: '<div class="plupload_emptytext"><table cellpadding="0" cellspacing="0" border="0" style="width:100%;height:270px;"><tr align="center"><td align="center"><span style="font-size:15px;color:#a1a1a1;">'+FR.T('Click "Select Files"')+'</span></td></tr></table></div>',
				emptyDropText: '<div class="plupload_emptytext"><table cellpadding="0" cellspacing="0" border="0" style="width:100%;height:270px;"><tr align="center"><td align="center"><span style="font-size:15px;color:#a1a1a1;">'+FR.T('Drag files from your computer here<br>or click "%1"').replace('%1', FR.T('Select Files'))+'</span></td></tr></table></div>',

				progressText: FR.T('{2} of {1} uploaded ({5}/s)'),

				listeners: {
					postinit: function(p) {
						if (!p.uploader.features.chunks) {
							var s = Ext.util.Format.fileSize(p.uploader.settings.chunk_size);
							new Ext.ux.prompt({title: FR.T('Info'), text: FR.T('Your browser has limited capabilities.<br>Using this upload method, you can<br>upload only files that are smaller than '+s+'.<br>The upload progress information might also not be<br>available, so please wait until the upload window<br>closes by itself at the end of the transfer.')});
						}
					},
					beforestart: function(p) {
						p.uploader.settings.url = postURL+'&runtime='+p.runtime;
						p.uploader.settings.multipart_params = {path: window.parent.FR.currentPath};
					},
					uploadstarted: function(p) {
					},
					uploadcomplete: function(p, success, failures) {
						if (success.length && !failures.length) {
							with (window.parent) {
								FR.UI.uploadDialog.hide();
								FR.utils.reloadGrid();
								FR.UI.reloadStatusBar();
							}
						}
					},
					chunkuploaded: function(p, up, file, info) {
						try {
							var rs = Ext.util.JSON.decode(info.response);
						} catch (er){
							up.stop();
							Ext.MessageBox.show({
								icon: Ext.MessageBox.WARNING,
								title: Ext.util.Format.htmlEncode(file.name),
								closable: false, width: 300,
								msg: info.response,
								buttons: Ext.MessageBox.OK
							});
							return false;
						}
						if (!rs.success) {
							up.stop();
							Ext.MessageBox.show({
								icon: Ext.MessageBox.WARNING,
								title: Ext.util.Format.htmlEncode(file.name),
								closable: false, width: 300,
								msg: rs.msg,
								buttons: Ext.MessageBox.OK
							});
						}
						if (rs.debug) {
							console.log(rs.debug);
						}
					},
					fileuploaded: function(p, up, file, rs, status) {
						if (!rs.success) {
							up.stop();
							if (rs.msg) {
								Ext.MessageBox.show({
									icon: Ext.MessageBox.WARNING,
									title: Ext.util.Format.htmlEncode(file.name),
									closable: false, width: 300,
									msg: rs.msg,
									buttons: Ext.MessageBox.OK
								});
							}
						}
					},
					progress: function(p, percent){
						var title = FR.T('Upload');
						if (percent > 0) {
							title +=  ' ('+Math.round((percent*100))+'%)';
						}
						window.parent.FR.UI.uploadDialog.setTitle(title);
					},
					error: function(up, data) {
						var msg = FR.T('Error while uploading: %1 %2 %3').replace('%1', data.code).replace('%2', data.details).replace('%3', data.message);
						window.parent.FR.UI.feedback(msg);
					}
				},
				runtimes: 'silverlight,flash,html4',
				required_features: (Ext.isSafari ? 'chunks' : false),
				multipart: true,
				urlstream_upload: true,
				url: postURL,
				flash_swf_url: 'js/plupload/Moxie.swf',
				silverlight_xap_url: 'js/plupload/Moxie.xap',
				chunk_size: chunkSize,
				max_file_size: '39000m'
			}
	});
	with (window.parent) {FR.UI.uploadDialog.pluploadcard.el.unmask();}
});