Ext.onReady(function() {
	Ext.getBody().on('contextmenu', function(e) {e.stopEvent();});
	var colModel = new Ext.grid.ColumnModel([
		{id:'version', header: FR.T("Version"), width: 25, dataIndex: 'version'},
		{id:'date', header: FR.T("Date"), renderer: Ext.util.Format.dateRenderer(FR.T('Date Format: Grid - Date')), width:100, dataIndex: 'date'},
		{header: FR.T("Size"), width: 70, dataIndex: 'size'},
		{header: FR.T("Modified by"), width:105, dataIndex: 'user'}
	]);
	var grid = new Ext.grid.GridPanel({
	    ds: new Ext.data.Store({
		    proxy: new Ext.data.MemoryProxy(gridData),
		    reader: new Ext.data.ArrayReader({}, [
			    {name: 'version'},
			    {name: 'date', type: 'date', dateFormat: 'timestamp'},
			    {name: 'size'},
			    {name: 'user'}
		    ])
	    }),
	    cm: colModel,
		enableHdMenu: false,
		border: false,
	 	selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
		autoExpandColumn: 'date'
	});

	grid.on('rowcontextmenu', function(grid, rowIndex, e) {versioningOnContextMenu(grid, rowIndex, e);});
	if (Ext.isMac) {
		grid.on('rowclick', function(grid, rowIndex, e) {versioningOnContextMenu(grid, rowIndex, e);});
	}
	gridContextMenu = new Ext.menu.Menu({
	    id: 'contextmenu',
	    items: []
	});
	if (window.parent.User.perms.download) {
		gridContextMenu.add(new Ext.menu.Item({text: FR.T('Download'), handler: function() {
			var selection = grid.getSelectionModel().getSelections();
			document.location.href = URLRoot+'/?module=fileman_myfiles&section=ajax&page=download&paths[]='+encodeURIComponent(currentPath+'/'+currentFilename)+'&version='+selection[0].data.version;
		},
			icon: URLRoot+'/images/fileman/interface/icons/disk.gif'
		}));
	}
	if (!window.parent.User.perms.read_only) {
		gridContextMenu.add(new Ext.menu.Item({text: FR.T('Restore'), handler: function() {
				var selection = grid.getSelectionModel().getSelections();
				var url = URLRoot+'/?module=versioning&section=ajax&page=actions&action=restore&version='+selection[0].data.version;
				var pars = 'path='+encodeURIComponent(currentPath)+'&filename='+encodeURIComponent(currentFilename);
				Ext.Ajax.request({
					url: url,
					method: 'post',
					params: pars,
					success: function(req){
						try {
							var rs = Ext.util.JSON.decode(req.responseText);
						} catch (er){return false;}
						if (rs.rs) {}
						new Ext.ux.prompt({text: rs.msg});
					}
				});
			},
			icon: URLRoot+'/images/fileman/interface/icons/thumb_up.gif'
		}));
		gridContextMenu.add(new Ext.menu.Item({text: FR.T('Delete'), handler: function() {
				var selection = grid.getSelectionModel().getSelections();
				var url = URLRoot+'/?module=versioning&section=ajax&page=actions&action=delete&version='+selection[0].data.version;
				var pars = 'path='+encodeURIComponent(currentPath)+'&filename='+encodeURIComponent(currentFilename);
				Ext.Ajax.request({
					url: url,
					method: 'post',
					params: pars,
					success: function(req){
						try {
							var rs = Ext.util.JSON.decode(req.responseText);
						} catch (er){return false;}
						if (rs.rs) {
							grid.getStore().remove(grid.getSelectionModel().getSelected());
						}
						new Ext.ux.prompt({text: rs.msg});
					}
				});
			},
			icon: URLRoot+'/images/fileman/interface/icons/cross.gif'
		}));
	}
	new Ext.Viewport({layout: 'fit', hideBorders: true, items: grid});
	grid.store.load();
});
versioningOnContextMenu = function(grid, rowIndex, e) {
	grid.selModel.selectRow(rowIndex);
	gridContextMenu.showAt(e.getXY());
	e.stopEvent();
	return false;
}