Ext.define('FileRun.controller.FileList', {
	extend: 'Ext.app.Controller',
	config: {
		stores: ['FileRun.store.FileList'],
		refs: {
			listView: 'filelistview',
			list: '#filelist',
			topTb: '#FileListTopTb',
			backBtn: 'button[action=back]',
			uploadBtn: 'button[action=upload]',
			newFolderBtn: 'button[action=newFolder]',
			logoutBtn: 'button[action=logout]'
		},
		control: {
			backBtn: {tap: 'goBack'},
			uploadBtn: {tap: 'showUploadForm'},
			newFolderBtn: {tap: 'newFolder'},
			logoutBtn: {tap: function(){FileRun.app.getController('app').logout();}},
			list: {
				itemtap: 'onItemTap',
				itemtaphold: 'onItemTapHold',
				initialize: function() {
					this.initialize();
				}
			}
		}
	},
	'onItemTapHold': function(list, index, target, record) {
		FR.currentItem = record;
		this.loadFilePanel();
		this.taphold = true;
		Ext.create('Ext.util.DelayedTask', function() {this.taphold=false;}, this).delay(1000);
	},
	'onItemTap': function(list, index, target, item) {
		if (this.taphold) {return false;}
		FR.currentItem = item;
		if (item.data.is_dir) {
			var path = FR.currentPath;
			if (item.data.pathname) {
				path += '/'+encodeURIComponent(item.data.pathname);
			} else {
				path += '/'+encodeURIComponent(item.data.filename);
			}
			this.chDir(path);
		} else {
			this.loadFilePanel();
		}
	},
	'loadFilePanel': function() {
		if (!this.FilePanel) {
			this.FilePanel = Ext.create('FileRun.view.FilePanel');
			Ext.Viewport.add(this.FilePanel);
		}
		Ext.Viewport.setActiveItem(this.FilePanel);
		FileRun.app.getController('FileRun.controller.FilePanel').load();
	},
	'initialize': function() {
		this.store = Ext.getStore('FileList');
		this.store.on('clear', function(store, r, s) {
			if (s) {
				var raw = store.getProxy().getReader().rawData;
				if (raw.error) {
					Ext.Msg.alert(FR.T('Error'), raw.error);
				}
				FR.parentPath = raw.data.meta.parentPath;
				FR.currentPath = raw.data.meta.path;
				FR.currentFolder = raw.data.meta.folderName;
				FR.currentFolderPerms = raw.data.meta.perms;
				this.updateTitle();
				this.getBackBtn().setHidden((FR.currentPath == '/ROOT'));
				var toggleMainBtns = (!raw.data.meta.perms || !raw.data.meta.perms.upload);
				this.getUploadBtn().setHidden(toggleMainBtns);
				this.getNewFolderBtn().setHidden(toggleMainBtns);
			}
		}, this);
		this.chDir('/ROOT');
	},
	'goBack': function() {
		if (FR.parentPath) {
			this.chDir(FR.parentPath)
		}
	},
	'itemOpenAudioList': function(opts) {
		if (!opts.path) {
			opts.path = FR.currentPath+'/'+FR.longTappedListItem.data.n;
		}
		var url = '../?module=weblinks&section=ajax&page=update&action=create';
		Ext.Ajax.request({
			url: url,
			params: {path: opts.path},
			callback: function() {FileRun.views.FileList.itemMenu.hide();},
			success: function(response, opts) {
				try {
					var rs = Ext.decode(response.responseText);
				} catch (er){return false;}
				if (rs.success) {
					document.location.href = rs.url+'&mode=playlist';
				} else {
					Ext.Msg.alert(FR.T('WebLink'), rs.msg);
				}
			}
		});
	},
	'updateTitle': function() {
		if (FR.currentPath == '/ROOT') {
			var title = Settings.title;
		} else {
			var title = FR.currentFolder;
		}
		this.getTopTb().setTitle(title);
	},
	'chDir': function(path) {
		this.store.load({
			params: {path: path}
		});
	},
	'reload': function() {this.chDir(FR.currentPath);},
	'showUploadForm': function() {
		if (!this.uploadMenu) {
			this.uploadMenu = Ext.create('FileRun.view.UploadForm');
			Ext.Viewport.add(this.uploadMenu);
		}
		this.uploadMenu.showBy(this.getUploadBtn());
	},
	'hideUploadForm': function() {
		this.uploadMenu.hide();
	},
	'newFolder': function() {
		Ext.Msg.prompt(FR.T('Type the name of the folder'), false, function(btn, text) {
			if (btn == 'ok') {
				var url = '../?module=fileman_myfiles&section=ajax&page=tree_action_rename&new_folder=1';
				var params = {
					path: FR.currentPath,
					newfilename: text
				};
				Ext.Ajax.request({
					url: url,
					params: params,
					callback: function() {Ext.Viewport.unmask();},
					success: function(response, opts) {
						try {
							var rs = Ext.decode(response.responseText);
						} catch (er){return false;}
						if (rs.rs) {
							this.reload();
						}
						Ext.Msg.alert(FR.T('New folder'), rs.msg);
					}, scope: this
				});
			}
		}, this);
	}
});