Ext.define('FileRun.view.FileList', {
	extend: 'Ext.Panel',
	alias: 'widget.filelistview',
	config: {
		layout: 'fit',
		items: [
			{
				xtype: 'titlebar',
				id: 'FileListTopTb',
				title: Settings.title,
				docked: 'top',
				items: [
					{
						text: FR.T('Back'), 
						ui: 'back', 
						action: 'back',
						hidden: true
					}
				]
			},
			{
				xtype: 'list', scrollToTopOnRefresh: true, disableSelection: true, id: 'filelist',
				itemTpl: new Ext.XTemplate(
					'{[this.getIcon(values)]} <strong>{filename}</strong>{[this.getLabel(values)]}',
					{
						getIcon: function(values) {
							if (values.is_dir) {
								return '<i class="fa fa-fw fa-folder fa-lg colorGray"></i>';
							} else {
								if (values.hasThumb) {
									var url = FileRun.app.getController('app').getThumbURL({path: FR.currentPath+'/'+values.filename, extra: 'width=50&height=50&exactSize=1'});
								} else {
									var url = '../images/fico/'+values.icon;
								}
								return '<img src="'+url+'" width="32" height="32" align="absmiddle" />';
							}
						},
						getLabel: function(v) {
							if (v.label) {
								var s = v.label.split('|');
								return '<span class="FRLabel" style="background-color:' + s[1] + '">' + s[0] + '</span>';
							}
						}
					}
				),
				variableHeights: false,
				store: 'FileList',
				plugins: [
					{
						xclass: 'Ext.ux.plugin.PullRefresh',
						pullRefreshText: FR.T('Pull down to refresh listing'),
						refreshFn: function(plugin) {
							FileRun.app.getController('FileRun.controller.FileList').reload();
							this.setState("pull");
						}
					}
				]
			},
			{
				xtype: 'toolbar', docked: 'bottom',
				items: [
					{
						text: FR.T('Upload'), action: 'upload',
						hidden: Ext.os.is.iOS, hidden: true
					},
					{
						text: FR.T('New folder'), action: 'newFolder', hidden: true
					},
					{xtype: 'spacer'},
					{
						text: FR.T('Sign out'), 
						ui: 'round', 
						action: 'logout'
					}
				]
			}
		]
	},
	initialize: function() {
		this.callParent(arguments);
	}
});
