Ext.define('FileRun.view.FilePanel', {
	extend: 'Ext.form.Panel',
	alias: 'widget.filepanel',
	config: {
		scroll: 'vertical',
		items: [
			{
				xtype: 'titlebar',
				docked: 'top',
				id: 'FilePanelTopBar',
				items: [
					{
						text: FR.T('Back'), 
						ui: 'back', 
						action: 'backToList'
					}
				]
			},
			{
				xtype: 'fieldset',
				defaultType: 'textfield',
				items: [
					{xype: 'textfield', name: 'filename', label: FR.T('Name'), clearIcon: false,
						listeners: {
							action: function () {
								this.getValue();
							}
						}
					},
					{name: 'nicerFileSize', label: FR.T('Size'), readOnly: true},
					{name: 'description', label: FR.T('Type'), readOnly: true},
					{name: 'cdate', label: '<div style="white-space:nowrap">'+FR.T('Date Created')+'</div>', readOnly: true},
					{name: 'mdate', label: '<div style="white-space:nowrap">'+FR.T('Date Modified')+'</div>', readOnly: true}
				]
			},
			{xtype: 'fieldset', title: FR.T('WebLink'), items: [
				{xtype: 'urlfield', id: 'webLinkUrl', label: '&nbsp;', value: '', readOnly: true, listeners: {'focus': function() {this.select();}}},
				{xtype: 'datepickerfield', destroyPickerOnHide: true, picker: {yearFrom: new Date().getFullYear(), yearTo: new Date().getFullYear()+4}, name: 'wlexpiry', id: 'wlexpiry', label: FR.T('Expiration date')},
				{xtype: 'textfield', id: 'wlpass', name: 'wlpass', label: FR.T('Password'), value: ''},
				{xtype: 'togglefield', id: 'wlshort', name: 'wlshort', label: FR.T('Short Link'), value: 0}
			]},
			{xtype: 'fieldset', title: FR.T('BitTorrent Sync'), hidden: true, items: [
				{xtype: 'textfield', id: 'btsyncReadWrite', name: 'btsyncReadWrite', label: FR.T('Full access secret:'), value: ''},
				{xtype: 'textfield', id: 'btsyncReadOnly', name: 'btsyncReadOnly', label: FR.T('Read-only secret:'), value: ''}
			]},
			{
				xtype: 'toolbar',
				docked: 'bottom',
				items: [
					{text: FR.T('Download'), ui: 'action', action: 'download'},
					{text: FR.T('Preview'), ui: 'action', action: 'preview'},
					{text: FR.T('More...'), action: 'more'}
				]
			}
		]
	},
	initialize: function() {
		this.callParent(arguments);
	}
});
Ext.define('FileRun.view.FilePanelMore', {
	extend: 'Ext.Container',
	config: {
		defaults: {xtype: 'button'}, modal: true, hideOnMaskTap: true, styleHtmlContent: true,
		items: [
			{text: FR.T('Open with...'), ui: 'action', action: 'openWith', style:'margin-bottom:5px;'},
			{text: FR.T('Open WebLink as...'), ui: 'action', action: 'openWebLinkAs', style:'margin-bottom:5px;'},
			{text: FR.T('Generate WebLink'), ui: 'action', action: 'weblink', style:'margin-bottom:5px;'},
			{text: FR.T('Share with BitTorrent Sync'), ui: 'action', action: 'btsync', style:'margin-bottom:5px;'},
			{text: FR.T('Delete'), ui: 'action', action: 'del', style:'margin-bottom:5px;'}
		]
	}
});
Ext.define('FileRun.view.FilePanelOpenWith', {
	extend: 'Ext.Panel',
	config: {
		defaults: {xtype: 'button'}, centered: true, modal: true, hideOnMaskTap: true,
		styleHtmlContent: true
	}
});
Ext.define('FileRun.view.FilePanelOpenWlAs', {
	extend: 'Ext.Panel',
	config: {
		defaults: {xtype: 'button'}, centered: true, modal: true, hideOnMaskTap: true,
		styleHtmlContent: true, items: [
			{text: FR.T('Image Gallery'), action: 'openWebLinkAsGallery', style:'margin-bottom:5px;'},
			{text: FR.T('Audio Playlist'), action: 'openWebLinkAsPlaylist', style:'margin-bottom:5px;'},
			{text: FR.T('RSS Feed'), action: 'openWebLinkAsRSS'}
		]
	}
});