Ext.define('FileRun.view.LoginForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.loginview',
	config: {
		id: 'loginFrm',
		layout: {
            type: 'vbox',
            pack: 'center',
            align: 'center'
        },
		hideOnMaskTap: false,
		submitOnAction: false,
		items: [
			{
				xtype: 'toolbar',
				title: Settings.title,
				docked: 'top', hidden: !Settings.title
			},
			{html:'<img src="'+Settings.ui_login_logo+'" border="0" alt="" />', hidden: !Settings.ui_login_logo.length},
			{
				xtype: 'fieldset',
				defaults: {
					autoCorrect: false, autoCapitalize: false, labelWidth: 170
				},
				items: [
					{xtype: 'hiddenfield', name: 'persistent', value: Settings.allowPersistentLogins?1:0},
					{xtype: 'hiddenfield', name: 'two_step_secret', value: ''},
					{xtype: 'textfield', name: 'username', label: FR.T('Username')},
					{xtype: 'passwordfield', name: 'password', label: FR.T('Password')},
					{xtype: 'passwordfield', name: 'otp', label: FR.T('Verification code'), hidden: true},
					{
						xtype: 'selectfield',
						name: 'language',
						label: FR.T('Language'),
						value: selectedLang, hidden: !Settings.ui_display_language_menu,
						options: Languages,
						listeners: {
							'change': function(s, val) {
								if (!this.up('formpanel').getFields().username.getValue()) {
									document.location.href = URLRoot+'/?language='+encodeURIComponent(val);
								}
							}
						}
					}
				]
			},
			{
				xtype: 'button', ui: 'action', margin: '10px',
				text: FR.T('Sign in'), action: 'login'
			}
		]
	},
	initialize: function() {
		this.callParent(arguments);
	}
});