Ext.onReady(function() {
	win = new Ext.Window({
		layout: 'fit',
		constrain: true, closable: false,
		resizable: false, draggable: false,
		title: Settings.title+' - '+FR.T('Password Reset'),
		autoHeight: true, width:350,
		bodyStyle:'padding:20px;padding-left:35px;padding-right:35px;background-color:white',
		items: [
			recoveryForm = new Ext.form.FormPanel({
		        baseCls: 'x-plain',
				labelAlign: 'right', labelWidth: 'auto',
		        defaultType: 'textfield', autoHeight: true,
		        items: [{
					id: 'usr',
		            fieldLabel: FR.T('E-mail address'),
		            name: 'email', width:160,
					labelStyle: 'white-space:nowrap'
		        },{
					xtype: 'hidden',
		            name: 'redirectOnSuccess',
					value: redirectOnSuccess
		        }]
		    })
		],
		buttons: [{
			text: FR.T('Submit'), cls: 'fr-btn-default fr-btn-primary',
			handler: submitForm
		},{
	    	text: FR.T('Cancel'), cls: 'fr-btn-default',
			handler: function() {document.location.href = URLRoot+'/?page=login';}
	    }]
	});
	function submitForm() {
		recoveryForm.getForm().submit({
			url: submitURL, 
			failure: function(frm, act) {
				var msg = act.result ? act.result.msg : FR.T('A problem was encountered while trying to submit the form: ')+act.response.responseText;
				new Ext.ux.prompt({text: msg});
			},
			success: function(frm, act) {
				new Ext.ux.prompt({text: act.result.msg, callback: function() {document.location.href = URLRoot;}});
			}
		});
	}
	win.show().anchorTo(Ext.get('theBODY'), 'c-c');
	new Ext.KeyMap("usr", {
	    key: Ext.EventObject.ENTER,
	    fn: submitForm
	});
});