Ext.define('Ext.ux.plugin.PullRefresh', {
	extend: 'Ext.plugin.PullRefresh',
	config: {
		refreshFn: null
	},
	onScrollerDragEnd: function() {
		if (this.getState() !== "loading") {
			var me = this,
				list = this.getList(),
				scroller = list.getScrollable().getScroller(),
				translateable = scroller.getTranslatable();

			this.setState("loading");
			translateable.setEasingY({duration: this.getOverpullSnapBackDuration()});
			scroller.minPosition.y = -this.getPullHeight();
			scroller.on({
				//scrollend: 'fetchLatest',
				scrollend: function() {
					if (me.getRefreshFn()) {
						me.getRefreshFn().call(me, me);
					} else {
						me.fetchLatest();
					}
				},
				single: true,
				scope: this
			});
		}
	}
});