var FR = {
	initLayout: function() {
		if (FR.apps && FR.apps.length > 0) {
			var boxes = [];
			Ext.each(FR.apps, function (item) {
				boxes.push({
					boxLabel: item.name + '<br><span class="silver" style="font-size:10px;">(' + FR.T('Granted on %1 from %2').replace('%1', item.date_created).replace('%2', item.client_ip) + ')</span>',
					name: 'revoke[]',
					inputValue: item.id
				});
			});
			var appsOpts = {
				xtype: 'checkboxgroup',
				itemCls: 'x-check-group-alt',
				columns: 1, fieldLabel: FR.T('Revoke access'),
				items: boxes
			};
		} else {
			var appsOpts = {};
		}
		this.viewport = new Ext.Viewport({
			layout: 'fit',
			items: {
				xtype: 'form', border: false, autoScroll: true, bodyStyle: 'padding:10px',
				layout: 'form', id: 'theForm',
				items: [

					{
						xtype: 'fieldset',
						title: FR.T('Basic details'),
						defaults: {width: 200}, labelWidth: 140,
						items: [
							{
								xtype: 'textfield',
								fieldLabel: FR.T('Name'),
								name: 'name', value: FR.userInfo.name
							},
							{
								xtype: 'textfield',
								fieldLabel: FR.T('E-mail address'),
								name: 'email', value: FR.userInfo.email
							},
							{
								xtype: 'checkbox',
								boxLabel: FR.T('E-mail notifications'), inputValue: 1,
								name: 'receive_notifications', checked: FR.userInfo.receive_notifications
							},
							{
								xtype: 'checkbox',
								boxLabel: FR.T('Mute sound notifications'),
								checked: (window.parent.FR.localSettings.get('sound-notif', window.parent.Settings.sound_notification ? 'enabled' : 'disabled') == 'disabled'),
								listeners: {
									'check': function(el, checked) {
										window.parent.FR.localSettings.set('sound-notif', checked ? 'disabled' : 'enabled');
									}
								}, hidden: (!window.parent.User.perms.file_history || (Ext.isIE8 || Ext.isIE7))
							}
						]
					},
					{
						xtype: 'fieldset',
						title: FR.T('Change password'),
						labelWidth: 140, hidden: !FR.system.allowUserToChangePass,
						defaults: {xtype: 'textfield', width: 200, inputType: 'password'},
						items: [
							{fieldLabel: FR.T('Current password'), name: 'current_password'},
							{fieldLabel: FR.T('New password'), name: 'new_password'},
							{fieldLabel: FR.T('Confirm new password'), name: 'confirm_new_password'},
							{
								xtype: 'displayfield', submitValue: false,
								hideLabel: true, hidden: !FR.userInfo.last_pass_change,
								style: 'color:gray;text-align:right;font-size:11px;', width: 360,
								value: FR.T('Your password has been last changed %1').replace('%1', FR.userInfo.last_pass_change)
							}
						]
					},
					{
						xtype: 'fieldset',
						title: FR.T('2-Step verification'),
						defaults: {width: 400}, hidden: !FR.system.enable2stepOption,
						items: [
							{
								xtype: 'checkbox',
								boxLabel: FR.T('Enable 2-step verification'),
								inputValue: 1, hideLabel: true,
								name: 'two_step_enabled', checked: FR.userInfo.two_step_enabled
							},
							{
								xtype: 'displayfield', hideLabel: true, style: 'color:gray', value: FR.T('Every time you login you will need to type in also a temporary code which can be generated on your mobile device with a dedicated app such as Google Authenticator.')
							}
						]
					},
					{
						xtype: 'fieldset',
						title: FR.T('Connected apps'), hidden: !FR.system.showApps,
						items: appsOpts
					}
				], buttonAlign: 'left',
				buttons: [{
					text: FR.T('Save changes'), cls: 'fr-btn-default fr-btn-primary', handler: function() {
						FR.formPanel = Ext.getCmp('theForm');
						FR.formPanel.bwrap.mask(FR.T('Saving changes...'));
						Ext.Ajax.request({
							url: FR.URLRoot+'/?module=fileman&section=profile&action=save',
							params: Ext.apply({
								'receive_notifications': 0,
								'two_step_enabled': 0
							}, FR.formPanel.form.getValues()),
							callback: function() {FR.formPanel.bwrap.unmask();},
							success: function(req) {
								try {
									var rs = Ext.util.JSON.decode(req.responseText);
								} catch (er){return false;}
								if (rs) {
									if (rs.msg) {window.parent.FR.UI.feedback(rs.msg);}
									if (rs.success) {
										window.parent.FR.UI.popups.accountSettings.close();
									}
								} else {window.parent.FR.UI.feedback(req.responseText);}
							},
							failure: function(f, a) {FR.UI.feedback(f.responseText);}
						});
					}}
				]
			}
		});
	}
};
Ext.onReady(function() {
	FR.initLayout();
});