FR = {
	initUploader: function () {
		this.status = document.getElementById('upStatus');
		document.getElementById('upBtnCtn').style.display = 'block';
		if (!UploadChunkSize) {UploadChunkSize = 2086912;}
		this.flow = new Flow({
			target: URLRoot+'/?module=weblinks&section=default&page=public_upload', progressCallbacksInterval: 100,
			startOnSubmit: true, maxChunkRetries: 3, resumeLargerThan: 10485760, maxSimultaneous: 1,
			chunkSize: UploadChunkSize,
			query: function() {
				return {
					id: WebLinkId,
					pass: WebLinkPass,
					path: UploadToPath
				};
			},
			validateGetOffsetResponse: function(file, status, message) {
				if (status == 200) {
					try {var rs = eval('(function(){return'+message+';})()');} catch (er){return false;}
					if (rs && rs.success) {
						if (rs.offset) {
							rs.offset = parseInt(rs.offset);
							if (!isNaN(rs.offset) && isFinite(rs.offset)) {
								file.offset = rs.offset;
							}
						}
						return true;
					}
				}
			}, validateGetOffsetResponseScope: this,
			validateChunkResponse: function(status, message) {
				if (status != '200') {return 'retry';}
				try {var rs = eval('(function(){return'+message+';})()');} catch (er){return 'retry';}
				if (rs) {if (rs.success) {return 'success';} else {return 'error';}}
			}, validateChunkResponseScope: this
		});
		this.flow.on('filesSubmitted', function() {
			FR.status.style.display = 'block';
			FR.status.innerHTML = 'Upload starting...';
		});
		this.flow.on('progress', function(flow) {
			var percent = Math.floor(flow.getProgress()*100);
			FR.status.innerHTML = 'Uploading...'+percent+'%';
		});
		this.flow.on('fileSuccess', function(file, message) {
			try {var rs =  eval('(function(){return'+message+';})()');} catch (er) {
				FR.status.innerHTML = 'Unexpected server reply: ' + message;
			}
		});
		this.flow.on('fileError', function(file, message) {
			try {var rs = eval('(function(){return'+message+';})()');} catch (er){
				FR.status.innerHTML = 'Unexpected server reply: '+message;
			}
			if (rs && rs.msg) {FR.status.innerHTML = rs.msg;}
		});
		this.flow.on('complete', function() {
			FR.status.innerHTML = 'Refreshing page...';
			document.location.reload();
		});
		FlowUtils.attachDrop({
			domNode: document.body,
			onDrop: this.flow.onDrop, scope: this
		});
	},
	startUpload: function() {
		this.flow.removeAll();
		this.flow.browseFiles();
	}
};

function collage() {
	$('#filelist').collagePlus({
		'targetHeight': 200,
		'allowPartialLastRow': true
	});
}
function initGallery() {
	$(document).ready(function() {
		new imagesLoaded($('#filelist'), collage);
		var resizeTimer = null;
		$(window).bind('resize', function() {
			$('#filelist .Image_Wrapper').css("opacity", 0);
			if (resizeTimer) clearTimeout(resizeTimer);
			resizeTimer = setTimeout(collage, 200);
		});
		$('a.fancybox').fancybox({
			afterLoad: function() {
				this.title = '<a href="' + this.element.context.getAttribute('orig-src') + '" target="_blank" class="titleLink">'+this.title+'</a>';
			},
			openEffect: 'elastic', closeEffect: 'elastic',
			minWidth: 20, minHeight: 20, padding: 0, closeBtn: false,
			preload: 0, 'type': 'image',
			helpers:  {
				buttons: {},
				thumbs : {width: 70, height: 70}
			}
		});
	});
}