<?php
class ArchTar extends AbstractArch {
	function __construct($filePath, $fileName = false, $ext = false) {
		parent::__construct($filePath, $fileName, $ext);
		global $config;
		require_once($config['path']['classes']."/arch/libs/tar.lib.php");
		$this->tar = new Tar();
	}
	function open() {
		try {
			$this->tar->open($this->path);
		} catch (Exception $e) {
			$this->error = $e->getMessage();
			$rs = false;
		}
		return true;
	}
	function close() {
		$this->tar->close();
		return true;
	}
	function getTOC($limit = false) {
		global $fm;
		$rs = $this->tar->contents();
		$list = array();
		$count = 0;
		if (is_array($rs)) {
			$this->itemsCount = sizeof($rs);
			foreach ($rs as $k => $v) {
				$count++;
				$list[] = array(
					"checksum" => $v['checksum'],
					"filename" => $fm->basename($v['filename']),
					"path" => $fm->dirname($v['filename']),
					"filesize" => $v['size'],
					"type" => ($v['size'] == 0 && substr($v['filename'], -1) == "/") ? "folder" : "file"
				);
				if ($count >= $limit) {
					break;
				}
			}
		}
		return $list;
	}
	function extract($targetPath) {
		if (!is_dir($targetPath)) {
			$rs = mkdir($targetPath);
			if (!$rs) {
				$this->error = "Failed to create folder ".$targetPath;
				return false;
			}
		}
		try {
			$rs = $this->tar->extract($targetPath);
		} catch (Exception $e) {
			$this->error = $e->getMessage();
			$rs = false;
		}
		return $rs;
	}
}