<?php
/**
 * Sample configuration for Linux servers:
		$config['app']['zip']['external'] = array(
			'extract' => '/usr/bin/unzip %archiveName% -d %targetFolder%',
			'compress' => array(
				'folder' => '/usr/bin/zip -r %archiveName% %sourceItemRel%',
				'file' => '/usr/bin/zip %archiveName% %sourceItemRel%'
			)
		);
 */
class ArchZipExternal extends ArchZip {
	function __construct($filePath, $fileName = false, $ext = false) {
		parent::__construct($filePath, $fileName, $ext);
	}
	function open() {return true;}
	function close() {return true;}
	/*
	function getTOC($limit = false) {
		global $config, $fm;
		$cmd = $config['app']['zip']['external']['list'];
		$cmd = str_replace("%archiveName%", escapeshellarg($this->path), $cmd);
		session_write_close();
		$rs = $this->runCmd($cmd);
		if ($rs) {
			$list = array();
			foreach ($this->output as $line) {
				if ($line == "------------------- ----- ------------ ------------  ------------------------") {
					if ($started) {break;}
					$started = true;
				} else {
					$size = trim(substr($line, 25, 14));
					$fileName = trim(substr($line, 39, strlen($line)));
					if ($started) {
						$list[] = array(
							"checksum" => false,
							"utf8_encoded" => true,
							"filename" => $fm->basename($fileName),
							"path" => $fm->dirname($fileName),
							"filesize" => $size,
							"type" => ($size == 0 && substr($v['filename'], -1) == "/") ? "folder" : "file"
						);
					}
				}
			}
			return $list;
		}
	}
	*/
	function add($srcPath, $removePath = false) {
		global $config;
		if (!$config['app']['zip']['external']['compress']) {
			return parent::add($srcPath, $removePath);
		}
		if (is_dir($srcPath)) {
			$cmd = $config['app']['zip']['external']['compress']['folder'];
		} else {
			$cmd = $config['app']['zip']['external']['compress']['file'];
		}
		if ($removePath) {
			chdir($removePath);
			$srcRelPath = ltrim(substr($srcPath, strlen($removePath)), '/');
			$cmd = str_replace("%sourceItemRel%", escapeshellarg($srcRelPath), $cmd);
		}
		$cmd = str_replace("%sourceItem%", escapeshellarg($srcPath), $cmd);
		$cmd = str_replace("%archiveName%", escapeshellarg($this->path), $cmd);
		session_write_close();
		$rs = $this->runCmd($cmd);
		if (!$rs) {
			$this->error = "Failed to execute external command!";
		}
		return true;
	}
	function extract($targetPath) {
		global $config, $fm;
		$cmd = $config['app']['zip']['external']['extract'];
		chdir($fm->dirname($this->path));
		$targetPath = $fm->basename($targetPath);
		$cmd = str_replace("%archiveName%", escapeshellarg($this->path), $cmd);
		$cmd = str_replace("%targetFolder%", escapeshellarg($targetPath), $cmd);
		session_write_close();
		$rs = $this->runCmd($cmd);
		if (!$rs) {
			$this->error = "Failed to execute external command!";
			return false;
		}
		return true;
	}
	function runCmd($cmd) {
		global $config;
		if ($config['app']['zip']['external']['debug']) {
			echo "Running ".$cmd."\r\n";
		}
		$return_code = false;
		$return_text = array();
		@exec($cmd, $return_text, $return_code);
		$this->output = $return_text;
		if ($return_code != 0) {
			if ($config['app']['zip']['external']['debug']) {
				echo " * returned code: ".$return_code."\r\n";
				echo " * returned text: "; print_r($return_text);
				flush();
			}
			return false;
		} else {
			return true;
		}
	}
}