<?php
class settings extends dataProcessing {
	function settings() {
		$this->table = "df_settings";
		if (!$GLOBALS['install']) {
			$this->getall();
		}
		if ($this->search_converters_text) {
			$lines = explode("\n", $this->search_converters_text);
			foreach ($lines as $line) {
				$line = trim($line);
				$parts = explode(" | ", $line);
				$this->search_index_converters[trim($parts['0'])] = array(
					"cmd" => trim($parts['1']),
					"args" => trim($parts['2']),
					"postargs" => trim($parts['3']),
					"flags" => explode(" ", trim($parts['4']))
				);
			}
		}
		if ($this->user_registration_default_groups) {
			$this->user_registration_default_groups = unserialize($this->user_registration_default_groups);
		}
	}

	function getall($update = false) {
		$c = new Cache();
		if (!$update) {
			$rs = $c->get('settings');
		}
		if (!$rs) {
			global $db;
			$rs = $db->GetAll('SELECT * FROM `'.$this->table.'`');
			$c->set('settings', $rs, 900);
		}
		if (is_array($rs)) {
			foreach ($rs as $record) {
				$this->$record['var'] = $record['val'];
			}
		}
	}

	function set($var, $val) {
		if (is_array($val)) {
			$val2 = serialize($val);
		} else {
			$val2 = $val;
		}
		$ex = $this->get($var);
		if ($ex) {
			$rs = $this->update(array("val" => $val2), array("`var`", "=", "'".$var."'"));
		} else {
			$rs = $this->insert(array("var" => $var, "val" => $val2));
		}
		if ($rs) {
			$this->$var = $val;
		}
		return $rs;
	}
	
	function get($var) {
		return $this->selectOne("*", array("`var`", "=", "'".$var."'"));
	}
	
	function asArray() {return get_object_vars($this);}
}