<?php
//abstract class for managing folder settings and options
class folders extends dataProcessing {
	function __construct() {
		global $paths;
		$this->paths = $paths;
	}

	function clear($path) {
		$pathId = $this->paths->getId($path);
		return $this->delete(array("pathid", "=", $pathId));
	}
	
	function clearRecursively($path) {
		$rs = $this->paths->getByFolder($path);
		foreach ($rs as $path) {
			$this->delete(array("pathid", "=", $path['id']));
		}
		return true;
	}
	
	function getId($pathId) {
		return $this->selectOneCol("id", array(
			array("pathid", "=", "'".$pathId."'")
		));
	}
	
	function getIdByPath($path) {
		$pathId = $this->paths->getId($path, true);
		if (!$pathId) {
			return false;
		} else {
			return $this->getId($pathId);
		}
	}
	
	function getByPath($path, $data = "*") {
		$pathId = $this->paths->getId($path, true);
		if (!$pathId) {
			return false;
		} else {
			return $this->select($data, array(
				array("pathid", "=", "'".$pathId."'")
			));
		}
	}
	
	function remove($path, $criteria) {
		$pathId = $this->paths->getId($path, true);
		return $this->delete(array(array("pathid", "=", $pathId), $criteria));
	}
	
	function set($path, $data, $once = false) {
		$pathId = $this->paths->getId($path, true);
		if ($once) {
			$fields = array_keys($data);
			$id = $this->selectOneCol("id", array(array("pathid", "=", $pathId), array($fields[0], "=", $data[$fields[0]])));
		} else {
			$id = $this->getId($pathId);
		}
		
		if ($id) {
			$rs = $this->update($data, array("id", "=", $id), false);
			if (!$rs) {
				$this->errorMsg = "folders: failed to update folder option.";
			}
		} else {
			$data['pathid'] = $pathId;
			$rs = $this->insert($data);
			if (!$rs) {
				$this->errorMsg = "folders: failed to insert folder option.";
			}
		}
		return $rs;
	}
}
?>