<?php

// UPDATED FOR FILERUN: 2015.03.03

$mustHaveTables = array(
    'df_logs',
    'df_modules_folders_notifications',
    'df_modules_metadata_dt',
    'df_modules_metadata_fields',
    'df_modules_metadata_fieldsets',
    'df_modules_metadata_files',
    'df_modules_metadata_values',
    'df_modules_notifications',
    'df_modules_search_index_queue',
    'df_modules_shares',
    'df_modules_trash',
    'df_modules_user_groups',
    'df_modules_user_roles',
    'df_modules_weblinks',
    'df_notifications_logs',
    'df_oauth_access_token_scopes',
    'df_oauth_access_tokens',
    'df_oauth_auth_code_scopes',
    'df_oauth_auth_codes',
    'df_oauth_client_redirect_uris',
    'df_oauth_clients',
    'df_oauth_refresh_tokens',
    'df_oauth_scopes',
    'df_oauth_session_scopes',
    'df_oauth_sessions',
    'df_paths',
    'df_relationships',
    'df_settings',
    'df_users',
    'df_users_permissions',
    'df_users_sessions'
);

$queries = array();


$queries[] = "CREATE TABLE IF NOT EXISTS `df_logs` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `action` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  `uid` mediumint(9) NOT NULL DEFAULT '0',
  `path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";



$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_folders_notifications` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uid` int(9) NOT NULL,
  `pathid` int(9) NOT NULL,
  `shareid` int(8) DEFAULT NULL,
  `notify_write` int(1) NOT NULL DEFAULT '0',
  `notify_read` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`pathid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";



$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_metadata_dt` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `owner` mediumint(9) NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ext` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "INSERT INTO `df_modules_metadata_dt` (`id`, `owner`, `name`, `description`, `ext`) VALUES
(NULL, 0, 'Photos', '', 'jpg,jpeg,gif,png,tiff,bmp'),
(NULL, 0, 'Documents', '', 'doc,docx,xls,xlsx,odf,odt,ods'),
(NULL, 0, 'Audio', '', 'aac,m4a,ac3,wma,au,avr,bonk,ds2,dss,flac,la,lw,pac,mp3,mka,ape,mpc,mp1,mp2,ogg,spx,ofs,ra,wav,cda,rka,shn,tta,wv,wvc'),
(NULL, 0, 'Video', '', 'mp4,mov,mpg,3gp,avi,mkv,asf,wmv,rm,swf,flv,mkv,webm,ogv')";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_metadata_fields` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `fsid` mediumint(9) NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `options` text COLLATE utf8_unicode_ci NOT NULL,
  `hide_fieldset_name_in_column` smallint(1) NOT NULL DEFAULT '0',
  `show_column_by_default` smallint(1) NOT NULL DEFAULT '0',
  `system` smallint(1) NOT NULL DEFAULT '0',
  `source` VARCHAR(255) NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "INSERT INTO `df_modules_metadata_fields` (`id`, `fsid`, `name`, `description`, `type`, `options`, `hide_fieldset_name_in_column`, `show_column_by_default`, `system`) VALUES (NULL, 0, 'comment', 'Comments (System)', '', '', 0, 0, 1)";
$queries[] = "INSERT INTO `df_modules_metadata_fields` (`id`, `fsid`, `name`, `description`, `type`, `options`, `hide_fieldset_name_in_column`, `show_column_by_default`, `system`) VALUES (NULL, 0, 'filelog', '', '', '', 0, 0, 1)";
$queries[] = "INSERT INTO `df_modules_metadata_fields` (`id`, `fsid`, `name`, `description`, `type`, `options`, `hide_fieldset_name_in_column`, `show_column_by_default`, `system`, `source`) VALUES (NULL, 0, 'btsync', 'BitTorrent Sync data', '', '', 0, 0, 1, NULL)";
$queries[] = "INSERT INTO  `df_modules_metadata_fields` (`id` ,`fsid` ,`name` ,`description` ,`type` ,`options` ,`hide_fieldset_name_in_column` ,`show_column_by_default` ,`system` ,`source`)VALUES (NULL ,  '0',  'label',  'Labels (System)',  '',  '',  '0',  '0',  '1', NULL)";

$queries[] = "INSERT INTO `df_modules_metadata_fields` (`id` ,`fsid` ,`name` ,`description` ,`type` ,`options` ,`hide_fieldset_name_in_column` ,`show_column_by_default` ,`system` ,`source`)VALUES ('0',  '0',  'star',  'Stars (System)',  '',  '',  '0',  '0',  '1', NULL)";
$queries[] = "INSERT INTO `df_modules_metadata_fields` (`id` ,`fsid` ,`name` ,`description` ,`type` ,`options` ,`hide_fieldset_name_in_column` ,`show_column_by_default` ,`system` ,`source`) VALUES ('0',  '0',  'filename',  'Search (System)',  '',  '',  '1',  '0',  '1', NULL)";



$queries[] = "INSERT INTO `df_modules_metadata_fields` (`id`, `fsid`, `name`, `description`, `type`, `options`, `hide_fieldset_name_in_column`, `show_column_by_default`, `system`, `source`) VALUES
(NULL, 2, 'Width', '', '', '', 1, 0, 0, 'info->video->resolution_x'),
(NULL, 2, 'Height', '', '', '', 1, 0, 0, 'info->video->resolution_y'),
(NULL, 3, 'Artist', '', '', '', 1, 0, 0, 'info->comments->artist'),
(NULL, 3, 'Title', '', '', '', 1, 0, 0, 'info->tags->id3v2->title'),
(NULL, 3, 'Duration', '', '', '', 1, 0, 0, 'info->playtime_string'),
(NULL, 3, 'Album', '', '', '', 1, 0, 0, 'info->comments->album'),
(NULL, 2, 'Codec', '', '', '', 0, 0, 0, 'info->video->codec'),
(NULL, 3, 'Codec', '', '', '', 0, 0, 0, 'info->audio->codec'),
(NULL, 4, 'Author', '', '', '', 1, 0, 0, ''),
(NULL, 4, 'Description', '', '', '', 1, 0, 0, '')";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_metadata_fieldsets` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `owner` mediumint(9) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `generic` smallint(1) NOT NULL DEFAULT '0',
  `system` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "INSERT INTO `df_modules_metadata_fieldsets` (`id`, `owner`, `name`, `description`, `generic`, `system`) VALUES (NULL, 0, 'Comments (System)', 'Required for the file commenting system', 1, 1)";
$queries[] = "INSERT INTO `df_modules_metadata_fieldsets` (`id`, `owner`, `name`, `description`, `generic`, `system`) VALUES
(NULL, 0, 'Image proprieties', '', 0, 0),
(NULL, 0, 'Audio proprieties', '', 0, 0),
(NULL, 0, 'Various information', '', 1, 0),
(NULL, '0', 'Label (System)', 'Required for the label system', '1', '1')";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_metadata_files` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `pid` INT( 9 ) NOT NULL,
  `type_id` MEDIUMINT( 9 ) NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_metadata_values` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `date_added` datetime NOT NULL,
  `date_modified` DATETIME NULL DEFAULT NULL,
  `uid` mediumint(9) NOT NULL,
  `share_id` MEDIUMINT( 9 ) NULL DEFAULT NULL,
  `file_id` mediumint(9) NOT NULL,
  `field_id` mediumint(9) NOT NULL,
  `val` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date_added` (`date_added`),
  KEY `uid` (`uid`,`file_id`,`field_id`),
  KEY `file_id` (`file_id`,`field_id`),
  KEY `uid_2` (`uid`,`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_notifications` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `owner` mediumint(9) DEFAULT NULL,
  `object_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `object_id` mediumint(9) NOT NULL DEFAULT '0',
  `action` text COLLATE utf8_unicode_ci NOT NULL,
  `email_address` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";



$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_search_index_queue` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(9) NOT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_shares` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(9) NOT NULL,
  `created` datetime NOT NULL,
  `path` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `alias` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `with_gid` MEDIUMINT( 9 ) NULL DEFAULT NULL,
  `with_uid` MEDIUMINT( 9 ) NULL DEFAULT NULL,
  `anonymous` smallint(1) NOT NULL DEFAULT '0',
  `perms_upload` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `perms_download` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `perms_comment` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `perms_read_comments` smallint(1) NOT NULL DEFAULT '0',
  `perms_alter` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_trash` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(9) NOT NULL,
  `relative_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date_deleted` datetime NOT NULL,
  `filesize` bigint(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_user_groups` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `owner` mediumint(9) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_user_roles` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `owner` MEDIUMINT( 9 ) NULL DEFAULT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `admin_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `admin_users` smallint(1) NOT NULL DEFAULT '0',
  `admin_roles` smallint(1) NOT NULL DEFAULT '0',
  `admin_notifications` smallint(1) NOT NULL DEFAULT '0',
  `admin_logs` smallint(1) NOT NULL DEFAULT '0',
  `admin_metadata` smallint(1) NOT NULL DEFAULT '0',
  `admin_over` text COLLATE utf8_unicode_ci NOT NULL,
  `admin_max_users` smallint(7) NOT NULL DEFAULT '0',
  `admin_homefolder_template` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `homefolder` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `create_folder` smallint(1) NOT NULL DEFAULT '1',
  `space_quota_max` int(20) DEFAULT NULL,
  `space_quota_current` int(20) NOT NULL DEFAULT '0',
  `traffic_quota_max` int(20) DEFAULT NULL,
  `readonly` smallint(1) DEFAULT NULL,
  `upload` smallint(1) DEFAULT NULL,
  `download` smallint(1) DEFAULT NULL,
  `download_folders` smallint(1) DEFAULT NULL,
  `read_comments` smallint(1) DEFAULT NULL,
  `write_comments` smallint(1) DEFAULT NULL,
  `email` smallint(1) NOT NULL DEFAULT '0',
  `weblink` smallint(1) NOT NULL DEFAULT '0',
  `share` smallint(1) NOT NULL DEFAULT '0',
  `btsync` smallint(1) NOT NULL DEFAULT '0',
  `metadata` smallint(1) NOT NULL DEFAULT '0',
  `file_history` smallint(1) NOT NULL DEFAULT '0',
  `users_may_see` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-ALL-',
  `change_pass` smallint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_modules_weblinks` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `id_rnd` VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL,
  `uid` mediumint(9) NOT NULL,
  `pathid` mediumint(9) NOT NULL,
  `share_id` MEDIUMINT( 9 ) NULL DEFAULT NULL,
  `short_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expiry` datetime DEFAULT NULL,
  `download_limit` mediumint(6) DEFAULT NULL,
  `allow_uploads` int(1) NOT NULL DEFAULT '0',
  `force_save` tinyint(1) DEFAULT '0',
  `system` smallint(1) NOT NULL DEFAULT '0',
  `notify` mediumint(1) NOT NULL DEFAULT '0',
  `download_terms` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_rnd` (`id_rnd`),
  KEY `uid` (`uid`,`pathid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_notifications_logs` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `has_errors` smallint(1) NOT NULL DEFAULT '0',
  `data` longtext COLLATE utf8_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_paths` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` VARCHAR(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `filename` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `depth` SMALLINT( 3 ) NOT NULL DEFAULT  '0',
  `date_added` datetime NOT NULL,
  `uniq` CHAR( 32 ) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY (`uniq`),
  INDEX (`filename`, `depth`),
  INDEX `path` (`path`(255))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_relationships` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `related_to_id` mediumint(9) NOT NULL DEFAULT '0',
  `object_id` mediumint(9) NOT NULL DEFAULT '0',
  `relation_type` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `object_id` (`object_id`,`relation_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "INSERT INTO `df_relationships` (`id`, `related_to_id`, `object_id`, `relation_type`) VALUES
(NULL, 1, 2, 'meta-fs2dt'),
(NULL, 4, 2, 'meta-fs2dt'),
(NULL, 4, 3, 'meta-fs2dt'),
(NULL, 3, 3, 'meta-fs2dt')";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_settings` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `var` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `val` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `var` (`var`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "INSERT INTO `df_settings` (`id`, `var`, `val`) VALUES
(NULL, 'currentVersion', '2015.03.03'),
(NULL, 'app_title', 'FileRun'),
(NULL, 'thumbnails_imagemagick_path', '/usr/bin/convert'),
(NULL, 'smtp_enable', '0'),
(NULL, 'smtp_host', ''),
(NULL, 'smtp_port', ''),
(NULL, 'smtp_username', ''),
(NULL, 'smtp_password', ''),
(NULL, 'smtp_auth', '0'),
(NULL, 'last_email_notification', ''),
(NULL, 'instant_email_notifications', '1'),
(NULL, 'default_notification_address', 'configure-me@example.com'),
(NULL, 'user_registration_enable', '0'),
(NULL, 'user_registration_generate_passwords', '1'),
(NULL, 'user_registration_email_verification', '0'),
(NULL, 'user_registration_approval', '0'),
(NULL, 'user_registration_reqfields_email', '1'),
(NULL, 'user_registration_reqfields_company', '0'),
(NULL, 'user_registration_reqfields_website', '0'),
(NULL, 'user_registration_reqfields_description', '0'),
(NULL, 'user_registration_default_groups', 'a:0:{}'),
(NULL, 'user_registration_default_role', ''),
(NULL, 'captcha', '0'),
(NULL, 'allow_change_pass', '1'),
(NULL, 'max_login_attempts', '5'),
(NULL, 'allow_persistent_login', '1'),
(NULL, 'logout_redirect', ''),
(NULL, 'password_recovery_enable', '1'),
(NULL, 'password_recovery_force_change', '1'),
(NULL, 'search_enable', '0'),
(NULL, 'search_converters_text', ''),
(NULL, 'thumbnails_enable', '1'),
(NULL, 'thumbnails_imagemagick', '0'),
(NULL, 'thumbnails_size', '160'),
(NULL, 'thumbnails_imagemagick_ext', 'psd,eps,png,tst,plt,ai,pdf,cr2,nef,tif'),
(NULL, 'thumbnails_ffmpeg', '0'),
(NULL, 'thumbnails_ffmpeg_path', '/usr/bin/ffmpeg'),
(NULL, 'thumbnails_ffmpeg_ext', 'mpg,mpeg,mp4,mov,avi,divx,mkv,wmv,rm,flv,asx,asf,swf,3gp,3g2,m4v,m2ts,mts,m2v'),
(NULL, 'system_traffic_quota_reset_date', ''),
(NULL, 'disable_versioning', '0'),
(NULL, 'quota_warning_level', '90'),
(NULL, 'user_registration_change_pass', '1'),
(NULL, 'ui_default_language', 'english'),
(NULL, 'ui_display_language_menu', '1'),
(NULL, 'ui_double_click', 'preview'),
(NULL, 'ui_login_logo', ''),
(NULL, 'ui_login_text', ''),
(NULL, 'ui_login_title', ''),
(NULL, 'ui_title_logo', '1'),
(NULL, 'ui_logo_url', NULL),
(NULL, 'ui_dnd_show_selector', '1'),
(NULL, 'ui_default_view', 'thumbnails'),
(NULL, 'ui_enable_flash_upload', '1'),
(NULL, 'ui_default_upload_mode', 'flash'),
(NULL, 'ui_enable_dnd_upload', '1'),
(NULL, 'upload_blocked_types', ''),
(NULL, 'dnd_chunk_size', '2'),
(NULL, 'allow_folder_notifications', '1'),
(NULL, 'disable_file_history', '0'),
(NULL, 'pushercom_app_id', ''),
(NULL, 'pushercom_app_key', ''),
(NULL, 'pushercom_app_secret', ''),
(NULL, 'pushercom_enable', '0'),
(NULL, 'file_history_entry_lifetime', '7'),
(NULL, 'user_activity_logs_entry_lifetime', '7'),
(NULL, 'btsync_enable', '0'),
(NULL, 'btsync_api_password', ''),
(NULL, 'btsync_api_username', ''),
(NULL, 'btsync_api_port', '8888'),
(NULL, 'btsync_api_host', '127.0.0.1'),
(NULL, 'maintenance', '0'),
(NULL, 'maintenance_message_public', 'Our website is currently undergoing scheduled maintenance. Will be back online shortly.\nThank you for your patience!'),
(NULL, 'maintenance_message_users', 'This application is currently undergoing scheduled maintenance. Will be back online shortly.\nThank you for your patience!'),
(NULL, 'send_from_custom_email', '0'),
(NULL ,  'passwords_min_length',  '12'),
(NULL ,  'passwords_letters_and_digits',  '1'),
(NULL ,  'passwords_requires_uppercase',  '1'),
(NULL ,  'passwords_requires_special',  '1'),
(NULL ,  'passwords_prevent_seq',  '1'),
(NULL ,  'passwords_prevent_common',  '1'),
(NULL ,  'passwords_life_time',  '120'),
(NULL, 'auth_plugin', ''),
(NULL, 'auth_allow_local', '1'),
(NULL, 'google_shortener_key', 'AIzaSyBlhJjno7mLK1Xf0SKKHjLsmEGcSg4m62g')";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_users` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `two_step_enabled` INT( 1 ) NOT NULL DEFAULT  '0',
  `two_step_secret` VARCHAR( 100 ) NULL,
  `last_otp` VARCHAR( 35 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `last_pass_change` DATE NULL DEFAULT NULL,
  `cookie` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `owner` mediumint(9) DEFAULT NULL,
  `registration_date` DATETIME NULL DEFAULT NULL,
  `activated` smallint(1) NOT NULL DEFAULT '0',
  `expiration_date` datetime DEFAULT NULL,
  `require_password_change` int(1) NOT NULL DEFAULT '0',
  `failed_login_attempts` smallint(1) NOT NULL DEFAULT '0',
  `last_access_date` timestamp NULL DEFAULT NULL,
  `last_notif_delivery_date` timestamp NULL DEFAULT NULL,
  `last_login_date` datetime NOT NULL,
  `last_logout_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `email` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `receive_notifications` SMALLINT( 1 ) NOT NULL DEFAULT  '0',
  `new_email` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `company` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `website` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `description` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `logo_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";


$queries[] = "INSERT INTO `df_users` (`id`, `username`, `password`, `last_otp`, `last_pass_change`, `cookie`, `owner`, `registration_date`, `activated`, `expiration_date`, `require_password_change`, `failed_login_attempts`, `last_access_date`, `last_notif_delivery_date`, `last_login_date`, `last_logout_date`, `email`, `receive_notifications`, `new_email`, `name`, `company`, `website`, `description`, `logo_url`) VALUES
(1, 'admin', MD5('admin'), '', NOW(), '', NULL, '0000-00-00 00:00:00', 1, NULL, 0, 0, NULL, NULL, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 0, '', 'Superuser', '', '', '', NULL)";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_users_permissions` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(9) NOT NULL,
  `role` mediumint(9) DEFAULT NULL,
  `admin_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `admin_users` smallint(1) NOT NULL DEFAULT '0',
  `admin_roles` smallint(1) NOT NULL DEFAULT '0',
  `admin_notifications` smallint(1) NOT NULL DEFAULT '0',
  `admin_logs` smallint(1) NOT NULL DEFAULT '0',
  `admin_metadata` smallint(1) NOT NULL DEFAULT '0',
  `admin_over` TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `admin_max_users` smallint(7) NOT NULL DEFAULT '0',
  `admin_homefolder_template` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `homefolder` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `space_quota_max` int(20) DEFAULT NULL,
  `space_quota_current` int(20) NOT NULL DEFAULT '0',
  `traffic_quota_max` int(20) DEFAULT NULL,
  `traffic_quota_current` int(20) NOT NULL DEFAULT '0',
  `readonly` smallint(1) DEFAULT NULL,
  `upload` smallint(1) DEFAULT NULL,
  `download` smallint(1) DEFAULT NULL,
  `download_folders` smallint(1) DEFAULT NULL,
  `read_comments` smallint(1) DEFAULT NULL,
  `write_comments` smallint(1) DEFAULT NULL,
  `email` smallint(1) NOT NULL DEFAULT '0',
  `weblink` smallint(1) NOT NULL DEFAULT '0',
  `share` smallint(1) NOT NULL DEFAULT '0',
  `btsync` smallint(1) NOT NULL DEFAULT '0',
  `metadata` smallint(1) NOT NULL DEFAULT '0',
  `file_history` smallint(1) NOT NULL DEFAULT '0',
  `users_may_see` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-ALL-',
  `change_pass` smallint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "INSERT INTO `df_users_permissions` (`id`, `uid`, `role`, `admin_type`, `admin_users`, `admin_roles`, `admin_notifications`, `admin_logs`, `admin_metadata`, `admin_over`, `admin_max_users`, `admin_homefolder_template`, `homefolder`, `space_quota_max`, `space_quota_current`, `traffic_quota_max`, `traffic_quota_current`, `readonly`, `upload`, `download`, `download_folders`, `read_comments`, `write_comments`, `email`, `weblink`, `share`, `metadata`, `file_history`, `users_may_see`, `change_pass`) VALUES
(1, 1, NULL, NULL, 0, 0, 0, 0, 0, '', 0, '', '/', NULL, 0, NULL, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, '-ALL-', 1)";


$queries[] = "CREATE TABLE IF NOT EXISTS `df_users_sessions` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ip_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";



$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_access_tokens` (
			`id` mediumint(8) NOT NULL AUTO_INCREMENT,
		  `access_token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `sid` mediumint(8) NOT NULL,
		  `expiry` int(11) NOT NULL,
		  PRIMARY KEY (`id`),
		  UNIQUE KEY `access_token` (`access_token`),
		  KEY `sid` (`sid`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_access_token_scopes` (
		  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
		  `access_token_id` mediumint(8) NOT NULL,
		  `scope` mediumint(8) NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `access_token_id` (`access_token_id`),
		  KEY `scope` (`scope`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_auth_codes` (
			`id` mediumint(8) NOT NULL AUTO_INCREMENT,
		  `auth_code` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `sid` mediumint(8) NOT NULL,
		  `redirect_uri` text COLLATE utf8_unicode_ci NOT NULL,
		  `expiry` int(11) DEFAULT NULL,
		  PRIMARY KEY (`id`),
		  KEY `sid` (`sid`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_auth_code_scopes` (
			`id` mediumint(9) NOT NULL AUTO_INCREMENT,
		  `auth_code_id` mediumint(9) NOT NULL,
		  `scope` mediumint(8) NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `auth_code_id` (`auth_code_id`),
		  KEY `scope` (`scope`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_clients` (
			`id` mediumint(9) NOT NULL AUTO_INCREMENT,
		  `enabled` smallint(1) NOT NULL DEFAULT '0',
		  `cid` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `secret` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `publisher` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
		  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
		  `website` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
		  PRIMARY KEY (`id`),
		  UNIQUE KEY `cid` (`cid`)
		) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_client_redirect_uris` (
			`id` mediumint(8) NOT NULL AUTO_INCREMENT,
		  `cid` mediumint(8) NOT NULL,
		  `uri` text COLLATE utf8_unicode_ci NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `cid` (`cid`)
		) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_refresh_tokens` (
			`id` mediumint(8) NOT NULL AUTO_INCREMENT,
		  `refresh_token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `access_token_id` mediumint(9) NOT NULL,
		  `expiry` int(11) NOT NULL,
		  PRIMARY KEY (`id`),
		  UNIQUE KEY `refresh_token` (`refresh_token`),
		  KEY `access_token_id` (`access_token_id`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_scopes` (
			`id` mediumint(8) NOT NULL AUTO_INCREMENT,
		  `scope` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "INSERT INTO `df_oauth_scopes` (`scope`, `description`) VALUES
			('profile', ''),
			('download', ''),
			('upload', ''),
			('modify', ''),
			('delete', ''),
			('list', ''),
			('email', ''),
			('weblink', ''),
			('upload.sandbox', ''),
			('weblink.sandbox', ''),
			('delete.sandbox', ''),
			('admin', ''),
			('list.sandbox', ''),
			('download.sandbox', '')";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_sessions` (
			`id` mediumint(8) NOT NULL AUTO_INCREMENT,
		  `owner_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `owner_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
		  `cid` mediumint(8) NOT NULL,
		  `redirect_uri` text COLLATE utf8_unicode_ci,
		  `date_created` DATETIME NULL DEFAULT NULL,
		  `client_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
		  `owner_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
		  PRIMARY KEY (`id`),
		  KEY `cid` (`cid`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "CREATE TABLE IF NOT EXISTS `df_oauth_session_scopes` (
			`id` mediumint(9) NOT NULL AUTO_INCREMENT,
		  `sid` mediumint(9) NOT NULL,
		  `scope` mediumint(9) NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `sid` (`sid`),
		  KEY `scope` (`scope`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";

$queries[] = "ALTER TABLE `df_oauth_access_tokens`
		  ADD CONSTRAINT `df_oauth_access_tokens_ibfk_1` FOREIGN KEY (`sid`) REFERENCES `df_oauth_sessions` (`id`) ON DELETE CASCADE";

$queries[] = "ALTER TABLE `df_oauth_access_token_scopes`
		  ADD CONSTRAINT `df_oauth_access_token_scopes_ibfk_1` FOREIGN KEY (`access_token_id`) REFERENCES `df_oauth_access_tokens` (`id`) ON DELETE CASCADE,
		  ADD CONSTRAINT `df_oauth_access_token_scopes_ibfk_2` FOREIGN KEY (`scope`) REFERENCES `df_oauth_scopes` (`id`) ON DELETE CASCADE";

$queries[] = "ALTER TABLE `df_oauth_auth_codes`
		  ADD CONSTRAINT `df_oauth_auth_codes_ibfk_1` FOREIGN KEY (`sid`) REFERENCES `df_oauth_sessions` (`id`) ON DELETE CASCADE";

$queries[] = "ALTER TABLE `df_oauth_auth_code_scopes`
		  ADD CONSTRAINT `df_oauth_auth_code_scopes_ibfk_1` FOREIGN KEY (`auth_code_id`) REFERENCES `df_oauth_auth_codes` (`id`) ON DELETE CASCADE,
		  ADD CONSTRAINT `df_oauth_auth_code_scopes_ibfk_2` FOREIGN KEY (`scope`) REFERENCES `df_oauth_scopes` (`id`) ON DELETE CASCADE";

$queries[] = "ALTER TABLE `df_oauth_client_redirect_uris`
		  ADD CONSTRAINT `df_oauth_client_redirect_uris_ibfk_1` FOREIGN KEY (`cid`) REFERENCES `df_oauth_clients` (`id`) ON DELETE CASCADE";

$queries[] = "ALTER TABLE `df_oauth_refresh_tokens`
		  ADD CONSTRAINT `df_oauth_refresh_tokens_ibfk_1` FOREIGN KEY (`access_token_id`) REFERENCES `df_oauth_access_tokens` (`id`) ON DELETE CASCADE";

$queries[] = "ALTER TABLE `df_oauth_sessions`
		  ADD CONSTRAINT `df_oauth_sessions_ibfk_1` FOREIGN KEY (`cid`) REFERENCES `df_oauth_clients` (`id`) ON DELETE CASCADE";

$queries[] = "ALTER TABLE `df_oauth_session_scopes`
		  ADD CONSTRAINT `df_oauth_session_scopes_ibfk_1` FOREIGN KEY (`scope`) REFERENCES `df_oauth_scopes` (`id`) ON DELETE CASCADE,
		  ADD CONSTRAINT `df_oauth_session_scopes_ibfk_2` FOREIGN KEY (`sid`) REFERENCES `df_oauth_sessions` (`id`) ON DELETE CASCADE";



foreach ($queries as $query) {
	$rs = @mysql_query($query);
	if (!$rs) {
		jsonFeedback(false, "MySQL error: ".mysql_error().", in: ".$query);
	}
}
