<?php
class metadata_fieldsets extends dataProcessing {
	function metadata_fieldsets() {
		$this->rel = new relationship();
		$this->relType = "meta-fs2dt";
		$this->table = "df_modules_metadata_fieldsets";
	}
	function bindToDocumentType($fieldsetId, $documentTypeId) {
		return $this->rel->setRelation($fieldsetId, $documentTypeId, $this->relType);
	}
	function removeFromDocumentType($fieldsetId, $documentTypeId) {
		return $this->rel->unRelate($fieldsetId, $documentTypeId, $this->relType);
	}
	function unBind($documentTypeId) {
		return $this->rel->clearAllRelatedToThis($documentTypeId, $this->relType);
	}
	function unBindFromAll($fieldsetId) {
		return $this->rel->clearRelation($fieldsetId, $this->relType);
	}
	function getForDocumentType($documentTypeId) {
		$relations = $this->rel->getAllRelatedTo($documentTypeId, $this->relType);
		$ids = array();
		foreach ($relations as $rel) {
			$ids[] = $rel['object_id'];
		}
		if (sizeof($ids) > 0) {
			return $this->select("*", array("id", "IN", "('".implode("','", $ids)."')"));
		} else {
			return false;
		}
	}
}
?>