<?php
$locale->setSection("Admin: Metadata: Fields");

if (!$users->userPerms->canManageMetadata()) {
	jsonFeedback(false, $locale->get("You are not allowed to manage the metadata settings.", "Admin: Metadata"));
}

$fid = $str->fromHTML($_POST['id']);
$fieldInfo = $metadata->fields->getById("*", $fid);

if (!$fieldInfo) {
	jsonFeedback(false, $locale->get("Field not found!", "Admin: Metadata"));
}

$setInfo = $metadata->fieldsets->getById("*", $sid);

if ($users->userPerms->isIndependentAdmin()) {
	if ($setInfo['owner'] && $setInfo['owner'] != $auth->currentUserInfo['id']) {
		jsonFeedback(false, "You are not allowed to manage this field set.");
	}
}

if ($config['misc']['demoMode']) {
	jsonFeedback(false, "Action unavailable in this demo version of the software!");
} else {
	$rs = $metadata->deleteField($fid);
	if ($rs) {
		jsonFeedback(true, "Field succcessfuly deleted");
	} else {
		jsonFeedback(false, "Failed to delete field!");
	}
}