<?php
$locale->setSection("Admin: Metadata: Fieldsets");

if (!$users->userPerms->canManageMetadata()) {
	jsonFeedback(false, $locale->get("You are not allowed to manage the metadata settings.", "Admin: Metadata"));
}

$sid = $str->fromHTML($_REQUEST['id']);
$setInfo = $metadata->fieldsets->getById("*", $sid);
if (!$setInfo) {
	jsonFeedback(false, $locale->get("Field set not found!", "Admin: Metadata"));
}

if ($users->userPerms->isIndependentAdmin()) {
	if ($setInfo['owner'] && $setInfo['owner'] != $auth->currentUserInfo['id']) {
		jsonFeedback(false, "You are not allowed to manage this field set.");
	}
}

if ($config['misc']['demoMode']) {
	jsonFeedback(false, "Action unavailable in this demo version of the software!");
} else {
	$rs = $metadata->deleteFieldSet($sid);
	if ($rs) {
		jsonFeedback(true, "Field set successfuly deleted");
	} else {
		jsonFeedback(false, "Failed to delete field set!");
	}
}