<?php
$locale->setSection("Admin: Metadata: Filetypes");

if (!$users->userPerms->canManageMetadata()) {
	jsonFeedback(false, $locale->get("You are not allowed to manage the metadata settings.", "Admin: Metadata"));
}

$dtid = $str->fromHTML($_REQUEST['id']);
$dtInfo = $metadata->dt->getById("*", $dtid);
if (!$dtInfo) {
	jsonFeedback(false, $locale->get("File type not found!", "Admin: Metadata"));
}

if ($users->userPerms->isIndependentAdmin()) {
	if ($dtInfo['owner'] && $dtInfo['owner'] != $auth->currentUserInfo['id']) {
		jsonFeedback(false, "You are not allowed to manage this file type.");
	}
}

if ($config['misc']['demoMode']) {
	jsonFeedback(false, "Action unavailable in this demo version of the software!");
} else {
	$rs = $metadata->deleteDocumentType($dtid);
	if ($rs) {
		jsonFeedback(true, "File type succcessfuly deleted!");
	} else {
		jsonFeedback(false, "Failed to delete file type!");
	}
}