<?php
$locale->setSection("Admin: API");
$clientId = $str->fromHTML($_POST['id']);

if (!$users->userPerms->isSuperUser()) {
	jsonFeedback(false, "You are not allowed to access this page.");
}
$clients = new FileRun\OAuth2\ClientManager;
$clientInfo = $clients->getInfo($clientId);

if ($_GET['action'] == "save") {
	if ($config['misc']['demoMode']) {
		jsonFeedback(false, "Action unavailable in this demo version of the software!");
	} else {
		$data['enabled'] = oneOrZero($_POST['enabled']);
		$data['name'] = trim(fromHTML($_POST['name']));
		$data['description'] = fromHTML($_POST['description']);
		//$data['cid'] = fromHTML($_POST['cid']);
		//$data['secret'] = fromHTML($_POST['secret']);
		$data['publisher'] = trim(fromHTML($_POST['publisher']));
		$data['website'] = trim(fromHTML($_POST['website']));
		$URIs = explode("\n", fromHTML($_POST['redirect_uris']));
		foreach($URIs as $k => $URI) {
			$URI = trim($URI);
			if (!$clients->isValidURI($URI)) {
				jsonFeedback(false, 'One of the provided URIs is not valid');
			}
			$URIs[$k] = $URI;
		}
		$rs = $clients->update($data, array('id', '=', $clientInfo['id']));
		if ($rs) {
			$clients->setURIs($URIs, $clientInfo['id']);
			jsonFeedback(true, 'Oauth2 client successfully updated');
		} else {
			jsonFeedback(false, "Failed to save changes!");
		}
	}
}
$app['clientInfo'] = json_encode($clientInfo);

FileRun::displaySmartyPage();