<?php
global $config, $fm, $str, $settings;
if (!ArchUtil::isSupported($data['filePath'])) {
	$genericPreview = gluePath($data['viewersPath'], "generic", "index.php");
    require($genericPreview);
}
$arch = ArchUtil::init($data['filePath']);
if (!$arch) {
	exit("This type of archives is not supported by the current server configuration.");
}
$arch->open();
$list = $arch->getTOC(100);
if (!is_array($list)) {
	exit("Failed to read archive contents!");
}
$arch->close();
$count = $arch->itemsCount;
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title></title>
	<link rel="stylesheet" type="text/css" href="css/ext.php?v=<?php echo $settings->currentVersion;?>" />
	<script type="text/javascript" src="js/min.php?extjs=1&v=<?php echo $settings->currentVersion;?>"></script>
	<script type="text/javascript" src="viewers/arch/grid.js?v=<?php echo $settings->currentVersion;?>"></script>
</head>

<body>
	<table id="theTable" width="100%">
		<thead>
			<tr class="header">
				<th name="filename">File name</td>
				<th name="size">Size</td>
				<th name="path">Path</td>
			</tr>
		</thead>
		<tbody>
		<?php
		$limit = 50;
		$i = 0;
		foreach ($list as $key => $item) {
			if ($i == $limit) {
				?>
				<tr>
					<td>Archive contains <?php echo $count-$limit;?> files more that are not displayed in this preview.</td>
					<td>&nbsp;</td>
				</tr>
				<?php
				break;
			}
			if ($item['checksum'] != "00000000") {
				if ($item['utf8_encoded']) {
					$srcEnc = "UTF-8";
				} else {
					if ($config['app']['encoding']['unzip']) {//convert from a predefined encoding
						$srcEnc = $config['app']['encoding']['unzip'];
					} else {
						$srcEnc = $str->detectEncoding($item['filename']);
					}
				}
				$item['filename'] = $str->convertEncoding($item['filename'], $srcEnc, $config['app']['encoding']['convert']['toHTML']['to']);
				if ($item['type'] == "file" && $item['filename']) {
				?>
				<tr>
					<td><img src="<?php echo $fm->getFileIconURL($item['filename'], $size = "small");?>" border="0" height="16" width="16"> <?php echo $str->safeHTML($item['filename']);?></td>
					<td width="100"><?php echo $fm->formatFileSize($item['filesize']);?></td>
					<td><?php echo $str->forHTML(gluePath("/", $item['path']), 1);?></td>
				</tr>
				<?php
				$i++;
				}
			}
		}
		?>
		</tbody>
	</table>
</body>
</html>